/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tardis.api.space.IOxygenSealer;
import net.tardis.mod.Tardis;
import net.tardis.mod.blocks.exteriors.ExteriorBlock;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.ai.FollowOutOfTardisGoal;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.events.LivingEvents;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.LandingSystem;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.misc.IDoorSoundScheme;
import net.tardis.mod.misc.IDoorType;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.network.packets.exterior.DoorData;
import net.tardis.mod.registries.TardisStatistics;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.ShieldGeneratorSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.world.dimensions.TDimensions;

public class DoorEntity
extends Entity {
    public static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(DoorEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> SUCC = EntityDataManager.func_187226_a(DoorEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public IDoorType doorType = IDoorType.EnumDoorType.STEAM;
    private List<UUID> teleportImmune = new ArrayList<UUID>();
    private boolean isLocked = false;
    private int additionalLockLevel = 0;
    private float health = 10.0f;

    public DoorEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public DoorEntity(World worldIn) {
        this((EntityType)TEntities.DOOR.get(), worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(STATE, (Object)EnumDoorState.CLOSED.ordinal());
        this.field_70180_af.func_187214_a(SUCC, (Object)false);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.func_184212_Q().func_187227_b(STATE, (Object)compound.func_74762_e("door_state"));
        this.func_184212_Q().func_187227_b(SUCC, (Object)compound.func_74767_n("succ"));
        this.isLocked = compound.func_74767_n("locked");
        this.additionalLockLevel = compound.func_74762_e("additional_lock_level");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("door_state", ((Integer)this.field_70180_af.func_187225_a(STATE)).intValue());
        compound.func_74757_a("locked", this.isLocked);
        compound.func_74757_a("succ", ((Boolean)this.func_184212_Q().func_187225_a(SUCC)).booleanValue());
        compound.func_74768_a("additional_lock_level", this.additionalLockLevel);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_174812_G() {
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source.func_76347_k();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TItems.INT_DOOR.get());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ConsoleTile console = this.getConsole();
        if (console == null) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getOpenState() != EnumDoorState.CLOSED && this.field_70173_aa > 5) {
                List entities = this.field_70170_p.func_217357_a(Entity.class, this.getDoorBB().func_191194_a(this.func_213303_ch()));
                this.teleportEntity(entities);
                ArrayList<UUID> list = new ArrayList<UUID>();
                for (Entity e : entities) {
                    if (!this.teleportImmune.contains(e.func_110124_au())) continue;
                    list.add(e.func_110124_au());
                }
                this.teleportImmune = list;
            }
            if (this.field_70170_p.func_82737_E() % 100L == 0L) {
                this.handleSucking();
            }
            if (this.field_70170_p.func_82737_E() % 20L == 0L) {
                ServerWorld otherW = this.field_70170_p.func_73046_m().func_71218_a(console.getCurrentDimension());
                ShieldGeneratorSubsystem shield = (ShieldGeneratorSubsystem)console.getSubsystem(ShieldGeneratorSubsystem.class).orElse(null);
                if (this.getOpenState() != EnumDoorState.CLOSED && shield != null && !shield.isActivated()) {
                    BlockPos bottomBlock = console.getCurrentLocation().func_177972_a(console.getTrueExteriorFacingDirection());
                    BlockPos topBlock = console.getCurrentLocation().func_177972_a(console.getTrueExteriorFacingDirection());
                    FluidState topFluid = otherW.func_204610_c(topBlock);
                    FluidState bottomFluid = otherW.func_204610_c(bottomBlock);
                    WorldHelper.setFluidStateIfNot(topFluid, this.field_70170_p, this.func_233580_cy_().func_177984_a());
                    WorldHelper.setFluidStateIfNot(Fluids.field_204541_a.func_207188_f(), (World)otherW, topBlock);
                    WorldHelper.setFluidStateIfNot(bottomFluid, this.field_70170_p, this.func_233580_cy_());
                    WorldHelper.setFluidStateIfNot(Fluids.field_204541_a.func_207188_f(), (World)otherW, bottomBlock);
                } else {
                    WorldHelper.setFluidStateIfNot(Fluids.field_204541_a.func_207188_f(), this.field_70170_p, this.func_233580_cy_());
                    WorldHelper.setFluidStateIfNot(Fluids.field_204541_a.func_207188_f(), this.field_70170_p, this.func_233580_cy_().func_177984_a());
                }
            }
        }
        this.doorType = console.getExteriorType().getDoorType();
        if ((console.isInFlight() || ((Boolean)this.func_184212_Q().func_187225_a(SUCC)).booleanValue()) && this.getOpenState() != EnumDoorState.CLOSED) {
            this.suckIntoVoid();
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && this.getConsole() != null) {
            ExteriorTile ext = (ExteriorTile)this.getConsole().getOrFindExteriorTile().orElse(null);
            if (ext != null) {
                if (player.func_225608_bj_()) {
                    if (!ext.isExteriorDeadLocked() && !ext.isInteriorRegenerating()) {
                        if (this.isLocked) {
                            this.isLocked = false;
                            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)TSounds.DOOR_UNLOCK.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            this.playSoundAtExterior(ext, (SoundEvent)TSounds.DOOR_UNLOCK.get(), SoundCategory.BLOCKS, 1.0f);
                            if (ext != null) {
                                ext.setLocked(false);
                            }
                            player.func_146105_b((ITextComponent)ExteriorBlock.UNLOCKED, true);
                            return ActionResultType.SUCCESS;
                        }
                        if (ext.isExteriorDeadLocked()) {
                            if (this.additionalLockLevel != ext.getAdditionalLockLevel()) {
                                ext.setAdditionalLockLevel(this.additionalLockLevel);
                                ext.updateSpecific(DoorData.create(ext));
                            }
                            if (ext.isInteriorRegenerating()) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent(ExteriorBlock.INTERIOR_CHANGE, new Object[]{ext.getRemainingInteriorChangeTime()}), true);
                            } else {
                                player.func_146105_b((ITextComponent)ExteriorBlock.DEADLOCKED, true);
                            }
                            return ActionResultType.SUCCESS;
                        }
                        this.isLocked = true;
                        this.setOpenState(EnumDoorState.CLOSED);
                        this.openAndUpdateExteriorDoor();
                        if (ext != null) {
                            ext.setLocked(this.isLocked);
                        }
                        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)TSounds.DOOR_LOCK.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        this.playSoundAtExterior(ext, (SoundEvent)TSounds.DOOR_LOCK.get(), SoundCategory.BLOCKS, 1.0f);
                        player.func_146105_b((ITextComponent)ExteriorBlock.LOCKED, true);
                        return ActionResultType.SUCCESS;
                    }
                } else {
                    if (this.additionalLockLevel != ext.getAdditionalLockLevel()) {
                        ext.setAdditionalLockLevel(this.additionalLockLevel);
                        ext.updateSpecific(DoorData.create(ext));
                    }
                    if (ext.isInteriorRegenerating() && ext.isExteriorDeadLocked()) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(ExteriorBlock.INTERIOR_CHANGE, new Object[]{ext.getRemainingInteriorChangeTime()}), true);
                    }
                    if (!this.isLocked && !this.isDeadLocked()) {
                        EnumDoorState[] valid = this.doorType.getValidStates();
                        int index = this.getOpenState().ordinal() + 1;
                        if (index >= valid.length) {
                            index = 0;
                        }
                        this.setOpenState(valid[index]);
                        this.openAndUpdateExteriorDoor();
                        IDoorSoundScheme scheme = this.getConsole().getExteriorType().getDoorSounds();
                        if (this.getOpenState() == EnumDoorState.CLOSED) {
                            this.field_70170_p.func_184133_a(null, player.func_233580_cy_(), scheme.getClosedSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            this.playSoundAtExterior(ext, scheme.getClosedSound(), SoundCategory.BLOCKS, 1.0f);
                        } else {
                            this.field_70170_p.func_184133_a(null, player.func_233580_cy_(), scheme.getOpenSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            this.playSoundAtExterior(ext, scheme.getOpenSound(), SoundCategory.BLOCKS, 1.0f);
                        }
                    } else {
                        if (this.isDeadLocked()) {
                            player.func_146105_b((ITextComponent)ExteriorBlock.DEADLOCKED, true);
                            return ActionResultType.SUCCESS;
                        }
                        if (this.isLocked) {
                            player.func_146105_b((ITextComponent)ExteriorBlock.LOCKED, true);
                            return ActionResultType.SUCCESS;
                        }
                    }
                }
            } else {
                Tardis.LOGGER.error("Cannot find Exterior Tile! Was the exterior block removed whilst it was still rematerialising?");
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (source.func_76346_g() instanceof PlayerEntity) {
                PlayerEntity playerIn = (PlayerEntity)source.func_76346_g();
                this.health = playerIn.field_71075_bZ.field_75098_d ? 0.0f : (this.health -= amount);
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187767_eL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            if (this.health <= 0.0f) {
                ItemEntity entity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getPickedResult(null));
                this.field_70170_p.func_217376_c((Entity)entity);
                this.func_70106_y();
            }
        }
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_90999_ad() {
        return false;
    }

    @Nullable
    public ConsoleTile getConsole() {
        TileEntity te = this.field_70170_p.func_175625_s(TardisHelper.TARDIS_POS);
        if (te instanceof ConsoleTile) {
            return (ConsoleTile)te;
        }
        return null;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void playSoundAtExterior(@Nullable ExteriorTile tile, SoundEvent event, SoundCategory cat, float vol) {
        if (tile != null && tile.func_145830_o()) {
            tile.func_145831_w().func_184133_a(null, tile.func_174877_v(), event, cat, vol, 1.0f);
        }
    }

    public AxisAlignedBB getDoorBB() {
        switch (this.func_174811_aO()) {
            case EAST: {
                return new AxisAlignedBB(0.4, 0.0, -0.5, 0.5, 2.0, 0.5);
            }
            case WEST: {
                return new AxisAlignedBB(-0.5, 0.0, -0.5, -0.4, 2.0, 0.5);
            }
            case SOUTH: {
                return new AxisAlignedBB(-0.5, 0.0, 0.4, 0.5, 2.0, 0.5);
            }
        }
        return new AxisAlignedBB(-0.5, 0.0, -0.5, 0.5, 2.0, -0.4);
    }

    public void addEntityToTeleportImmuneList(UUID id) {
        this.teleportImmune.add(id);
    }

    public void teleportEntities(List<Entity> entities) {
        this.teleportEntity(entities);
    }

    private void teleportEntity(List<Entity> entity) {
        ConsoleTile console = this.getConsole();
        if (console == null) {
            return;
        }
        this.field_70170_p.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
            for (Entity e : entity) {
                if (e instanceof DoorEntity) continue;
                if (console.isInFlight()) {
                    if (e instanceof PlayerEntity) {
                        if (console.getEmotionHandler().getLoyalty(e.func_110124_au()) > 50) {
                            this.setOpenState(EnumDoorState.CLOSED);
                            continue;
                        }
                        if (console.getEmotionHandler().getLoyalty(e.func_110124_au()) > 25) {
                            console.initLand();
                        }
                    }
                    BlockPos diff = console.getDestinationPosition().func_177973_b((Vector3i)console.getCurrentLocation());
                    double scale = console.getPercentageJourney();
                    RegistryKey<World> type = scale > 0.5 ? console.getDestinationDimension() : console.getCurrentDimension();
                    ChunkPos cPos = new ChunkPos(console.getCurrentLocation());
                    ServerWorld sWorld = this.field_70170_p.func_73046_m().func_71218_a(type);
                    WorldHelper.forceChunkIfNotLoaded(sWorld, cPos, console.getCurrentLocation());
                    BlockPos targetPos = LandingSystem.getTopBlock((World)sWorld, console.getCurrentLocation().func_177971_a((Vector3i)new BlockPos((double)diff.func_177958_n() * scale, (double)diff.func_177956_o() * scale, (double)diff.func_177952_p() * scale)));
                    SpaceTimeCoord target = new SpaceTimeCoord(type, targetPos);
                    WorldHelper.unForceChunkIfLoaded(sWorld, cPos, console.getCurrentLocation());
                    if (e instanceof LivingEntity) {
                        MinecraftForge.EVENT_BUS.post((Event)new LivingEvents.TardisLeaveEvent((LivingEntity)e, this, (World)this.field_70170_p.func_73046_m().func_71218_a(type)));
                    }
                    e.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                        cap.setDestination(target);
                        WorldHelper.teleportEntities(e, this.field_70170_p.func_73046_m().func_71218_a(TDimensions.VORTEX_DIM), 0.0, 128.0, 0.0, e.field_70177_z, e.field_70125_A);
                        if (e instanceof PlayerEntity) {
                            Helper.addTardisStatistic((PlayerEntity)e, TardisStatistics.VORTEX_TRAVEL_COUNT);
                        }
                    });
                    if (!e.getCapability(Capabilities.PLAYER_DATA).isPresent()) {
                        WorldHelper.teleportEntities(e, this.field_70170_p.func_73046_m().func_71218_a(WorldHelper.getWorldKeyFromRL(target.getDimRL())), (double)target.getPos().func_177958_n() + 0.5, target.getPos().func_177956_o() + 1, (double)target.getPos().func_177952_p() + 0.5, e.field_70177_z, e.field_70125_A);
                    }
                    return;
                }
                if (this.teleportImmune.contains(e.func_110124_au())) continue;
                ExteriorTile ext = console.getExteriorType().getExteriorTile(console);
                if (ext != null) {
                    ext.addTeleportedEntity(e.func_110124_au());
                }
                Vector3d oldMotion = e.func_213322_ci();
                ServerWorld destWorld = this.field_70170_p.func_73046_m().func_71218_a(console.getCurrentDimension());
                Direction dir = console.getTrueExteriorFacingDirection();
                float diff = WorldHelper.getFixedRotation(e.field_70177_z) - WorldHelper.getFixedRotation(this.field_70177_z);
                float realFacing = WorldHelper.getAngleFromFacing(dir.func_176734_d()) + diff;
                BlockPos pos = console.getCurrentLocation().func_177972_a(dir);
                e.field_70177_z = WorldHelper.getAngleFromFacing(dir.func_176734_d());
                if (e instanceof LivingEntity) {
                    MinecraftForge.EVENT_BUS.post((Event)new LivingEvents.TardisLeaveEvent((LivingEntity)e, this, (World)this.field_70170_p.func_73046_m().func_71218_a(console.getCurrentDimension())));
                }
                WorldHelper.teleportEntities(e, destWorld, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, realFacing, e.field_70125_A);
                if (e instanceof PlayerEntity) {
                    for (MonsterEntity ent : this.field_70170_p.func_217357_a(MonsterEntity.class, new AxisAlignedBB(this.func_233580_cy_()).func_186662_g(20.0))) {
                        if (ent.func_70638_az() != e) continue;
                        for (PrioritizedGoal goal : ent.field_70714_bg.field_220892_d) {
                            if (!(goal.func_220772_j() instanceof FollowOutOfTardisGoal)) continue;
                            ((FollowOutOfTardisGoal)goal.func_220772_j()).setTarget(this.func_233580_cy_());
                        }
                    }
                }
                if (e instanceof PlayerEntity && console.getEntity() != null) {
                    e.func_184220_m((Entity)console.getEntity());
                }
                Vector3d setMot = oldMotion.func_178785_b(-((float)Math.toRadians(realFacing)));
                this.field_70170_p.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(2, () -> {
                    Entity ent = destWorld.func_217461_a(e.func_110124_au());
                    if (ent != null) {
                        ent.func_213317_d(setMot);
                    }
                    if (ent instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)ent).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(ent));
                    }
                }));
            }
        }));
    }

    public void suckIntoVoid() {
        for (LivingEntity e : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(40.0))) {
            if (!e.func_70685_l((Entity)this)) continue;
            e.func_184210_p();
            if (e.func_70608_bn()) {
                e.func_213366_dy();
            }
            Vector3d motion = this.func_213303_ch().func_178788_d(e.func_213303_ch()).func_72432_b().func_186678_a(0.1);
            e.func_213317_d(e.func_213322_ci().func_178787_e(motion));
            e.field_70160_al = true;
            e.func_230245_c_(false);
        }
    }

    public void setOpenState(EnumDoorState open) {
        this.field_70180_af.func_187227_b(STATE, (Object)open.ordinal());
        if (open != EnumDoorState.CLOSED) {
            this.setLocked(false);
        }
    }

    public EnumDoorState getOpenState() {
        return EnumDoorState.values()[(Integer)this.field_70180_af.func_187225_a(STATE)];
    }

    public boolean getSucking() {
        return (Boolean)this.func_184212_Q().func_187225_a(SUCC);
    }

    public void setSucking(boolean succ) {
        this.func_184212_Q().func_187227_b(SUCC, (Object)succ);
    }

    public void handleSucking() {
        if (!this.field_70170_p.field_72995_K) {
            ServerWorld ws = this.field_70170_p.func_73046_m().func_71218_a(this.getConsole().getCurrentDimension());
            if (ws.getCapability(Capabilities.SPACE_DIM_PROPERTIES).isPresent()) {
                ws.getCapability(Capabilities.SPACE_DIM_PROPERTIES).ifPresent(properties -> {
                    ObjectWrapper<Boolean> suck = new ObjectWrapper<Boolean>(!properties.hasAir());
                    ExteriorTile ext = this.getConsole().getExteriorType().getExteriorTile(this.getConsole());
                    if (ext == null) {
                        return;
                    }
                    Direction dir = (Direction)ext.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
                    for (TileEntity te : ws.field_147482_g) {
                        IOxygenSealer oxy = (IOxygenSealer)te.getCapability(Capabilities.OXYGEN_SEALER).orElse(null);
                        if (oxy == null || !oxy.getSealedPositions().contains(ext.func_174877_v().func_177972_a(dir))) continue;
                        suck.setValue(false);
                        break;
                    }
                    this.getConsole().getSubsystem(ShieldGeneratorSubsystem.class).ifPresent(shield -> {
                        if (shield.isForceFieldActivated()) {
                            suck.setValue(false);
                        }
                    });
                    if (this.func_184212_Q().func_187225_a(SUCC) != suck.getValue()) {
                        this.func_184212_Q().func_187227_b(SUCC, (Object)suck.getValue());
                    }
                });
            } else if (((Boolean)this.func_184212_Q().func_187225_a(SUCC)).booleanValue()) {
                this.func_184212_Q().func_187227_b(SUCC, (Object)false);
            }
        }
    }

    public int getAdditionalLockLevel() {
        return this.additionalLockLevel;
    }

    public void setAdditionalLockLevel(int level) {
        this.additionalLockLevel = level;
    }

    public boolean isDeadLocked() {
        return this.additionalLockLevel > 0;
    }

    public void openAndUpdateExteriorDoor() {
        ExteriorTile ext;
        ConsoleTile console;
        if (!this.field_70170_p.field_72995_K && (console = this.getConsole()) != null && (ext = console.getExteriorType().getExteriorTile(console)) != null) {
            ext.setDoorState(this.getOpenState());
            if (this.getOpenState() != EnumDoorState.CLOSED) {
                ext.setLocked(false);
            }
            if (ext.getAdditionalLockLevel() != this.additionalLockLevel) {
                ext.setAdditionalLockLevel(this.additionalLockLevel);
            }
            ext.updateSpecific(DoorData.create(ext));
        }
    }

    public void updateExteriorDoorData() {
        ExteriorTile ext;
        ConsoleTile tile = this.getConsole();
        if (tile != null && (ext = tile.getExteriorType().getExteriorTile(tile)) != null) {
            ext.setDoorState(this.getOpenState());
            ext.setLocked(this.isLocked);
            ext.setAdditionalLockLevel(this.additionalLockLevel);
            ext.updateSpecific(DoorData.create(ext));
        }
    }

    public boolean func_230279_az_() {
        return true;
    }
}

