/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tardis.mod.controls.AbstractControl;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.flight.FlightEvent;
import net.tardis.mod.misc.ITickable;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.UpdateControlMessage;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.tileentities.ConsoleTile;

public class ControlEntity
extends Entity {
    private static final DataParameter<String> CONTROL = EntityDataManager.func_187226_a(ControlEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private AbstractControl controlObject;
    private ConsoleTile console;
    private boolean shouldTick = false;
    private boolean firstTick = true;
    private int timeTillUpdate = 30;

    public ControlEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public ControlEntity(World world) {
        this((EntityType)TEntities.CONTROL.get(), world);
    }

    public void setControl(AbstractControl control) {
        this.controlObject = control;
        if (!this.field_70170_p.field_72995_K && control != null) {
            this.field_70180_af.func_187227_b(CONTROL, (Object)control.getEntry().getRegistryName().toString());
            this.updateControlValues();
        }
    }

    public AbstractControl getControl() {
        ControlRegistry.ControlEntry entry;
        if (this.controlObject == null && (entry = ControlRegistry.getControl(new ResourceLocation((String)this.func_184212_Q().func_187225_a(CONTROL)))) != null) {
            this.controlObject = entry.spawn(this.getConsole(), this);
            return this.controlObject;
        }
        return this.controlObject;
    }

    public void updateControlValues() {
        this.func_213323_x_();
        this.shouldTick = this.getControl() instanceof ITickable;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(CONTROL, (Object)(this.controlObject != null ? this.controlObject.getEntry().getRegistryName().toString() : ""));
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.func_184212_Q().func_187227_b(CONTROL, (Object)compound.func_74779_i("control"));
        this.getControl().deserializeNBT((INBT)compound.func_74775_l("control_data"));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("control", this.getControl().getEntry().getRegistryName().toString());
        compound.func_218657_a("control_data", this.controlObject.serializeNBT());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.getControl() == null) {
            this.func_70106_y();
        }
        if (this.shouldTick) {
            ((ITickable)((Object)this.getControl())).tick(this.getConsole());
        }
        if (this.field_70173_aa % 20 == 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184212_Q().func_187227_b(CONTROL, (Object)this.getControl().getEntry().getRegistryName().toString());
            }
            this.updateControlValues();
        }
        if (this.getControl() != null && this.getControl().getAnimationTicks() > 0) {
            this.getControl().setAnimationTicks(this.getControl().getAnimationTicks() - 1);
        }
        if (this.field_70173_aa == 5 && !this.field_70170_p.field_72995_K) {
            Network.sendPacketToAll(new UpdateControlMessage(this.func_145782_y(), (CompoundNBT)this.getControl().serializeNBT(), this.getControl().getAnimationTicks()));
        }
        if (this.timeTillUpdate > 0) {
            --this.timeTillUpdate;
            if (this.timeTillUpdate == 0 && !this.field_70170_p.field_72995_K) {
                Network.sendPacketToAll(new UpdateControlMessage(this.func_145782_y(), (CompoundNBT)this.getControl().serializeNBT(), this.getControl().getAnimationTicks()));
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 20 && this.getControl() != null && this.getControl().isDirty()) {
            Network.sendPacketToAll(new UpdateControlMessage(this.func_145782_y(), (CompoundNBT)this.getControl().serializeNBT(), this.getControl().getAnimationTicks()));
            this.getControl().clean();
        }
        if (this.firstTick) {
            this.timeTillUpdate = 20;
            this.firstTick = false;
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.getConsole() != null && !this.getConsole().func_145837_r() && this.controlObject != null && this.getConsole().getControlOverrides().containsKey(this.controlObject.getClass())) {
            return this.getConsole().getControlOverrides().get(this.controlObject.getClass()).getSize();
        }
        return this.getControl() == null ? super.func_213305_a(poseIn) : this.getControl().getSize();
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (!this.isControlVaild()) {
            return ActionResultType.FAIL;
        }
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        FlightEvent current = this.getConsole().getFlightEvent();
        if (current != null && current.onControlHit(this.getConsole(), this.getControl())) {
            this.setAnimationTicks(this.getControl().getMaxAnimationTicks());
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), this.getControl().getSuccessSound(this.getConsole()), SoundCategory.PLAYERS, 1.0f, 1.0f);
            return ActionResultType.PASS;
        }
        boolean worked = this.getControl().onRightClicked(this.getConsole(), player);
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), worked ? this.getControl().getSuccessSound(this.getConsole()) : this.getControl().getFailSound(this.getConsole()), SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            Network.sendPacketToAll(new UpdateControlMessage(this.func_145782_y(), (CompoundNBT)this.getControl().serializeNBT(), this.getControl().getAnimationTicks()));
        }
        this.getConsole().setPilot(player);
        return ActionResultType.SUCCESS;
    }

    public boolean func_85031_j(Entity entityIn) {
        if (!this.isControlVaild()) {
            return false;
        }
        FlightEvent current = this.getConsole().getFlightEvent();
        if (current != null && current.onControlHit(this.getConsole(), this.getControl())) {
            this.setAnimationTicks(this.getControl().getMaxAnimationTicks());
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), this.getControl().getSuccessSound(this.getConsole()), SoundCategory.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        if (entityIn instanceof PlayerEntity) {
            boolean worked = this.getControl().onHit(this.getConsole(), (PlayerEntity)entityIn);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), worked ? this.getControl().getSuccessSound(this.getConsole()) : this.getControl().getFailSound(this.getConsole()), SoundCategory.BLOCKS, 1.0f, 1.0f);
                Network.sendPacketToAll(new UpdateControlMessage(this.func_145782_y(), (CompoundNBT)this.getControl().serializeNBT(), this.getControl().getAnimationTicks()));
            }
            this.getConsole().setPilot((PlayerEntity)entityIn);
        }
        return super.func_85031_j(entityIn);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70075_an() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return this.controlObject == null ? new StringTextComponent("None") : this.getControl().getDisplayName();
    }

    private ConsoleTile getConsole() {
        return this.console;
    }

    public void setConsole(ConsoleTile console) {
        this.console = console;
        if (this.getControl() != null) {
            this.getControl().setConsole(console, this);
        }
    }

    public void setAnimationTicks(int ticks) {
        this.getControl().setAnimationTicks(ticks);
        if (!this.field_70170_p.field_72995_K) {
            Network.sendPacketToAll(new UpdateControlMessage(this.func_145782_y(), (CompoundNBT)this.getControl().serializeNBT(), this.getControl().getAnimationTicks()));
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.timeTillUpdate = 30;
    }

    public boolean isControlVaild() {
        if (this.getControl() == null) {
            return false;
        }
        return this.getControl().getConsole() != null && this.getControl().getConsole().func_145830_o();
    }

    public boolean func_90999_ad() {
        return false;
    }
}

