/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen.objects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.tardis.mod.datagen.objects.SoundBuilder;

public class SoundEventBuilder {
    private SoundCategory category = SoundCategory.BLOCKS;
    private String subtitleTranslationKey = "";
    private List<SoundBuilder> sounds = new ArrayList<SoundBuilder>();
    private SoundEvent event;

    public SoundEventBuilder(SoundEvent event) {
        this.event = event;
    }

    public SoundEventBuilder withCategory(SoundCategory category) {
        this.category = category;
        return this;
    }

    public SoundEventBuilder withSpecificSubtitle(String subtitleTranslationKey) {
        this.subtitleTranslationKey = subtitleTranslationKey;
        return this;
    }

    public SoundEventBuilder withSubtitle() {
        this.subtitleTranslationKey = this.getTranslationKey(this.event);
        return this;
    }

    public SoundEventBuilder withSound(SoundBuilder sound) {
        this.sounds.add(sound);
        return this;
    }

    public String getTranslationKey(SoundEvent sound) {
        if (this.subtitleTranslationKey.isEmpty() || this.subtitleTranslationKey == null) {
            this.subtitleTranslationKey = Util.func_200697_a((String)"subtitle", (ResourceLocation)sound.getRegistryName());
        }
        return this.subtitleTranslationKey;
    }

    public JsonElement toJson() {
        JsonObject soundObject = new JsonObject();
        soundObject.addProperty("subtitle", this.subtitleTranslationKey);
        JsonArray soundList = new JsonArray();
        for (SoundBuilder sound : this.sounds) {
            soundList.add(sound.toJson());
        }
        soundObject.add("sounds", (JsonElement)soundList);
        return soundObject;
    }
}

