/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen.objects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.client.audio.Sound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class SoundBuilder {
    private boolean nonDefault = false;
    private final String path;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private int weight = 1;
    private boolean stream = false;
    private int attenuationDistance = 16;
    private boolean preloadSound = false;
    private Sound.Type type = Sound.Type.FILE;

    public SoundBuilder(String path) {
        this.path = "tardis:" + path;
    }

    public SoundBuilder(ResourceLocation path) {
        this.path = path.toString();
    }

    public SoundBuilder volume(float volume) {
        this.volume = MathHelper.func_76131_a((float)volume, (float)0.0f, (float)1.0f);
        this.nonDefault = true;
        return this;
    }

    public SoundBuilder pitch(float pitch) {
        this.pitch = pitch;
        this.nonDefault = true;
        return this;
    }

    public SoundBuilder weight(int weight) {
        this.weight = Math.max(weight, 0);
        this.nonDefault = true;
        return this;
    }

    public SoundBuilder stream() {
        this.stream = true;
        this.nonDefault = true;
        return this;
    }

    public SoundBuilder attenuationDistance(int distance) {
        this.attenuationDistance = distance;
        this.nonDefault = true;
        return this;
    }

    public SoundBuilder preloaded() {
        this.preloadSound = true;
        this.nonDefault = true;
        return this;
    }

    public SoundBuilder isReference() {
        this.type = Sound.Type.SOUND_EVENT;
        this.nonDefault = true;
        return this;
    }

    public JsonElement toJson() {
        if (!this.nonDefault) {
            return new JsonPrimitive(this.path);
        }
        JsonObject soundObject = new JsonObject();
        soundObject.addProperty("name", this.path);
        if (this.volume != 1.0f) {
            soundObject.addProperty("volume", (Number)Float.valueOf(this.volume));
        }
        if (this.pitch != 1.0f) {
            soundObject.addProperty("pitch", (Number)Float.valueOf(this.pitch));
        }
        if (this.weight != 1) {
            soundObject.addProperty("weight", (Number)this.weight);
        }
        if (this.stream) {
            soundObject.addProperty("stream", Boolean.valueOf(true));
        }
        if (this.attenuationDistance != 16) {
            soundObject.addProperty("attenuation_distance", (Number)this.attenuationDistance);
        }
        if (this.preloadSound) {
            soundObject.addProperty("preload", Boolean.valueOf(true));
        }
        if (this.type != Sound.Type.FILE) {
            soundObject.addProperty("type", "event");
        }
        return soundObject;
    }
}

