/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen.migration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.datagen.TardisManualGen;
import net.tardis.mod.helper.Helper;

public class ManualNamesLookup {
    private static List<ManualMigrationWrapper> migrationObjects = new ArrayList<ManualMigrationWrapper>();

    public static void createMigrationObjects() {
        ArrayList arsMerge = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("ars/ars"), Helper.createOldManualRL("ars/ars2"), Helper.createOldManualRL("ars/ars3")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("ars/ars"), Helper.createRL("ars/ars_intro"), arsMerge);
        ArrayList arsUsageMerge = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("ars/ars4"), Helper.createOldManualRL("ars/ars5"), Helper.createOldManualRL("ars/ars6")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("ars/ars4"), Helper.createRL("ars/ars_usage"), arsUsageMerge);
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls"), Helper.createRL("flight/controls/controls_intro"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls2"), Helper.createRL("flight/controls/dimension"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls3"), Helper.createRL("flight/controls/facing"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls4"), Helper.createRL("flight/controls/handbrake"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls5"), Helper.createRL("flight/controls/throttle"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls6"), Helper.createRL("flight/controls/coordinate_increment"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls7"), Helper.createRL("flight/controls/vertical_land_type"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls8"), Helper.createRL("flight/controls/randomizer"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls9"), Helper.createRL("flight/controls/refueler"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls10"), Helper.createRL("flight/controls/axis_controls"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls11"), Helper.createRL("flight/controls/fast_return"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls12"), Helper.createRL("flight/controls/telepathic"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls13"), Helper.createRL("flight/controls/stabilizers"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls14"), Helper.createRL("flight/controls/sonic_port"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls15"), Helper.createRL("flight/controls/communicator"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("controls/flight_controls16"), Helper.createRL("flight/controls/door_switch"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("energy/energy"), Helper.createRL("energy/energy_intro"));
        ArrayList energyMerge = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("energy/energy2"), Helper.createOldManualRL("energy/energy3"), Helper.createOldManualRL("energy/energy3")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("energy/energy2"), Helper.createRL("energy/artron_energy"), energyMerge);
        ArrayList forgeEnergyMerge = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("energy/energy6"), Helper.createOldManualRL("energy/energy7")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("energy/energy6"), Helper.createRL("energy/forge_energy"), forgeEnergyMerge);
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("events/event"), Helper.createRL("structures/structure_intro"));
        ArrayList structuresMerge = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("events/event_broken_timeship"), Helper.createOldManualRL("events/event_broken_timeship2"), Helper.createOldManualRL("events/event_broken_timeship3"), Helper.createOldManualRL("events/event_broken_timeship4"), Helper.createOldManualRL("events/event_broken_timeship5"), Helper.createOldManualRL("events/event_broken_timeship6")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("events/event_broken_timeship"), Helper.createRL("structures/structure_broken_timeship"), structuresMerge);
        ArrayList shipMerge = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("events/event_crashed_ship"), Helper.createOldManualRL("events/event_crashed_ship2"), Helper.createOldManualRL("events/event_crashed_ship3")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("events/event_crashed_ship"), Helper.createRL("structures/structure_crashed_ship"), shipMerge);
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight"), Helper.createRL("flight/flight_mode_intro"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight2"), Helper.createRL("flight/flight_mode/flight_mode_types"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight3"), Helper.createRL("flight/flight_mode/unstabilized_flight"));
        ArrayList stabilisedMerge = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("flight/flight4"), Helper.createOldManualRL("flight/flight5"), Helper.createOldManualRL("flight/flight6")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("flight/flight4"), Helper.createRL("flight/flight_mode/stabilized_flight"), stabilisedMerge);
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight6a"), Helper.createRL("flight/flight_mode/vortex_limbo"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight6b"), Helper.createRL("flight/flight_event/flight_event_intro"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight7"), Helper.createRL("flight/flight_event/vortex_scrap"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight8"), Helper.createRL("flight/flight_event/time_wind"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight9"), Helper.createRL("flight/flight_event/spatial_drift"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight10"), Helper.createRL("flight/flight_event/artron_flow"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight11"), Helper.createRL("flight/flight_event/exterior_bulkhead"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight12"), Helper.createRL("flight/flight_event/dimensional_drift"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight13"), Helper.createRL("flight/flight_event/vertical_displacement"));
        ArrayList timeRam = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("flight/flight14"), Helper.createOldManualRL("flight/flight15")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("flight/flight14"), Helper.createRL("flight/flight_event/time_ram"), timeRam);
        ArrayList timeRamInstigate = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("flight/flight16"), Helper.createOldManualRL("flight/flight17")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("flight/flight16"), Helper.createRL("flight/flight_event/time_ram_instigate"), timeRamInstigate);
        ArrayList timeRamReceive = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("flight/flight18"), Helper.createOldManualRL("flight/flight19")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("flight/flight18"), Helper.createRL("flight/flight_event/time_ram_receive"), timeRamReceive);
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("flight/flight20"), Helper.createRL("flight/flight_event/artron_pocket"));
        ArrayList emotionIntro = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("maintenance/maintenance_emotion"), Helper.createOldManualRL("maintenance/maintenance_emotion2")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("maintenance/maintenance_emotion"), Helper.createRL("emotion/emotion_intro"), emotionIntro);
        ArrayList mood = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("maintenance/maintenance_emotion3"), Helper.createOldManualRL("maintenance/maintenance_emotion4"), Helper.createOldManualRL("maintenance/maintenance_emotion5_a"), Helper.createOldManualRL("maintenance/maintenance_emotion6")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("maintenance/maintenance_emotion3"), Helper.createRL("emotion/mood"), mood);
        ArrayList loyalty = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("maintenance/maintenance_emotion7"), Helper.createOldManualRL("maintenance/maintenance_emotion8"), Helper.createOldManualRL("maintenance/maintenance_emotion9")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("maintenance/maintenance_emotion7"), Helper.createRL("emotion/loyalty"), loyalty);
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("protocols/monitor_protocols"), Helper.createRL("protocols/protocol_intro"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("protocols/monitor_protocols2"), Helper.createRL("protocols/change_exterior"));
        ArrayList interiorProtocol = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("protocols/monitor_protocols3"), Helper.createOldManualRL("protocols/monitor_protocols4"), Helper.createOldManualRL("protocols/monitor_protocols4a")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("protocols/monitor_protocols3"), Helper.createRL("protocols/change_interior"), interiorProtocol);
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("protocols/monitor_protocols5"), Helper.createRL("protocols/change_console"));
        ArrayList securityProtocol = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("protocols/monitor_protocols6"), Helper.createOldManualRL("protocols/monitor_protocols7"), Helper.createOldManualRL("protocols/monitor_protocols7a")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("protocols/monitor_protocols6"), Helper.createRL("protocols/security/security_submenu"), securityProtocol);
        ArrayList interiorProperties = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("protocols/monitor_protocols8"), Helper.createOldManualRL("protocols/monitor_protocols9"), Helper.createOldManualRL("protocols/monitor_protocols9a")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("protocols/monitor_protocols8"), Helper.createRL("protocols/interior/interior_properties"), interiorProperties);
        ArrayList exteriorProperties = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("protocols/monitor_protocols10"), Helper.createOldManualRL("protocols/monitor_protocols11")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("protocols/monitor_protocols10"), Helper.createRL("protocols/exterior/exterior_properties"), exteriorProperties);
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("protocols/monitor_protocols12"), Helper.createRL("protocols/waypoint_screen"));
        ManualNamesLookup.migrateToNormalPage(Helper.createOldManualRL("security/security"), Helper.createRL("security/security_intro"));
        ArrayList security = Lists.newArrayList((Object[])new ResourceLocation[]{Helper.createOldManualRL("security/security2"), Helper.createOldManualRL("security/security3")});
        ManualNamesLookup.migrateAndMergeToNormalPage(Helper.createOldManualRL("security/security2"), Helper.createRL("security/admin_functions"), security);
    }

    public static List<ManualMigrationWrapper> getMigrationObjects() {
        return migrationObjects;
    }

    public static Map<ResourceLocation, ResourceLocation> getMappingsWithoutMerging() {
        HashMap<ResourceLocation, ResourceLocation> locations = new HashMap<ResourceLocation, ResourceLocation>();
        for (ManualMigrationWrapper wrapper : migrationObjects) {
            if (wrapper.requiresMerging()) continue;
            locations.put(wrapper.getOldLoc(), wrapper.getNewLoc());
        }
        return locations;
    }

    public static Map<ResourceLocation, List<ResourceLocation>> mappingWithMerging() {
        HashMap<ResourceLocation, List<ResourceLocation>> locations = new HashMap<ResourceLocation, List<ResourceLocation>>();
        for (ManualMigrationWrapper wrapper : migrationObjects) {
            if (!wrapper.requiresMerging()) continue;
            locations.put(wrapper.getOldLoc(), wrapper.getPathsToMerge());
        }
        return locations;
    }

    public static void migrate(ResourceLocation oldLoc, ResourceLocation newLoc, TardisManualGen.ManualObjectType convertedType) {
        ManualMigrationWrapper wrapper = new ManualMigrationWrapper(oldLoc, newLoc, convertedType);
        migrationObjects.add(wrapper);
    }

    public static void migrateAndMerge(ResourceLocation oldLoc, ResourceLocation newLoc, TardisManualGen.ManualObjectType convertedType, List<ResourceLocation> pathsToMerge) {
        ManualMigrationWrapper wrapper = new ManualMigrationWrapper(oldLoc, newLoc, convertedType);
        wrapper.setOldPathsToMerge(pathsToMerge);
        migrationObjects.add(wrapper);
    }

    public static void migrateToPageType(ResourceLocation oldLoc, ResourceLocation newLoc, TardisManualGen.PageType pageType) {
        ManualMigrationWrapper wrapper = new ManualMigrationWrapper(oldLoc, newLoc, TardisManualGen.ManualObjectType.PAGE);
        wrapper.setPageType(pageType);
        migrationObjects.add(wrapper);
    }

    public static void migrateAndMergeToPageType(ResourceLocation oldLoc, ResourceLocation newLoc, TardisManualGen.PageType pageType, List<ResourceLocation> pathsToMerge) {
        ManualMigrationWrapper wrapper = new ManualMigrationWrapper(oldLoc, newLoc, TardisManualGen.ManualObjectType.PAGE);
        wrapper.setOldPathsToMerge(pathsToMerge);
        wrapper.setPageType(pageType);
        migrationObjects.add(wrapper);
    }

    public static void migrateToNormalPage(ResourceLocation oldLoc, ResourceLocation newLoc) {
        ManualMigrationWrapper wrapper = new ManualMigrationWrapper(oldLoc, newLoc, TardisManualGen.ManualObjectType.PAGE);
        migrationObjects.add(wrapper);
    }

    public static void migrateAndMergeToNormalPage(ResourceLocation oldLoc, ResourceLocation newLoc, List<ResourceLocation> pathsToMerge) {
        ManualMigrationWrapper wrapper = new ManualMigrationWrapper(oldLoc, newLoc, TardisManualGen.ManualObjectType.PAGE);
        wrapper.setOldPathsToMerge(pathsToMerge);
        migrationObjects.add(wrapper);
    }

    public static class ManualMigrationWrapper {
        private List<ResourceLocation> oldPathsToMerge = new ArrayList<ResourceLocation>();
        private ResourceLocation oldLoc;
        private ResourceLocation newLoc;
        private TardisManualGen.ManualObjectType newType;
        private TardisManualGen.PageType pageType = TardisManualGen.PageType.NORMAL;

        public ManualMigrationWrapper(ResourceLocation oldLoc, ResourceLocation newLoc, TardisManualGen.ManualObjectType newType) {
            this.newLoc = newLoc;
            this.oldLoc = oldLoc;
            this.newType = newType;
        }

        public ResourceLocation getOldLoc() {
            return this.oldLoc;
        }

        public ResourceLocation getNewLoc() {
            return this.newLoc;
        }

        public TardisManualGen.ManualObjectType getConvertedObjectType() {
            return this.newType;
        }

        public ManualMigrationWrapper setPageType(TardisManualGen.PageType pageType) {
            this.pageType = pageType;
            return this;
        }

        public TardisManualGen.PageType getPageType() {
            return this.pageType;
        }

        public ManualMigrationWrapper setOldPathsToMerge(List<ResourceLocation> oldPathsToMerge) {
            this.oldPathsToMerge = oldPathsToMerge;
            return this;
        }

        public List<ResourceLocation> getPathsToMerge() {
            return this.oldPathsToMerge;
        }

        public boolean requiresMerging() {
            return !this.oldPathsToMerge.isEmpty();
        }
    }
}

