/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.tardis.mod.datagen.objects.SoundBuilder;
import net.tardis.mod.datagen.objects.SoundEventBuilder;
import net.tardis.mod.sounds.TSounds;

public class TardisSoundFileGen
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private JsonObject root = new JsonObject();

    public TardisSoundFileGen(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        Path outputPath = TardisSoundFileGen.getPath(path, "tardis");
        this.addSound((SoundEvent)TSounds.ALARM_LOW.get(), "tardis/alarm_low");
        this.addSound((SoundEvent)TSounds.AMBIENT_CREAKS.get(), SoundCategory.AMBIENT, "ambient/creaks_loop");
        this.addSound((SoundEvent)TSounds.BESSIE_DRIVE.get(), "entity/transport/bessie_drive");
        this.addSound((SoundEvent)TSounds.BESSIE_HORN.get(), "entity/transport/bessie_horn");
        this.addSound((SoundEvent)TSounds.CANT_START.get(), "tardis/tardis_cant_start");
        this.addSound((SoundEvent)TSounds.CAR_LOCK.get(), "tardis/car_lock");
        this.addSound((SoundEvent)TSounds.COMMUNICATOR_BEEP.get(), "tardis/console/communicator_beep");
        this.addSound((SoundEvent)TSounds.COMMUNICATOR_PHONE_PICKUP.get(), "tardis/console/communicator_phone_pickup");
        this.addSound((SoundEvent)TSounds.COMMUNICATOR_RING.get(), "tardis/console/communicator_ring");
        this.addSound((SoundEvent)TSounds.COMMUNICATOR_STEAM.get(), "tardis/console/communicator_steam");
        this.addSound((SoundEvent)TSounds.DALEK_ARM.get(), "entity/dalek/dalek_arm");
        this.addSound((SoundEvent)TSounds.DALEK_DEATH.get(), "entity/dalek/dalek_death");
        this.addSound((SoundEvent)TSounds.DALEK_EXTERMINATE.get(), "entity/dalek/dalek_exterminate");
        this.addSound((SoundEvent)TSounds.DALEK_FIRE.get(), "entity/dalek/dalek_laser");
        this.addSoundWithSubtitle((SoundEvent)TSounds.DALEK_FIRE_EXTENDED.get(), this.getTranslationKey((SoundEvent)TSounds.DALEK_FIRE.get()), "entity/dalek/dalek_laser_extended");
        this.addSound((SoundEvent)TSounds.DALEK_HOVER.get(), "entity/dalek/dalek_hover");
        this.addSound((SoundEvent)TSounds.DALEK_MOVES.get(), "entity/dalek/dalek_moves");
        this.addSound((SoundEvent)TSounds.DALEK_SW_AIM.get(), "entity/dalek/special_weapon/dalek_sw_aim");
        this.addSound((SoundEvent)TSounds.DALEK_SW_FIRE.get(), "entity/dalek/special_weapon/dalek_sw_fire");
        this.addSound((SoundEvent)TSounds.DALEK_SW_HIT_EXPLODE.get(), "entity/dalek/special_weapon/dalek_sw_hit_explode");
        this.addSound((SoundEvent)TSounds.DIMENSION.get(), "tardis/console/dimension_one", "tardis/console/dimension_two", "tardis/console/dimension_three");
        this.addSound((SoundEvent)TSounds.DIRECTION.get(), "tardis/console/direction_one", "tardis/console/direction_two", "tardis/console/direction_three");
        this.addSound((SoundEvent)TSounds.DOOR_CLOSE.get(), "tardis/door_close");
        this.addSound((SoundEvent)TSounds.DOOR_KNOCK.get(), "tardis/door_knock");
        this.addSound((SoundEvent)TSounds.DOOR_LOCK.get(), "tardis/door_lock");
        this.addSound((SoundEvent)TSounds.DOOR_OPEN.get(), "tardis/door_open");
        this.addSound((SoundEvent)TSounds.DOOR_UNLOCK.get(), "tardis/door_unlock");
        this.addSound((SoundEvent)TSounds.ELECTRIC_ARC.get(), "ambient/electric_arc");
        this.addSound((SoundEvent)TSounds.ELECTRIC_SPARK.get(), "ambient/electric_spark_a", "ambient/electric_spark_b", "ambient/electric_spark_c");
        this.addSound((SoundEvent)TSounds.EYE_MONITOR_INTERACT.get(), "tardis/monitor/eye_monitor_interact");
        this.addSound((SoundEvent)TSounds.GADGET_MENU_OPEN.get(), "item/gadget_menu_open");
        this.addSoundWithSubtitle((SoundEvent)TSounds.GENERIC_ONE.get(), "subtitle.tardis.generic_control", "tardis/console/generic_one");
        this.addSoundWithSubtitle((SoundEvent)TSounds.GENERIC_ONE.get(), "subtitle.tardis.generic_control", "tardis/console/generic_one");
        this.addSoundWithSubtitle((SoundEvent)TSounds.GENERIC_TWO.get(), "subtitle.tardis.generic_control", "tardis/console/generic_two");
        this.addSoundWithSubtitle((SoundEvent)TSounds.GENERIC_THREE.get(), "subtitle.tardis.generic_control", "tardis/console/generic_three");
        this.addSound((SoundEvent)TSounds.HANDBRAKE_ENGAGE.get(), "tardis/console/handbrake_engage");
        this.addSound((SoundEvent)TSounds.HANDBRAKE_RELEASE.get(), "tardis/console/handbrake_release");
        this.addSoundWithSubtitle((SoundEvent)TSounds.JUNK_LAND.get(), this.getTranslationKey((SoundEvent)TSounds.TARDIS_LAND.get()), "tardis/junk_land");
        this.addSoundWithSubtitle((SoundEvent)TSounds.JUNK_TAKEOFF.get(), this.getTranslationKey((SoundEvent)TSounds.TARDIS_TAKEOFF.get()), "tardis/junk_takeoff");
        this.addSoundWithSubtitle((SoundEvent)TSounds.LAND_TV.get(), this.getTranslationKey((SoundEvent)TSounds.TARDIS_LAND.get()), "tardis/tardis_land_tv");
        this.addSoundWithSubtitle((SoundEvent)TSounds.LANDING_TYPE_DOWN.get(), "subtitle.tardis.control_landing_type", "tardis/console/landing_type_down");
        this.addSoundWithSubtitle((SoundEvent)TSounds.LANDING_TYPE_UP.get(), "subtitle.tardis.control_landing_type", "tardis/console/landing_type_up");
        this.addSound((SoundEvent)TSounds.LASER_GUN_FIRE.get(), "item/laser_gun_fire");
        this.addSoundWithSubtitle((SoundEvent)TSounds.MASTER_LAND.get(), this.getTranslationKey((SoundEvent)TSounds.TARDIS_LAND.get()), "tardis/master_land");
        this.addSoundWithSubtitle((SoundEvent)TSounds.MASTER_TAKEOFF.get(), this.getTranslationKey((SoundEvent)TSounds.TARDIS_TAKEOFF.get()), "tardis/master_takeoff");
        this.addSound((SoundEvent)TSounds.PAPER_DROP.get(), "blocks/paper_drop");
        this.addSound((SoundEvent)TSounds.POWER_DOWN.get(), "tardis/power_down");
        this.addSound((SoundEvent)TSounds.RANDOMISER.get(), "tardis/console/randomiser");
        this.addSound((SoundEvent)TSounds.REACHED_DESTINATION.get(), "tardis/reached_destination");
        this.addSound((SoundEvent)TSounds.REFUEL_START.get(), "tardis/console/refuel_start");
        this.addSound((SoundEvent)TSounds.REFUEL_STOP.get(), "tardis/console/refuel_stop");
        this.addSound((SoundEvent)TSounds.REMOTE_ACCEPT.get(), "item/remote_accept");
        this.addSound((SoundEvent)TSounds.ROTOR_END.get(), "tardis/rotor_end");
        this.addSound((SoundEvent)TSounds.ROTOR_START.get(), "tardis/rotor_start");
        this.addSound((SoundEvent)TSounds.ROTOR_TICK.get(), "tardis/rotor_tick");
        this.addSound((SoundEvent)TSounds.SCREEN_BEEP_SINGLE.get(), "tardis/console/screen_beep_single");
        this.addSound((SoundEvent)TSounds.SHIELD_HUM.get(), true, "shared/shield_hum");
        this.addSound((SoundEvent)TSounds.SINGLE_CLOISTER.get(), "tardis/console/single_cloister");
        this.addSound((SoundEvent)TSounds.SNAP.get(), "tardis/snap");
        this.addSound((SoundEvent)TSounds.SONIC_BROKEN.get(), "sonic/sonic_broken");
        this.addSound((SoundEvent)TSounds.SONIC_FAIL.get(), "sonic/sonic_fail");
        this.addSound((SoundEvent)TSounds.SONIC_GENERIC.get(), "sonic/sonic_generic");
        this.addSound((SoundEvent)TSounds.SONIC_MODE_CHANGE.get(), "sonic/sonic_mode_change");
        this.addSound((SoundEvent)TSounds.SONIC_TUNING.get(), "sonic/sonic_tuning");
        this.addSound((SoundEvent)TSounds.SPACE_AMBIENT_LOOP.get(), true, 0.1f, "ambient/space_ambient_loop");
        this.addSound((SoundEvent)TSounds.STABILIZER_OFF.get(), "tardis/console/stabilizer_off");
        this.addSound((SoundEvent)TSounds.STABILIZER_ON.get(), "tardis/console/stabilizer_on");
        this.addSound((SoundEvent)TSounds.STEAM_HISS.get(), "ambient/steam_hiss_001", "ambient/steam_hiss_002", "ambient/steam_hiss_003", "ambient/steam_hiss_004");
        this.addSound((SoundEvent)TSounds.STEAMPUNK_MONITOR_INTERACT.get(), "tardis/monitor/steampunk_monitor_interact");
        this.addSound((SoundEvent)TSounds.SUBSYSTEMS_OFF.get(), "tardis/subsystems_off");
        this.addSound((SoundEvent)TSounds.SUBSYSTEMS_ON.get(), "tardis/subsystems_on");
        this.addSoundWithSubtitle((SoundEvent)TSounds.TAKEOFF_TV.get(), this.getTranslationKey((SoundEvent)TSounds.TARDIS_TAKEOFF.get()), "tardis/tardis_takeoff_tv");
        this.addSound((SoundEvent)TSounds.TARDIS_FIRST_ENTRANCE.get(), true, "tardis/tardis_first_entrance");
        this.addSound((SoundEvent)TSounds.TARDIS_FLY_LOOP.get(), "tardis/tardis_fly_loop");
        this.addSoundWithSubtitle((SoundEvent)TSounds.FLY_LOOP_TV.get(), this.getTranslationKey((SoundEvent)TSounds.TARDIS_FLY_LOOP.get()), "tardis/fly_loop_tv");
        this.addSoundWithSubtitle((SoundEvent)TSounds.TARDIS_HUM_63.get(), "subtitle.tardis.tardis_hum", true, "hums/tardis_hum_63");
        this.addSoundWithSubtitle((SoundEvent)TSounds.TARDIS_HUM_70.get(), "subtitle.tardis.tardis_hum", true, "hums/tardis_hum_70");
        this.addSoundWithSubtitle((SoundEvent)TSounds.TARDIS_HUM_80.get(), "subtitle.tardis.tardis_hum", true, "hums/tardis_hum_80");
        this.addSoundWithSubtitle((SoundEvent)TSounds.TARDIS_HUM_COPPER.get(), "subtitle.tardis.tardis_hum", true, "hums/tardis_hum_copper");
        this.addSoundWithSubtitle((SoundEvent)TSounds.TARDIS_HUM_CORAL.get(), "subtitle.tardis.tardis_hum", true, "hums/tardis_hum_coral");
        this.addSoundWithSubtitle((SoundEvent)TSounds.TARDIS_HUM_TOYOTA.get(), "subtitle.tardis.tardis_hum", true, "hums/tardis_hum_toyota");
        this.addSoundWithSubtitle((SoundEvent)TSounds.TARDIS_HUM_TV.get(), "subtitle.tardis.tardis_hum", true, "hums/tardis_hum_tv");
        this.addSound((SoundEvent)TSounds.TARDIS_LAND.get(), "tardis/tardis_land");
        this.addSound((SoundEvent)TSounds.TARDIS_LAND_NOTIFICATION.get(), "tardis/tardis_land_notification");
        this.addSound((SoundEvent)TSounds.TARDIS_POWER_UP.get(), "tardis/tardis_power_up");
        this.addSound((SoundEvent)TSounds.TARDIS_SHUT_DOWN.get(), "tardis/tardis_shut_down");
        this.addSound((SoundEvent)TSounds.TARDIS_TAKEOFF.get(), "tardis/tardis_takeoff");
        this.addSound((SoundEvent)TSounds.TELEPATHIC_CIRCUIT.get(), "tardis/console/telepathic_circuit");
        this.addSound((SoundEvent)TSounds.THROTTLE.get(), "tardis/console/throttle");
        this.addSound((SoundEvent)TSounds.VM_BUTTON.get(), "vm/vm_button");
        this.addSound((SoundEvent)TSounds.VM_TELEPORT.get(), "vm/vm_teleport");
        this.addSoundWithSubtitle((SoundEvent)TSounds.VM_TELEPORT_DEST.get(), this.getTranslationKey((SoundEvent)TSounds.VM_TELEPORT.get()), "vm/vm_teleport_dest");
        this.addSound((SoundEvent)TSounds.VORTEX_AMBIENT_LOOP.get(), true, 1.0f, "ambient/vortex_ambient_loop");
        this.addSound((SoundEvent)TSounds.WATCH_MALFUNCTION.get(), "item/watch_malfunction");
        this.addSound((SoundEvent)TSounds.WATCH_TICK.get(), "item/watch_tick");
        this.addSoundWithSubtitle((SoundEvent)TSounds.WOOD_DOOR_CLOSE.get(), this.getTranslationKey((SoundEvent)TSounds.DOOR_CLOSE.get()), "tardis/wood_door_close");
        this.addSoundWithSubtitle((SoundEvent)TSounds.WOOD_DOOR_OPEN.get(), this.getTranslationKey((SoundEvent)TSounds.DOOR_OPEN.get()), "tardis/wood_door_open");
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.root, (Path)outputPath);
    }

    public void addSound(SoundEvent soundEvent, String ... soundPaths) {
        SoundEventBuilder builder = new SoundEventBuilder(soundEvent).withSubtitle();
        for (String resourcePath : soundPaths) {
            builder.withSound(new SoundBuilder(resourcePath));
        }
        this.root.add(this.getSoundName(soundEvent), builder.toJson());
    }

    public void addSoundWithSubtitle(SoundEvent soundEvent, String subtitle, String ... soundPaths) {
        SoundEventBuilder builder = new SoundEventBuilder(soundEvent).withSpecificSubtitle(subtitle);
        for (String resourcePath : soundPaths) {
            builder.withSound(new SoundBuilder(resourcePath));
        }
        this.root.add(this.getSoundName(soundEvent), builder.toJson());
    }

    public void addSound(SoundEvent soundEvent, boolean stream, String ... soundPaths) {
        SoundEventBuilder builder = new SoundEventBuilder(soundEvent).withSubtitle();
        for (String resourcePath : soundPaths) {
            builder.withSound(stream ? new SoundBuilder(resourcePath).stream() : new SoundBuilder(resourcePath));
        }
        this.root.add(this.getSoundName(soundEvent), builder.toJson());
    }

    public void addSound(SoundEvent soundEvent, boolean stream, float volume, String ... soundPaths) {
        SoundEventBuilder builder = new SoundEventBuilder(soundEvent).withSubtitle();
        for (String resourcePath : soundPaths) {
            builder.withSound(stream ? new SoundBuilder(resourcePath).stream().volume(volume) : new SoundBuilder(resourcePath).volume(volume));
        }
        this.root.add(this.getSoundName(soundEvent), builder.toJson());
    }

    public void addSoundWithSubtitle(SoundEvent soundEvent, String subtitle, boolean stream, String ... soundPaths) {
        SoundEventBuilder builder = new SoundEventBuilder(soundEvent).withSpecificSubtitle(subtitle);
        for (String resourcePath : soundPaths) {
            builder.withSound(stream ? new SoundBuilder(resourcePath).stream() : new SoundBuilder(resourcePath));
        }
        this.root.add(this.getSoundName(soundEvent), builder.toJson());
    }

    public void addSound(SoundEvent soundEvent, SoundCategory category, String ... soundPaths) {
        SoundEventBuilder builder = new SoundEventBuilder(soundEvent).withCategory(category).withSubtitle();
        for (String resourcePath : soundPaths) {
            builder.withSound(new SoundBuilder(resourcePath));
        }
        this.root.add(this.getSoundName(soundEvent), builder.toJson());
    }

    public void addSound(SoundEvent soundEvent, SoundCategory category, ResourceLocation ... soundPaths) {
        SoundEventBuilder builder = new SoundEventBuilder(soundEvent).withCategory(category).withSubtitle();
        for (ResourceLocation resourcePath : soundPaths) {
            builder.withSound(new SoundBuilder(resourcePath));
        }
        this.root.add(this.getSoundName(soundEvent), builder.toJson());
    }

    public void addSound(SoundEvent soundEvent, SoundCategory category, SoundBuilder ... soundBuilders) {
        SoundEventBuilder builder = new SoundEventBuilder(soundEvent).withCategory(category).withSubtitle();
        for (SoundBuilder soundBuilder : soundBuilders) {
            builder.withSound(soundBuilder);
        }
        this.root.add(this.getSoundName(soundEvent), builder.toJson());
    }

    public static Path getPath(Path path, String modid) {
        return path.resolve("assets/" + modid + "/sounds.json");
    }

    public String getSoundName(SoundEvent sound) {
        return sound.getRegistryName().func_110623_a();
    }

    public String getTranslationKey(SoundEvent sound) {
        String subtitleTranslationKey = "";
        if (subtitleTranslationKey.isEmpty() || subtitleTranslationKey == null) {
            subtitleTranslationKey = Util.func_200697_a((String)"subtitle", (ResourceLocation)sound.getRegistryName());
        }
        return subtitleTranslationKey;
    }

    public String func_200397_b() {
        return "TARDIS Sound File Generator";
    }
}

