/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.datagen.DataGen;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.misc.Console;
import net.tardis.mod.registries.ConsoleRegistry;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.registries.SchematicTypes;
import net.tardis.mod.schematics.ConsoleUnlockSchematic;
import net.tardis.mod.schematics.ExteriorUnlockSchematic;
import net.tardis.mod.schematics.InteriorUnlockSchematic;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.types.ConsoleSchematicType;
import net.tardis.mod.schematics.types.ExteriorSchematicType;
import net.tardis.mod.schematics.types.InteriorSchematicType;
import net.tardis.mod.schematics.types.SchematicType;

public class TardisSchematicGen
implements IDataProvider {
    private DataGenerator generator;

    public TardisSchematicGen(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        if (ConsoleRoom.getRegistry().isEmpty()) {
            ConsoleRoom.registerCoreConsoleRooms();
        }
        for (ConsoleRoom room : ConsoleRoom.getRegistry().values()) {
            this.generateInterior(cache, room);
        }
        for (AbstractExterior ext : ExteriorRegistry.EXTERIOR_REGISTRY.get().getValues()) {
            this.generateExterior(cache, ext);
        }
        for (Console console : ConsoleRegistry.CONSOLE_REGISTRY.get().getValues()) {
            this.generateConsole(cache, console);
        }
    }

    public void generateInterior(DirectoryCache cache, ConsoleRoom interior) throws IOException {
        InteriorUnlockSchematic schematic = new InteriorUnlockSchematic();
        schematic.setConsoleRoom(interior.getRegistryName());
        schematic.setTranslation(interior.getDisplayName().getString());
        schematic.setId(interior.getRegistryName());
        this.generateSchematic(cache, schematic);
    }

    public void generateExterior(DirectoryCache cache, AbstractExterior exterior) throws IOException {
        ExteriorUnlockSchematic schematic = new ExteriorUnlockSchematic((SchematicType)SchematicTypes.EXTERIOR.get());
        schematic.setExterior(exterior.getRegistryName());
        schematic.setId(exterior.getRegistryName());
        schematic.setTranslation(exterior.getTranslationKey());
        this.generateSchematic(cache, schematic);
    }

    public void generateConsole(DirectoryCache cache, Console console) throws IOException {
        ConsoleUnlockSchematic consoleSchematic = new ConsoleUnlockSchematic((SchematicType)SchematicTypes.CONSOLE.get());
        consoleSchematic.setConsole(console.getRegistryName());
        consoleSchematic.setId(console.getRegistryName());
        consoleSchematic.setTranslation(console.getDisplayName().getString());
        this.generateSchematic(cache, consoleSchematic);
    }

    public void generateSchematic(DirectoryCache cache, Schematic s) throws IOException {
        IDataProvider.func_218426_a((Gson)DataGen.GSON, (DirectoryCache)cache, (JsonElement)this.createSchematic(s), (Path)TardisSchematicGen.getPath(this.generator.func_200391_b(), s));
    }

    public JsonObject createSchematic(Schematic schematic) {
        return schematic.getType().serialize(schematic);
    }

    public static Path getPath(Path base, Schematic schematic) {
        if (schematic.getType() instanceof ConsoleSchematicType) {
            return TardisSchematicGen.getPath(base, "consoles", schematic.getId());
        }
        if (schematic.getType() instanceof ExteriorSchematicType) {
            return TardisSchematicGen.getPath(base, "exteriors", schematic.getId());
        }
        if (schematic.getType() instanceof InteriorSchematicType) {
            return TardisSchematicGen.getPath(base, "interiors", schematic.getId());
        }
        return base;
    }

    public static Path getPath(Path base, String folder, ResourceLocation key) {
        return base.resolve("data/" + key.func_110624_b() + "/unlock_schematics/" + folder + "/" + key.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "TARDIS Schematic generator";
    }
}

