/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;

public class TardisManualGen
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private List<ResourceLocation> chapters = new ArrayList<ResourceLocation>();
    private String locale;

    public TardisManualGen(DataGenerator generator, String locale) {
        this.generator = generator;
        this.locale = locale;
    }

    public TardisManualGen(DataGenerator generator) {
        this(generator, "en_us");
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
    }

    public String getLocale() {
        return this.locale;
    }

    public String getOldManualPath(ResourceLocation inputLoc) {
        return "resources/assets/" + inputLoc.func_110624_b() + "/" + inputLoc.func_110623_a();
    }

    public Path getPathRoot(Path base, ResourceLocation out) {
        return base.resolve("assets/" + out.func_110624_b() + "/manual/" + this.locale + "/" + out.func_110623_a() + ".json");
    }

    public Path getPathPage(Path base, ResourceLocation out) {
        return base.resolve("assets/" + out.func_110624_b() + "/manual/" + this.locale + "/page/" + out.func_110623_a() + ".json");
    }

    public Path getPathChapter(Path base, ResourceLocation out) {
        return base.resolve("assets/" + out.func_110624_b() + "/manual/" + this.locale + "/chapter/" + out.func_110623_a() + ".json");
    }

    public void createMainManualIndex(Path base, DirectoryCache cache) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createMainManualIndex(), (Path)this.getPathRoot(base, new ResourceLocation("tardis", "manual")));
    }

    public void createChapter(Path base, DirectoryCache cache, String displayName, List<ResourceLocation> pages, ResourceLocation newLoc) throws JsonIOException, JsonSyntaxException, IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.addChapter(displayName, pages), (Path)this.getPathChapter(base, newLoc));
        this.chapters.add(newLoc);
    }

    public void createCoverPage(Path base, DirectoryCache cache, String title, ResourceLocation imageLoc, ResourceLocation newLoc) throws JsonIOException, JsonSyntaxException, IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.addCoverPage(title), (Path)this.getPathPage(base, newLoc));
        this.chapters.add(newLoc);
    }

    public void createNormalPage(Path base, DirectoryCache cache, String text, ResourceLocation newLoc) throws JsonIOException, JsonSyntaxException, IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createNormalPage(text), (Path)this.getPathPage(base, newLoc));
        this.chapters.add(newLoc);
    }

    public void convertToNormalPage(Path base, DirectoryCache cache, ResourceLocation oldPath, ResourceLocation newLoc) throws JsonIOException, JsonSyntaxException, IOException {
        Path newPath = base.getParent().resolve(this.getOldManualPath(oldPath));
        File file = newPath.toFile();
        FileInputStream stream = new FileInputStream(file);
        JsonObject old = new JsonParser().parse((Reader)new InputStreamReader(stream)).getAsJsonObject();
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.convertToNormalPage(old), (Path)this.getPathPage(base, newLoc));
    }

    public void convertAndMergeToNormalPage(Path base, DirectoryCache cache, List<ResourceLocation> oldPaths, ResourceLocation newLoc) throws JsonIOException, JsonSyntaxException, IOException {
        ArrayList<JsonObject> oldJsons = new ArrayList<JsonObject>();
        for (ResourceLocation path : oldPaths) {
            Path newPath = base.getParent().resolve(this.getOldManualPath(path));
            File file = newPath.toFile();
            FileInputStream stream = new FileInputStream(file);
            JsonObject old = new JsonParser().parse((Reader)new InputStreamReader(stream)).getAsJsonObject();
            oldJsons.add(old);
        }
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.convertAndMergeToNormalPage(oldJsons), (Path)this.getPathPage(base, newLoc));
    }

    protected JsonObject addChapter(String displayName, List<ResourceLocation> pages) {
        JsonObject root = new JsonObject();
        root.addProperty("display_name", displayName);
        JsonArray pageList = new JsonArray();
        for (ResourceLocation page : pages) {
            pageList.add(page.toString());
        }
        root.add("pages", (JsonElement)pageList);
        return root;
    }

    protected JsonObject addCoverPage(String title) {
        JsonObject root = new JsonObject();
        root.addProperty("type", PageType.COVER.toString().toLowerCase());
        root.addProperty("title", title);
        return root;
    }

    protected JsonObject createNormalPage(String text) {
        JsonObject root = new JsonObject();
        root.addProperty("type", PageType.NORMAL.toString().toLowerCase());
        root.addProperty("text", text);
        return root;
    }

    protected JsonObject convertAndMergeToNormalPage(List<JsonObject> oldPages) {
        JsonObject root = new JsonObject();
        root.addProperty("type", PageType.NORMAL.toString().toLowerCase());
        String text = "";
        for (JsonObject oldPage : oldPages) {
            for (JsonElement ele : oldPage.get("lines").getAsJsonArray()) {
                text = text.concat(ele.getAsString());
            }
        }
        root.addProperty("text", text);
        return root;
    }

    protected JsonObject convertToNormalPage(JsonObject old) {
        JsonObject root = new JsonObject();
        root.addProperty("type", PageType.NORMAL.toString().toLowerCase());
        String text = "";
        for (JsonElement ele : old.get("lines").getAsJsonArray()) {
            text = text.concat(ele.getAsString());
        }
        root.addProperty("text", text);
        return root;
    }

    private JsonObject createMainManualIndex() {
        JsonObject root = new JsonObject();
        JsonArray chapterList = new JsonArray();
        for (ResourceLocation chapter : this.chapters) {
            chapterList.add(chapter.toString());
        }
        root.add("chapters", (JsonElement)chapterList);
        return root;
    }

    public String func_200397_b() {
        return "Tardis Manual Migration Generator";
    }

    public static enum PageType {
        NORMAL,
        COVER;

    }

    public static enum ManualObjectType {
        MAIN_PAGE,
        CHAPTER,
        PAGE;

    }
}

