/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class TardisLootTableGen
extends LootTableProvider {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private DataGenerator generator;

    public TardisLootTableGen(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.generator.func_200391_b();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!block.getRegistryName().func_110624_b().contentEquals("tardis") || block.func_199767_j() == null || block.func_199767_j() == Items.field_190931_a) continue;
            if (block instanceof SlabBlock) {
                this.generateSelfSlabTable(block, cache, path);
                continue;
            }
            this.generateSelfTable(block, cache, path);
        }
    }

    public void generateSelfTable(Block block, DirectoryCache cache, Path base) {
        this.generateTable(cache, TardisLootTableGen.getPath(base, block.getRegistryName()), () -> this.createSingleDropTable(block.getRegistryName().toString()));
    }

    public void generateSelfSlabTable(Block block, DirectoryCache cache, Path base) {
        this.generateTable(cache, TardisLootTableGen.getPath(base, block.getRegistryName()), () -> this.createSlabDropTable(block.getRegistryName().toString()));
    }

    public void generateTable(DirectoryCache cache, Path path, Supplier<JsonElement> element) {
        try {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)element.get(), (Path)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String func_200397_b() {
        return "Tardis Mod Loot Gen";
    }

    public static Path getPath(Path base, Block block) {
        ResourceLocation key = block.getRegistryName();
        return base.resolve("data/" + key.func_110624_b() + "/loot_tables/blocks/" + key.func_110623_a() + ".json");
    }

    public static Path getPath(Path path, ResourceLocation rl) {
        return path.resolve("data/" + rl.func_110624_b() + "/loot_tables/blocks/" + rl.func_110623_a() + ".json");
    }

    public JsonElement createSingleDropTable(String name) {
        JsonObject root = new JsonObject();
        root.add("type", (JsonElement)new JsonPrimitive("minecraft:block"));
        JsonArray pools = new JsonArray();
        JsonObject first = new JsonObject();
        first.add("name", (JsonElement)new JsonPrimitive(name));
        first.add("rolls", (JsonElement)new JsonPrimitive((Number)1));
        JsonArray entry = new JsonArray();
        JsonObject type = new JsonObject();
        type.add("type", (JsonElement)new JsonPrimitive("minecraft:item"));
        type.add("name", (JsonElement)new JsonPrimitive(name));
        entry.add((JsonElement)type);
        first.add("entries", (JsonElement)entry);
        pools.add((JsonElement)first);
        root.add("pools", (JsonElement)pools);
        return root;
    }

    public JsonElement createSlabDropTable(String name) {
        JsonObject root = new JsonObject();
        root.add("type", (JsonElement)new JsonPrimitive("minecraft:block"));
        JsonArray pools = new JsonArray();
        JsonObject first = new JsonObject();
        first.add("name", (JsonElement)new JsonPrimitive(name));
        first.add("rolls", (JsonElement)new JsonPrimitive((Number)1));
        JsonArray entry = new JsonArray();
        JsonObject type = new JsonObject();
        type.add("type", (JsonElement)new JsonPrimitive("minecraft:item"));
        JsonArray functions1 = new JsonArray();
        JsonObject rootFunction = new JsonObject();
        rootFunction.add("function", (JsonElement)new JsonPrimitive("minecraft:set_count"));
        JsonArray conditions = new JsonArray();
        JsonObject rootCondition = new JsonObject();
        rootCondition.add("condition", (JsonElement)new JsonPrimitive("minecraft:block_state_property"));
        rootCondition.add("block", (JsonElement)new JsonPrimitive(name));
        JsonObject rootProperties = new JsonObject();
        rootProperties.add("type", (JsonElement)new JsonPrimitive("double"));
        rootCondition.add("properties", (JsonElement)rootProperties);
        conditions.add((JsonElement)rootCondition);
        rootFunction.add("conditions", (JsonElement)conditions);
        functions1.add((JsonElement)rootFunction);
        rootFunction.add("count", (JsonElement)new JsonPrimitive((Number)2));
        JsonObject extraFunction = new JsonObject();
        extraFunction.add("function", (JsonElement)new JsonPrimitive("minecraft:explosion_decay"));
        functions1.add((JsonElement)extraFunction);
        type.add("functions", (JsonElement)functions1);
        type.add("name", (JsonElement)new JsonPrimitive(name));
        entry.add((JsonElement)type);
        first.add("entries", (JsonElement)entry);
        pools.add((JsonElement)first);
        root.add("pools", (JsonElement)pools);
        return root;
    }
}

