/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.tardis.mod.blocks.RoundelBlock;
import net.tardis.mod.client.animation.ExteriorAnimationEntry;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.ArtronCapacitorItem;
import net.tardis.mod.items.ArtronItemStackBatteryItem;
import net.tardis.mod.items.DalekSpawnItem;
import net.tardis.mod.items.KeyItem;
import net.tardis.mod.items.SonicItem;
import net.tardis.mod.items.SpawnerItem;
import net.tardis.mod.items.TardisPartItem;
import net.tardis.mod.misc.Console;
import net.tardis.mod.missions.stages.DroneKillMissionStage;
import net.tardis.mod.missions.stages.MissionStage;
import net.tardis.mod.missions.stages.MissionStages;
import net.tardis.mod.potions.TardisPotions;
import net.tardis.mod.protocols.Protocol;
import net.tardis.mod.registries.ConsoleRegistry;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.registries.ExteriorAnimationRegistry;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.registries.InteriorHumRegistry;
import net.tardis.mod.registries.ProtocolRegistry;
import net.tardis.mod.registries.SoundSchemeRegistry;
import net.tardis.mod.registries.VortexMFunctions;
import net.tardis.mod.sounds.AbstractSoundScheme;
import net.tardis.mod.sounds.InteriorHum;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.vm.AbstractVortexMFunction;

public class TardisLangGen
extends LanguageProvider {
    private final DataGenerator generator;

    public TardisLangGen(DataGenerator gen) {
        super(gen, "tardis", "en_us");
        this.generator = gen;
    }

    protected void addTranslations() {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (!item.getRegistryName().func_110624_b().contentEquals("tardis")) continue;
            if (item instanceof BlockItem) {
                RoundelBlock block;
                BlockItem blockItem = (BlockItem)item;
                if (blockItem.func_179223_d() instanceof RoundelBlock) {
                    block = (RoundelBlock)blockItem.func_179223_d();
                    this.add(block.func_149739_a(), this.fixCapitalisations(block.getRegistryName().func_110623_a().trim().replace("roundel/", "") + " Roundel"));
                    continue;
                }
                if (item.getRegistryName().func_110623_a().contains("ars")) {
                    this.add(item.func_77658_a(), this.fixCapitalisations(item.getRegistryName().func_110623_a().trim().replace("ars", "ARS")));
                    continue;
                }
                if (item.getRegistryName().func_110623_a().contains("rca")) {
                    this.add(item.func_77658_a(), this.fixCapitalisations(item.getRegistryName().func_110623_a().trim().replace("rca", "RCA")));
                    continue;
                }
                block = blockItem.func_179223_d();
                this.add(block.func_149739_a(), this.fixCapitalisations(block.getRegistryName().func_110623_a()));
                continue;
            }
            if (item instanceof TardisPartItem) {
                if (item.getRegistryName().func_110623_a().equals("blank_upgrade")) {
                    this.add(item.func_77658_a(), this.fixCapitalisations(item.getRegistryName().func_110623_a()));
                }
                if (item.getRegistryName().func_110623_a().contains("upgrades")) {
                    this.add(item.func_77658_a(), this.fixCapitalisations(item.getRegistryName().func_110623_a().trim().replace("upgrades/", "") + " Upgrade"));
                }
                if (!item.getRegistryName().func_110623_a().contains("subsystem")) continue;
                this.add(item.func_77658_a(), this.fixCapitalisations(item.getRegistryName().func_110623_a().trim().replace("subsystem/", "")));
                continue;
            }
            if (item instanceof KeyItem) {
                this.add(item.func_77658_a(), "Tardis Key");
                continue;
            }
            if (item instanceof ArtronItemStackBatteryItem) {
                ArtronItemStackBatteryItem battery = (ArtronItemStackBatteryItem)item;
                if (item.getRegistryName().func_110623_a().equals("artron_battery")) {
                    this.add(item.func_77658_a(), "Artron Battery (\u00a79Basic\u00a7r)");
                    continue;
                }
                if (item.getRegistryName().func_110623_a().contains("medium")) {
                    this.add(item.func_77658_a(), "Artron Battery (\u00a72Medium\u00a7r)");
                    continue;
                }
                if (item.getRegistryName().func_110623_a().contains("high")) {
                    this.add(item.func_77658_a(), "Artron Battery (\u00a7eHigh\u00a7r)");
                    continue;
                }
                if (battery.isCreative()) {
                    this.add(item.func_77658_a(), "Artron Battery (\u00a7dCreative\u00a7r)");
                    continue;
                }
            }
            if (item instanceof ArtronCapacitorItem) {
                if (item.getRegistryName().func_110623_a().contains("mid")) {
                    this.add(item.func_77658_a(), "Artron Capacitor (\u00a7aMedium\u00a7r)");
                    continue;
                }
                if (item.getRegistryName().func_110623_a().contains("high")) {
                    this.add(item.func_77658_a(), "Artron Capacitor (\u00a7eHigh\u00a7r)");
                    continue;
                }
            }
            if (item instanceof SpawnerItem && item.getRegistryName().func_110623_a().contains("int_door")) {
                this.add(item.func_77658_a(), "Interior Door");
                continue;
            }
            if (item instanceof DalekSpawnItem) {
                this.add(item.func_77658_a(), this.fixCapitalisations(item.getRegistryName().func_110623_a().trim().replace("/", " - ")));
                continue;
            }
            if (item.getRegistryName().func_110623_a().contains("vm")) {
                this.add(item.func_77658_a(), this.fixCapitalisations(item.getRegistryName().func_110623_a().trim().replace("vm", "Vortex Manipulator")));
                continue;
            }
            if (item.getRegistryName().func_110623_a().equals("circuits")) {
                this.add(item.func_77658_a(), "Exotronic Circuit");
                continue;
            }
            if (item.getRegistryName().func_110623_a().contains("ars")) {
                this.add(item.func_77658_a(), this.fixCapitalisations(item.getRegistryName().func_110623_a().trim()).replace("Ars", "ARS"));
                continue;
            }
            if (item instanceof SonicItem) {
                this.add(item.func_77658_a(), "Sonic Screwdriver");
                continue;
            }
            this.add(item.func_77658_a(), this.fixCapitalisations(item.getRegistryName().func_110623_a()));
        }
        for (EntityType type : ForgeRegistries.ENTITIES) {
            if (!type.getRegistryName().func_110624_b().contentEquals("tardis")) continue;
            this.add(type.func_210760_d(), this.fixCapitalisations(type.getRegistryName().func_110623_a()));
        }
        this.add("entity.minecraft.villager.tardis.story_teller", "Story Teller");
        this.add("display_name.tardis.anti_grav", "Range: %s");
        this.add(((Effect)TardisPotions.MERCURY.get()).func_76393_a(), "Mercury Poisoning");
        this.add("itemGroup." + TItemGroups.FUTURE.func_200300_c(), "Future Blocks");
        this.add("itemGroup." + TItemGroups.ROUNDELS.func_200300_c(), "Roundels");
        this.add("itemGroup." + TItemGroups.MAIN.func_200300_c(), "TARDIS Mod");
        this.add("itemGroup." + TItemGroups.MAINTENANCE.func_200300_c(), "Ship Maintenance");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.COMMUNICATOR.get()), "Communicator");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.DIMENSION.get()), "Dimensional Shifters");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.DOOR.get()), "Door Switch");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.FACING.get()), "Exterior Facing");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.FAST_RETURN.get()), "Fast Return");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.HANDBRAKE.get()), "Handbrake");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.INC_MOD.get()), "XYZ Increment");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.LAND_TYPE.get()), "Vertical Land Type");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.MONITOR.get()), "Tardis Monitor");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.RANDOM.get()), "Randomiser");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.REFUELER.get()), "Refueler");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.SONIC_PORT.get()), "Sonic Port");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.STABILIZERS.get()), "Stabilisers");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.TELEPATHIC.get()), "Telepathic Circuits");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.THROTTLE.get()), "Throttle");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.X.get()), "X");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.Y.get()), "Y");
        this.add(this.getControlTranslationKeyFromEntry((ControlRegistry.ControlEntry)ControlRegistry.Z.get()), "Z");
        this.add("damagesrc.tardis.cyberman", "%s was deleted");
        this.add("damagesrc.tardis.dalek", "%s was exterminated by %s");
        this.add("damagesrc.tardis.dalek_spec", "%s was blown up by a Special Weapons Dalek");
        this.add("damagesrc.tardis.laser", "%s was disintegrated by %s's hand!");
        this.add("damagesrc.tardis.laser_sonic", "%s was disintegrated by &s via Laser Screwdriver");
        this.add("death.attack.damagesrc.tardis.space", "If there's life on Mars, %s ain't it");
        this.add("damagesrc.tardis.circuits", "%s was electrocuted by short circuiting live wires");
        this.add("damagesrc.tardis.tardis_squash", "%s was squished to pulp by the true mass of a Timeship");
        this.add("damagesrc.tardis.mercury", "%s succumbed to mercury poisoning");
        this.add("container.tardis.engine.north", "Components");
        this.add("container.tardis.engine.west", "Artron Banks");
        this.add("container.tardis.engine.east", "Charging/Attunement Panel");
        this.add("container.tardis.engine.south", "Upgrades");
        this.add("container.tardis.reclamation_unit", "Tardis Item Reclamation Unit");
        this.add("container.tardis.ship_computer", "Ship Computer");
        this.add("container.tardis.vm_battery", "Vortex Manipulator Battery");
        this.add("container.tardis.waypoint", "Waypoint Bank");
        this.add("container.tardis.alembic", "Alembic");
        this.add("container.tardis.spectrometer", "Spectrometer");
        this.add(((AbstractVortexMFunction)VortexMFunctions.SCANNER.get()).getTranslationKey(), "Scanner");
        this.add(((AbstractVortexMFunction)VortexMFunctions.DISTRESS_SIGNAL.get()).getTranslationKey(), "Distress Signal");
        this.add(((AbstractExterior)ExteriorRegistry.APERTURE.get()).getTranslationKey(), "Aperture Exterior");
        this.add(((AbstractExterior)ExteriorRegistry.CLOCK.get()).getTranslationKey(), "Clock Exterior");
        this.add(((AbstractExterior)ExteriorRegistry.DISGUISE.get()).getTranslationKey(), "Phased Optic Shell (Chameleon)");
        this.add(((AbstractExterior)ExteriorRegistry.FORTUNE.get()).getTranslationKey(), "Fortune Teller Exterior");
        this.add(((AbstractExterior)ExteriorRegistry.BOKKUSU.get()).getTranslationKey(), "Bokkusu Exterior");
        this.add(((AbstractExterior)ExteriorRegistry.MODERN_POLICE_BOX.get()).getTranslationKey(), "Modern Police Box (Mk 7)");
        this.add(((AbstractExterior)ExteriorRegistry.POLICE_BOX.get()).getTranslationKey(), "Police Box (Mk 3)");
        this.add(((AbstractExterior)ExteriorRegistry.SAFE.get()).getTranslationKey(), "Safe Exterior");
        this.add(((AbstractExterior)ExteriorRegistry.STEAMPUNK.get()).getTranslationKey(), "Steampunk Exterior");
        this.add(((AbstractExterior)ExteriorRegistry.TELEPHONE.get()).getTranslationKey(), "Red Telephone Box");
        this.add(((AbstractExterior)ExteriorRegistry.TRUNK.get()).getTranslationKey(), "Trunk Exterior");
        this.add(((AbstractExterior)ExteriorRegistry.TT_2020.get()).getTranslationKey(), "TT 2020 Exterior");
        this.add(((AbstractExterior)ExteriorRegistry.TT_CAPSULE.get()).getTranslationKey(), "TT Capsule Exterior");
        this.add(((Console)ConsoleRegistry.CORAL.get()).getTranslationKey(), "Coral Console");
        this.add(((Console)ConsoleRegistry.GALVANIC.get()).getTranslationKey(), "Galvanic Console");
        this.add(((Console)ConsoleRegistry.HARTNELL.get()).getTranslationKey(), "Hartnell Console");
        this.add(((Console)ConsoleRegistry.NEMO.get()).getTranslationKey(), "Nemo Console");
        this.add(((Console)ConsoleRegistry.NEUTRON.get()).getTranslationKey(), "Neutron Console");
        this.add(((Console)ConsoleRegistry.POLYMEDICAL.get()).getTranslationKey(), "Polymedical Console");
        this.add(((Console)ConsoleRegistry.STEAM.get()).getTranslationKey(), "Steam Console");
        this.add(((Console)ConsoleRegistry.TOYOTA.get()).getTranslationKey(), "Toyota Console");
        this.add(((Console)ConsoleRegistry.XION.get()).getTranslationKey(), "Xion Console");
        this.add("interiors.tardis.interior_abandoned_alabaster", "Abandoned Alabaster Interior");
        this.add("interiors.tardis.interior_abandoned_imperial", "Abandoned Imperial Interior");
        this.add("interiors.tardis.interior_abandoned_jade", "Abandoned Jade Interior");
        this.add("interiors.tardis.interior_abandoned_nautilus", "Abandoned Nautilus Interior");
        this.add("interiors.tardis.interior_abandoned_panamax", "Abandoned Panamax Interior");
        this.add("interiors.tardis.interior_abandoned_steam", "Abandoned Steam Interior");
        this.add("interiors.tardis.interior_alabaster", "Alabaster Interior");
        this.add("interiors.tardis.interior_amethyst", "Amethyst Interior");
        this.add("interiors.tardis.interior_architect", "Architect Interior");
        this.add("interiors.tardis.interior_coral", "Coralised Interior");
        this.add("interiors.tardis.interior_debug_clean", "[DEV ONLY] Debug Interior");
        this.add("interiors.tardis.interior_envoy", "Envoy Interior");
        this.add("interiors.tardis.interior_imperial", "Imperial Interior");
        this.add("interiors.tardis.interior_jade", "Jade Interior");
        this.add("interiors.tardis.interior_metallic", "Metallic Interior");
        this.add("interiors.tardis.interior_nautilus", "Nautilus Interior");
        this.add("interiors.tardis.interior_omega", "Omega Interior");
        this.add("interiors.tardis.interior_panamax", "Panamax Interior");
        this.add("interiors.tardis.interior_steam", "Steam Interior");
        this.add("interiors.tardis.interior_toyota", "Toyota Interior");
        this.add("interiors.tardis.interior_traveler", "Traveler Interior");
        this.add("ars.piece.tardis.corridor.alabaster.fourway", "Alabaster Fourway");
        this.add("ars.piece.tardis.corridor.alabaster.t_junction", "Alabaster T-Connection");
        this.add("ars.piece.tardis.corridor.alabaster.short", "Alabaster Short Straight Piece");
        this.add("ars.piece.tardis.corridor.alabaster.long", "Alabaster Long Straight Piece");
        this.add("ars.piece.tardis.corridor.alabaster.turn_left", "Alabaster Left Corner");
        this.add("ars.piece.tardis.corridor.alabaster.turn_right", "Alabaster Right Corner");
        this.add("ars.piece.tardis.corridor.dark.fourway", "Dark Fourway");
        this.add("ars.piece.tardis.corridor.dark.t_junction", "Dark T-Connection");
        this.add("ars.piece.tardis.corridor.dark.short", "Dark Short Straight Piece");
        this.add("ars.piece.tardis.corridor.dark.long", "Dark Long Straight Piece");
        this.add("ars.piece.tardis.corridor.dark.turn_left", "Dark Left Corner");
        this.add("ars.piece.tardis.corridor.dark.turn_right", "Dark Right Corner");
        this.add("ars.piece.tardis.corridor.steam.turn_left", "Steam Left Turn");
        this.add("ars.piece.tardis.corridor.steam.turn_right", "Steam Right Turn");
        this.add("ars.piece.tardis.corridor.steam.t_junction", "Steam T-Junction");
        this.add("ars.piece.tardis.corridor.steam.fourway", "Steam Fourway");
        this.add("ars.piece.tardis.corridor.steam.short", "Steam Short Straight");
        this.add("ars.piece.tardis.corridor.steam.long", "Steam Long Straight");
        this.add("ars.piece.tardis.room.large_room", "Empty Large");
        this.add("ars.piece.tardis.room.library", "Library");
        this.add("ars.piece.tardis.room.lab", "Laboratory");
        this.add("ars.piece.tardis.room.workroom_1", "Workroom Variant 1");
        this.add("ars.piece.tardis.room.workroom_2", "Workroom Variant 2");
        this.add("ars.piece.tardis.room.workroom_3", "Workroom Variant 3");
        this.add("ars.piece.tardis.room.storeroom", "Storeroom");
        this.add("ars.piece.tardis.room.hydroponics", "Hydroponics Farm");
        this.add("ars.piece.tardis.room.hydroponics_large", "Large Hydroponics Farm");
        this.add("ars.piece.tardis.room.ars_tree", "ARS Tree");
        this.add("ars.piece.tardis.room.gravity_shaft_down", "Gravity Shaft Down");
        this.add("ars.piece.tardis.room.gravity_shaft_up", "Gravity Shaft Up");
        this.add("ars.piece.tardis.room.archives", "Archive Library");
        this.add("ars.piece.tardis.room.cloister", "Cloister Room");
        this.add("ars.piece.tardis.room.machinery_workshop", "Machinery Workshop");
        this.add("ars.piece.category.tardis.room", "Room");
        this.add("ars.piece.category.tardis.corridor", "Corridor");
        this.add("ars.piece.category.tardis.alabaster", "Alabaster");
        this.add("ars.piece.category.tardis.dark", "Dark");
        this.add("ars.piece.category.tardis.steam", "Steam");
        this.add("flight_events.tardis.scrap", "WARNING: Vortex Scrap Incoming!");
        this.add("flight_events.tardis.time_wind", "WARNING: Time Winds Approaching!");
        this.add("flight_events.tardis.bulkhead", "WARNING: Exterior Bulkhead Failing!");
        this.add("flight_events.tardis.x", "WARNING: Spatial Drift X!");
        this.add("flight_events.tardis.y", "WARNING: Spatial Drift Y!");
        this.add("flight_events.tardis.z", "WARNING: Spatial Drift Z!");
        this.add("flight_events.tardis.refueler", "WARNING: Low Artron Flow!");
        this.add("flight_events.tardis.door", "WARNING: Exterior Bulkhead Failing!");
        this.add("flight_events.tardis.dimension", "WARNING: Dimensional Drift!");
        this.add("flight_events.tardis.vertical", "WARNING: Vertical Displacement Error!");
        this.add("flight_events.tardis.collide_instigate", "CRITICAL: Time Ram Imminent!");
        this.add("flight_events.tardis.collide_recieve", "CRITICAL: Time Ram Incoming!");
        this.add("flight_events.tardis.residual_artron", "INFO: Artron Pocket Detected!");
        for (AbstractSoundScheme scheme : SoundSchemeRegistry.SOUND_SCHEME_REGISTRY.get().getValues()) {
            this.add(scheme.getTranslationKey(), this.fixCapitalisations(scheme.getRegistryName().func_110623_a()));
        }
        this.add("protocol.tardis.antigrav_on", "Deactivate Anti-gravs");
        this.add("protocol.tardis.antigrav_off", "Activate Anti-gravs");
        this.add("protocol.tardis.forcefield_on", "Turn Forcefield On");
        this.add("protocol.tardis.forcefield_off", "Turn Forcefield Off");
        this.add("protocol.tardis.forcefield_turned_on", "Turned Forcefields On");
        this.add("protocol.tardis.forcefield_turned_off", "Turned Forcefields Off");
        this.add("protocol.tardis.forcefield_broken", "ERROR: Unable to activate Forcefield! Repair the Shield Generator!");
        this.add(((Protocol)ProtocolRegistry.LIFE_SCAN.get()).getTranslationKey(), "Scan for Life Signs");
        this.add(((Protocol)ProtocolRegistry.TOGGLE_ALARM.get()).getTranslationKey(), "Toggle Alarm");
        this.add("schematic.tardis.exterior", "Exterior Schematic: %s");
        this.add("schematic.tardis.interior", "Interior Schematic: %s");
        this.add("sonic.mode.type", "Type:\u00a77 %s");
        this.add("sonic.mode.type.desc", "Description:\u00a77 %s");
        this.add("sonic.mode.block_interaction", "Block Interaction");
        this.add("sonic.mode.block_interaction.desc", "Interact with blocks in the world");
        this.add("sonic.mode.entity_interaction", "Entity Interactions");
        this.add("sonic.mode.entity_interaction.desc", "Interact with entities in the world");
        this.add("sonic.mode.probe", "Passive Probe");
        this.add("sonic.mode.probe.desc", "Scans the nearby area every second for space-time anomolies");
        this.add("sonic.mode.set_destination", "Tardis Co-ordinates");
        this.add("sonic.mode.set_destination.desc", "Sets Tardis destination to block position, but doesn't summon it.");
        this.add("sonic.mode.laser_interaction", "Lasers");
        this.add("sonic.mode.laser_interaction.desc", "Fire Lasers");
        this.add("sonic.modes.info.interactable_blocks", "Interactable blocks:");
        this.add("sonic.mode.charge", "Charge: \u00a7d%s");
        this.add("sonic.modes.info.interactable_entities", "Interactable entities:");
        this.add("sonic.modes.info.set_coords", "Right clicking in the world will set the attuned Tardis's destination coordinates to the right clicked position");
        this.add("tooltip.tardis.stored_schematic", "Stored Schematics:");
        this.add("sonic.component_name.mk_1", "Prototype");
        this.add("sonic.component_name.mk_2", "Radiometric");
        this.add("sonic.component_name.mk_3", "Biopolymer");
        this.add("sonic.component_name.mk_4", "Electrostructural");
        this.add("sonic.component_name.mk_5", "Quadrophonic");
        this.add("sonic.component_name.mk_6", "Transtemporal");
        this.add("sonic.component_name.mk_7", "Phased-Photon");
        this.add(((AbstractVortexMFunction)VortexMFunctions.TELEPORT.get()).getTranslationKey(), "Teleport");
        this.add(((AbstractVortexMFunction)VortexMFunctions.BATTERY.get()).getTranslationKey(), "Battery");
        this.add(((InteriorHum)InteriorHumRegistry.COPPER.get()).getTranslationKey(), "Copper's Hum");
        this.add(((InteriorHum)InteriorHumRegistry.CORAL.get()).getTranslationKey(), "Coral's Hum");
        this.add(((InteriorHum)InteriorHumRegistry.DISABLED.get()).getTranslationKey(), "Disable Hums");
        this.add(((InteriorHum)InteriorHumRegistry.EIGHTY.get()).getTranslationKey(), "80's Hum");
        this.add(((InteriorHum)InteriorHumRegistry.SEVENTY.get()).getTranslationKey(), "70's Hum");
        this.add(((InteriorHum)InteriorHumRegistry.SIXTY_THREE.get()).getTranslationKey(), "63's Hum");
        this.add(((InteriorHum)InteriorHumRegistry.TOYOTA.get()).getTranslationKey(), "Toyota's Hum");
        this.add(((InteriorHum)InteriorHumRegistry.TV.get()).getTranslationKey(), "TV Hum");
        this.add(((ExteriorAnimationEntry)ExteriorAnimationRegistry.CLASSIC.get()).getTranslationKey(), "Exterior Animation: Classic");
        this.add(((ExteriorAnimationEntry)ExteriorAnimationRegistry.NEW_WHO.get()).getTranslationKey(), "Exterior Animation: New Who");
        this.add("texvar.tardis.tardis.common.normal", "Normal");
        this.add("texvar.tardis.exterior.trunk.dark", "Dark");
        this.add("texvar.tardis.console.steam.normal", "Normal");
        this.add("texvar.tardis.console.steam.ironclad", "Iron Clad");
        this.add("texvar.tardis.console.steam.rosewood", "Rosewood");
        this.add("texvar.tardis.console.nemo.normal", "Normal");
        this.add("texvar.tardis.console.nemo.ivory", "Ivory");
        this.add("texvar.tardis.console.nemo.wood", "Wooden");
        this.add("texvar.tardis.console.nemo.classic", "Classic");
        this.add("texvar.tardis.console.toyota.normal", "Normal");
        this.add("texvar.tardis.console.toyota.violet", "Violet");
        this.add("texvar.tardis.console.toyota.blue", "Blue");
        this.add("texvar.tardis.console.galvanic.imperial", "Imperial");
        this.add("texvar.tardis.console.galvanic.wood", "Wooden");
        this.add("texvar.tardis.console.galvanic.sith", "Sith");
        this.add("texvar.tardis.console.xion.glass", "Glass");
        this.add("texvar.tardis.console.xion.sapphire", "Sapphire");
        this.add("texvar.tardis.console.xion.ruby", "Ruby");
        this.add("texvar.tardis.exterior.steam.normal", "Normal");
        this.add("texvar.tardis.exterior.steam.blue", "Blue");
        this.add("texvar.tardis.exterior.steam.rust", "Rusted");
        this.add("texvar.tardis.exterior.fortune.normal", "Normal");
        this.add("texvar.tardis.exterior.fortune.blue", "Blue");
        this.add("texvar.tardis.exterior.fortune.red", "Red");
        this.add("texvar.tardis.console.coral.blue", "Blue");
        this.add("texvar.tardis.console.coral.white", "White");
        this.add("texvar.tardis.console.neutron.thaumic", "Thaumic");
        this.add("texvar.tardis.console.neutron.brass", "Brass");
        this.add("texvar.tardis.exterior.telephone.cyberpunk", "Cyberpunk");
        this.add("artronuse.tardis.forcefield", "Forcefield");
        this.add("artronuse.tardis.converter", "Artron to FE Converter");
        this.add("artronuse.tardis.flight", "Flight");
        this.add("artronuse.tardis.antigravs", "Anti-Grav System");
        this.add("artronuse.tardis.interior_change", "Interior Reconfiguration");
        this.add("mood.tardis.ecstatic", "The TARDIS is feeling Ecstatic!");
        this.add("mood.tardis.happy", "The TARDIS is feeling Happy!");
        this.add("mood.tardis.content", "The TARDIS is feeling Content");
        this.add("mood.tardis.apathetic", "The TARDIS is feeling Apathetic!");
        this.add("mood.tardis.discontent", "The TARDIS is feeling Discontent");
        this.add("mood.tardis.sad", "The TARDIS is feeling Sad!");
        this.add("laser_power_tier.tardis.low", "Low");
        this.add("laser_power_tier.tardis.medium", "Medium");
        this.add("laser_power_tier.tardis.high", "High");
        this.add("config.tardis.enableBoti", "Enable Boti Rendering");
        this.add("config.tardis.botiBlacklistedBlocks", "BOTI Blacklisted Block IDs");
        this.add("config.tardis.botiBlacklistedEntities", "BOTI Blacklisted Entity IDs");
        this.add("config.tardis.show_more_machine_tooltips", "Show more Machine tooltips");
        this.add("config.tardis.play_tool_notification_sound", "Play Tool Notification Sounds");
        this.add("config.tardis.display_optifine_warning", "Display Optifine Warning");
        this.add("config.tardis.openVMEmptyHand", "Open VM GUI with Empty Hand");
        this.add("config.tardis.interiorShake", "Tardis Interior Camera Shake");
        this.add("config.tardis.tardis_spawn_chance", "Broken Tardis Generation Chance");
        this.add("config.tardis.tardis_spawn_dim_blacklist", "Broken Tardis Dimension Blacklist");
        this.add("config.tardis.cinnabar_ore_spawn_chance", "Cinnabar Ore Generation Chance");
        this.add("config.tardis.xion_crystal_spawn_chance", "Xion Crystal Generation Chance");
        this.add("config.tardis.dalek_join_village_raid", "Should Daleks join Village Raids?");
        this.add("config.tardis.dalek_village_raid_spawn_count", "Dalek Village Raid Wave Spawns");
        this.add("config.tardis.structure_spawn_chance", "Structure Generation Chance");
        this.add("config.tardis.structure_seperation", "Structure Seperation Distance");
        this.add("config.tardis.structure_spacing", "Structure Spacing Distance");
        this.add("config.tardis.village_structure_weight", "Village Structure Spawn Weight");
        this.add("config.tardis.blacklistedDims", "Blacklisted Tardis Destination Dimensions");
        this.add("config.tardis.dims_handle_tardis_void_teleport", "Dimensions to Allow Tardis Void Teleport Mechanics");
        this.add("config.tardis.tardis_abandonment_timer", "Tardis Abandonment Timer");
        this.add("config.tardis.machines.transduction_drain_amount", "Transduction Barrier Energy Per Use");
        this.add("config.tardis.machines.transduction_energy_max_capacity", "Transduction Barrier Max Energy");
        this.add("config.tardis.machines.transduction_effective_range", "Transduction Barrier Effective Range");
        this.add("config.tardis.machines.artron_collector_battery_charge_rift", "Artron Collector Charge Rate");
        this.add("config.tardis.machines.artron_pylon_rift_drain_rate", "Artron Pylon Rift Drain Rate");
        this.add("config.tardis.machines.roundel_tap_energy_transfer_rate", "Roundel Tap Forge Energy Transfer Rate");
        this.add("config.tardis.vm.toggleVMDimWhitelist", "Toggle Vortex Manipulator Dimension Whitelist");
        this.add("config.tardis.vm.whitelistedDims", "Whitelisted VM Destination Dimensions");
        this.add("config.tardis.vm.blacklistedDims", "Blacklisted VM Destination Dimensions");
        this.add("config.tardis.vm.teleportRange", "Teleport Range");
        this.add("config.tardis.vm.cooldownTime", "Use Cooldown");
        this.add("config.tardis.vm.sideEffects", "Side Effect List");
        this.add("config.tardis.vm.sideEffectTime", "Side Effect Duration");
        this.add("config.tardis.vm.baseFuelUsage", "Base Fuel Usage");
        this.add("config.tardis.vm.fuelUsageMultiplier", "Fuel Usage Multiplier");
        this.add("config.tardis.vm.fuelUsageTime", "Fuel Usage Rate");
        this.add("config.tardis.open_doors", "Open Doors");
        this.add("config.tardis.detonate_tnt", "Should Sonics detonate TNT?");
        this.add("config.tardis.redstone_lamps", "Should Sonics toggle Redstone Lamps?");
        this.add("config.tardis.open_trapdoors", "Should Sonics open non-wooden trapdoors?");
        this.add("config.tardis.toggle_redstone", "Should Sonics toggle redstone?");
        this.add("config.tardis.detonate_creeper", "Should Sonics detonate Creepers?");
        this.add("config.tardis.shear_sheep", "Can Sonics shear sheep?");
        this.add("config.tardis.dismantle_skeleton", "Can Sonics dismantle Skeleton-type entities?");
        this.add("config.tardis.ink_squid", "Can Sonics make Squids squirt ink?");
        this.add("config.tardis.coordinate_tardis", "Can Sonics set the Tardis destination?");
        this.add("config.tardis.laser_fire", "Can Sonics shoot lasers?");
        this.add("config.tardis.dalek.dalek_block_grief", "Dalek Block Griefing");
        this.add("config.tardis.dalek_special_weapons_always_explode", "Special Weapons Lasers Always Explode");
        this.add("config.tardis.dalek.special_weapon_explosion_radius", "Special Weapon Explosion Radius");
        this.add("config.tardis.dalek.dalek_target_all", "Target All Living Entities");
        this.add("config.tardis.dalek.dalek_target_hostile_only", "Target Hostiles Only");
        this.add("config.tardis.dalek.dalek_target_animals", "Target Animals");
        this.add("config.tardis.dalek.dalek_target_players", "Target Players");
        this.add("config.tardis.dalek.dalek_target_villagers", "Target Villagers");
        this.add("missions.tardis.drone_station", "Space Station Mission");
        this.add(TardisConstants.Translations.MISSION_OBJECTIVE.func_150268_i(), "Objective");
        this.add(((MissionStage)MissionStages.NOT_STARTED.get()).getTranslationKey(), "Mission Not Started");
        this.add(((MissionStage)MissionStages.RETURN_TO_MISSION_HOST.get()).getTranslationKey(), "Return to: ");
        this.add(DroneKillMissionStage.KILL_DRONES_DESCRIPTION.func_150268_i(), "Kill the rogue Security Drones");
        this.add(((MissionStage)MissionStages.MISSION_COMPLETED.get()).getTranslationKey(), "Mission Complete!");
        this.add("mission.tardis.generic_distress_message", "SOS Detected!");
        this.add("mission.tardis.drone_station.dialog.character.capt.confused_greet", "Hello...what are you doing here?");
        this.add("mission.tardis.drone_station.dialog_option.player.respond_sos_with_intro", "The name is %s, I'm responding to your S.O.S");
        this.add("mission.tardis.drone_station.dialog_option.player.agree_to_help", "I'll help!");
        this.add("mission.tardis.drone_station.dialog.character.capt.hostile_greet", "Stop! Why are you. on. my. ship?!");
        this.add("mission.tardis.drone_station.dialog.character.capt.relieved_request", "Thank the stars! The ship's security drones seem to have malfunctioned and started killing the crew! We're all that's left. We have managed to lock ourselves here, in the bridge, but we need someone to take them out!");
        this.add("mission.tardis.drone_station.dialog_option.player.understand_request", "Alright.");
        this.add("mission.tardis.drone_station.dialog.character.capt.frustrated_request", "Why didn't you say so? The ship's security programs went rogue and started attacking us! I managed to lock us in here, but we need someone to take them out quick!");
        this.add("mission.tardis.drone_station.dialog_option.player.ignore_frustrated_request", "Alright. You have the best of luck with that.");
        this.add("mission.tardis.drone_station.dialog_option.player.respond_sos_pacifying", "Alright, take it easy! I'm responding to your SOS.");
        this.add("mission.tardis.drone_station.dialog_option.player.smartass", "Well, you know, I was in the neighborhood and I thought...");
        this.add("mission.tardis.drone_station.dialog.character.capt.followup_player", "Hurry, please!");
        this.add("mission.tardis.drone_station.dialog_option.player.followup_polite", "I'm working on it!");
        this.add("mission.tardis.drone_station.dialog_option.player.followup_rude", "Shut up and let me work!");
        this.add("mission.tardis.drone_station.dialog_option.player.followup_frustrated", "Do you want to do it instead?");
        this.add("mission.tardis.drone_station.dialog.character.capt.followup_player.more_drones", "Thank you! Our scans indicate there are still rogue drones around! Please hurry!");
        this.add("mission.tardis.drone_station.dialog_option.player.acknowledge_polite", "Understood, thanks.");
        this.add("mission.tardis.drone_station.dialog_option.player.acknowledge_rude", "I know, I know!");
        this.add("mission.tardis.drone_station.dialog_option.player.acknowledge_frustrated", "Come on, why couldn't this be easier?");
        this.add("mission.tardis.drone_station.dialog.character.capt.thankful_reward", "Here, take this, it's part of our navigation systems. It may not look much, but It should be very valuable in the right hands.");
        this.add("mission.tardis.drone_station.dialog_option.player.polite_accept_reward", "Thank you, I'm sure I can find use for it on my ship!");
        this.add("mission.tardis.drone_station.dialog_option.player.ungrateful_accept_reward", "Really? A piece of scrap?");
        this.add("companion.tardis.dialog.hello", "What's up?");
        this.add("companion.tardis.dialog_option.wait", "I need you to wait here");
        this.add("companion.tardis.dialog_option.follow", "Follow me");
        this.add("companion.tardis.dialog_option.fly_tardis", "I want you to watch me, learn how to fly the TARDIS");
        this.add("message.tardis.optifine_warning", "Optifine may cause issues with TARDIS Mod's portal effect! Please disable it or remove Optifine.");
        this.add("message.vm.header", "===VM===");
        this.add("message.vm.scanner.result", "There are \u00a7d%s \u00a7rOther Players and \u00a7d%s \u00a7rMonsters \u00a7rin a %s block radius!");
        this.add("message.vm.forbidden", "Safety Warning!\nNot permitted to use\nwithin this dimension!");
        this.add("message.vm.invalidPos", "Invalid Destination Position!");
        this.add("message.vm.invalidInput", "Invalid Coordinate Input!\nEnter a whole number for: \u00a7d%s coordinate!");
        this.add("message.vm.illegalPos", "Destination Position exceeds\nTeleport Range of %s blocks!\nEnter a valid position in the %s coordinate!");
        this.add("message.vm.fuel_empty", "You do not have enough fuel to make this journey! \nYou need at least: \u00a7d%s \u00a7rArtron Units in total!");
        this.add("message.vm.distress_sent", "Distress Signal sent to: %s");
        this.add("message.vm.lightning_malfunction", "Device Malfunction! Initiating Jump!");
        this.add("message.vm.distress_signal_message", "VM Distress Signal");
        this.add("message.tardis.distress_signal.player", "%s sent a distress signal");
        this.add("message.tardis.energy_buffer", "Forge Energy: %s/%s FE");
        this.add("message.tardis.transduction_barrier.code", "Transduction Code: %s");
        this.add("message.tardis.multiblock.invalid_place", "There isn't enough space to place this!");
        this.add("message.tardis.wood_fail", "It doesn't work on wood!");
        this.add("message.tardis.detonate_tnt", "Detonating TNT!");
        this.add("message.tardis.use.requires_sonic", "You can only use this with a Sonic Screwdriver!");
        this.add("message.sonic.invalid_result", "ERROR: Target is not a valid block/entity!");
        this.add("message.tardis.found_rift", "Space-Time Rift Detected! Energy: %s AU");
        this.add("message.tardis.control.dimchange", "Target Dimension set to: ");
        this.add("message.tardis.control.facing", "Directional Placement set to: ");
        this.add("message.tardis.control.inc_mod", "Coordinate Increment Modifier set to: ");
        this.add("message.tardis.control.land_type", "Vertical Scanning Mode: ");
        this.add("message.tardis.control.refuel.true", "Refueling Protocols \u00a7dEngaged");
        this.add("message.tardis.control.refuel.false", "Refueling Protocols \u00a7dDisengaged");
        this.add("message.tardis.control.stabilizer.true", "Stabilizers \u00a7dActive");
        this.add("message.tardis.control.stabilizer.false", "Stabilizers \u00a7dDeactivated");
        this.add("message.tardis.door.locked", "TARDIS locked!");
        this.add("message.tardis.door.unlocked", "TARDIS unlocked!");
        this.add("message.tardis.scanner", "%s humanoid(s) and %s other life signs detected!");
        this.add("message.tardis.set_coord_map", "Set Destination to centre of Map! (%s)");
        this.add("message.tardis.beacon_sent", "Distress Signal sent to all nearby Timeships!");
        this.add("message.tardis.item_not_attuned", "This item cannot be used, it is not attuned to a Timeship!");
        this.add("message.tardis.wrong_item", "You can only access this block using a %s");
        this.add("message.tardis.use.outside_tardis", "You can only use this inside a Tardis!");
        this.add("message.tardis.not_enough_artron", "Not enough Artron! You need %s more!");
        this.add("message.tardis.use.in_dim", "You cannot use this in the current dimension!");
        this.add("message.tardis.outside_border", "WARNING: Exceeding World Border! Redirecting!");
        this.add("message.tardis.telepathic.success", "INFO: Loaded Coordinates into Nav-Com!");
        this.add("message.tardis.telepathic.not_found", "ERROR: Failed to locate %s in range! (%s)");
        this.add("message.data_crystal.transfer_to_bank", "Transferred Waypoints to Waypoint Bank!");
        this.add("message.data_crystal.extract_from_bank", "Extracted Waypoints from Waypoint Bank!");
        this.add("message.tardis.not_enough_charge", "Not enough charge! You need \u00a7d%s \u00a7rmore!");
        this.add("message.sonic.tardis_dest_set", "Timeship Destination set to: \u00a7d%s");
        this.add("message.sonic.tardis_dest_fail", "Cannot set Timeship Destination in this Dimension!");
        this.add("message.tardis.no_tardis_found", "No TARDIS Found with the specified ID: \n%s");
        this.add("message.monitor_remote.use", "You can only use this on a Tardis Monitor!");
        this.add("message.tardis.snap.denied", "This Timeship is not loyal enough to open as commanded!");
        this.add("message.tardis.interior_cooldown", "Interior Cooldown (%s seconds!)");
        this.add("message.tardis.vm.function_locked", "\u00a7cLocked: WIP");
        this.add("message.tardis.waypoint.saved", "INFO: Saved Waypoint %s");
        this.add("message.tardis.waypoint.save_fail", "ERROR: Failed to save waypoint %s");
        this.add("message.tardis.waypoint.save_fail_dimension", "ERROR: Cannot to save waypoint %s for blacklisted dimension!");
        this.add("message.waypoint.loaded", "INFO: Loaded Waypoint %s");
        this.add("message.tardis.waypoints.delete", "INFO: Deleted Waypoint %s");
        this.add("message.tardis.ars.selected_piece", "Selected ARS Structure: ");
        this.add("message.tardis.ars.structure_null", "You have not selected a valid ARS Structure with the ARS Tablet!");
        this.add("message.tardis.ars.room.delete.concurrent_mod.denied", "ERROR: You cannot create a new room whilst deleting an existing room!");
        this.add("message.tardis.ars.structure_not_found", "\u00a7cERROR: \u00a77Could not load structure:\u00a7r %s");
        this.add("message.tardis.ars.room.delete_countdown", "\u00a7e\u00a7lTardis Room Deletion in: \u00a7d\u00a7l%s \u00a7e\u00a7lseconds!");
        this.add("message.tardis.ars.room.deleted", "\u00a7aTardis Room Deletion Complete!\n\u00a7rYou have been teleported to the Console Room!");
        this.add("message.tardis.computer.downloaded", "Downloaded Data Fragments!");
        this.add("message.tardis.no_subsystem", "WARNING: %s doesn't have enough health or is not activated!");
        this.add("message.tardis.telepathic.not_connected", "You feel the connection fade");
        this.add("message.tardis.telepathic.connected", "You feel connected to this Timeship");
        this.add("message.tardis.transduction.set_code", "Set Landing Code to: %s");
        this.add("message.tardis.not_admin", "ERROR: This Tardis is not loyal enough to you to perform this action");
        this.add("message.tardis.door.deadlocked", "Access denied! This Timeship is Deadlocked!");
        this.add("message.tardis.door.interior_change", "Entry Forbidden! Interior Reconfiguration in Progress! (%s seconds remaining)");
        this.add("message.tardis.change_interior.started", "Interior Reconfiguration to %s started! All occupants, please exit this Timeship to start the process");
        this.add("message.tardis.change_interior.cancelled", "Interior Reconfiguration Process Cancelled!");
        this.add("message.tardis.change_interior.complete", "Interior Reconfiguration Process Completed for Timeship %s!");
        this.add("message.tardis.change_interior.interrupted", "Interior Reconfiguration Process Interrupted for Timeship %s! Relocated player to the exterior to resume the process!");
        this.add("message.tardis.anti_gravs.true", "Activated Anti-Gravity Protocols");
        this.add("message.tardis.anti_gravs.false", "Deactivated Anti-Gravity Protocols");
        this.add("message.tardis.subsystem.not_activated.shield_generator", "ERROR: Shield Generator is not Activated!");
        this.add("message.tardis.corridor.blocked", "ERROR: Cannot place structure due to existing blocks");
        this.add("message.tardis.corridor.blocked_positions", "ERROR: Please ensure the area between %s and %s are clear of any blocks. Conflicting position at: %s");
        this.add("message.tardis.interior.unlock", "Unlocked interior %s!");
        this.add("message.tardis.exterior.unlock", "Unlocked exterior %s!");
        this.add("message.tardis.console.unlock", "Unlocked console %s!");
        this.add("message.tardis.existing_unlock", "Object %s has already been unlocked!");
        this.add("message.tardis.time_link.linked", "Time Link Upgrade now linked to: ");
        this.add("message.tardis.roundel_tap.push_to_tardis", "Tap is now pushing energy to Tardis");
        this.add("message.tardis.roundel_tap.push_to_blocks", "Tap is now pushing energy to nearby blocks");
        this.add("message.laser_gun.set_power_tier", "Set Power Tier to: ");
        this.add("message.tardis.automated_distress_message", "Automated SOS!");
        this.add("message.tardis.generic_all", "All");
        this.add("message.tardis.generic_none", "None");
        this.add("message.tardis.world_spawn", "World Spawn");
        this.add("trait.tardis.dislike_location", "The timeship doesn't like this location");
        this.add("trait.tardis.like_location", "The timeship likes this location");
        this.add("trait.tardis.generic_like", "The timeship likes that");
        this.add("trait.tardis.generic_dislike", "The timeship dislikes that");
        this.add("tooltip.item.info.shift", "\u00a77Hold \u00a78[\u00a7eLeft Shift\u00a78]");
        this.add("tooltip.item.info.shift_control", "\u00a77Hold \u00a78[\u00a7eLeft Shift\u00a78] \u00a77and \u00a78[\u00a7eLeft Control\u00a78]");
        this.add("tooltip.item.info.control", "\u00a77Hold \u00a78[\u00a7eLeft Control\u00a78]");
        this.add("tooltip.item.redstone.required", "This requires a Redstone Signal to activate!");
        this.add("tooltip.item.artron_battery_required", "Requires Artron Batteries");
        this.add("tooltip.item.info.disabled", "This feature has been disabled");
        this.add("tooltip.tardis.container.empty_fluid", "Empty");
        this.add("tooltip.tardis.container.fluid", "Fluid: ");
        this.add("tooltip.tardis.container.progress", "Progress: ");
        this.add("tooltip.tardis.container.estimated_time_arrival", "ETA: ");
        this.add("tooltip.tardis.container.millibuckets", " MB");
        this.add("tooltip.tardis.container.seconds", " s");
        this.add("fluid.tardis.mercury", "Mercury");
        this.add("tooltip.item.description_prefix", "Description: ");
        this.add("tooltip.laser_gun.charge.none", "No Charge!");
        this.add("tooltip.laser_gun.charge", "Charge: ");
        this.add("tooltip.laser_gun.shots_left", "Estimated Shots Left: ");
        this.add("tooltip.laser_gun.num_batteries", "Battery Count: ");
        this.add("tooltip.laser_gun.tier", "Power Tier: ");
        this.add("tooltip.laser_gun.description", "Add or remove batteries with %s.\nUse Sneak and Right Click to change power tiers.");
        this.add("tooltip.monitor_remote.use", "Adjusts camera angle of Monitor Scanner Mode \nAdjusts arm extension length on Rotating Monitor Block\nSneak and right click on a Tardis Monitor");
        this.add("tooltip.item.attuned.owner", "Attuned to: ");
        this.add("tooltip.item.not_attuned", "\u00a78[\u00a7cNot Attuned\u00a78]");
        this.add("tooltip.tardis.diagnostic.owner", "Tracking Timeship: ");
        this.add("tooltip.tardis.diagnostic.use", "Hold this and look around until you hear a beeping noise to locate your Timeship Exterior or Console.");
        this.add("tooltip.tardis.diagnostic.use2", "Hover over the console block to view system dashboard");
        this.add("tooltip.stat_remote.use", "Right click on a block to summon your Timeship");
        this.add("tooltip.stat_remote.tardis_owner", "Tracking Timeship: ");
        this.add("tooltip.stat_remote.exterior_dim", " Dimension: ");
        this.add("tooltip.stat_remote.exterior_pos", " Position: ");
        this.add("tooltip.stat_remote.in_flight", "In Flight: ");
        this.add("tooltip.stat_remote.journey", "Journey: ");
        this.add("tooltip.stat_remote.fuel", "Fuel: ");
        this.add("tooltip.ars_tablet.piece", "Selected ARS Piece: ");
        this.add("tooltip.ars_tablet.spawn", "Room Creation: \u00a77Right Click on an \u00a72Corridor Spawn Block");
        this.add("tooltip.ars_tablet.remove", "Room Removal: \u00a77Right Click on an \u00a7cCorridor Kill Block");
        this.add("tooltip.ars_structure.placement_offset", "Place %s block(s) above a solid block to generate ARS structures properly");
        this.add("tooltip.plasmic_shell.use1", "Right click on a block to set start position, then another block to set end position");
        this.add("tooltip.plasmic_shell.use2", "Sneak and Right click on an Atrium Frame block to create disguise json file. \nThe block below the Atrium Frame block will not be included in the json");
        this.add("tooltip.plasmic_shell.use3", "Sneak and Right click in the air to clear positions");
        this.add("tooltip.artron_battery.creative_setup", "\u00a7cRight click to gain infinite charge");
        this.add("tooltip.artron_battery.max_charge", "Max Capacity: ");
        this.add("tooltip.artron_battery.charge", "Artron: ");
        this.add("tooltip.artron_battery.discharge_multiplier", "Discharge Multiplier: ");
        this.add("tooltip.artron_battery.charge_multiplier", "Charge Multiplier: ");
        this.add("tooltip.artron_battery.howto", "Used to fuel various devices\nRecharging - in Artron Collector or Charging Panel of the Tardis Engine!");
        this.add("tooltip.vm.total_charge", "Total Charge: ");
        this.add("tooltip.vm.battery_count", "Artron Batteries: ");
        this.add("tooltip.backdoor.description", "Allows for emergency access to a linked Timeship. Attune this item, then use this on the top half of a door block to spawn an invisible portal.");
        this.add("tooltip.artron_capacitor.max_charge", "Total Capacity: ");
        this.add("tooltip.artron_capacitor.recharge_multiplier", "Recharge Multiplier: ");
        this.add("tooltip.artron_capacitor.info", "Increases Tardis Artron Bank Capacity and Refuel Rate");
        this.add("tooltip.artron_capacitor.howto", "Place in Tardis Engine (Artron Banks Panel) to allow Tardis to refuel!");
        this.add("tooltip.part.type", "Type: ");
        this.add("tooltip.part.flight.required", "Required for Flight: ");
        this.add("tooltip.part.repair.required", "Requires Repair: ");
        this.add("tooltip.part.engine_panel", "Engine Install Location: ");
        this.add("tooltip.part.dependency", "Required Dependency: ");
        this.add("tooltip.part.subsystem/dematerialisation_circuit.description", "Used for flight. \nTakes 1 damage every 5-10 seconds");
        this.add("tooltip.part.subsystem/fluid_link.description", "Used for flight with Dematerialisation Circuit. Required for refuelling. \nTakes 1 damage on takeoff and 1 on landing");
        this.add("tooltip.part.subsystem/chameleon_circuit.description", "Allows for Exterior to be changed.\nTakes 1 damage per tick and chance to take 50% more");
        this.add("tooltip.part.subsystem/interstitial_antenna.description", "Allows for detection of Distress Signals. \nTakes 1 damage per tick and 2 more if a signal is detected");
        this.add("tooltip.part.subsystem/temporal_grace.description", "Negates damage to pilot when they are hurt inside the interior. \nTakes 1 damage everytime the pilot is hurt in the interior");
        this.add("tooltip.part.subsystem/shield_generator.description", "Prevents other subsystems from taking damage when exterior is hit. \nTakes 10 damage for explosions and 4 for projectiles");
        this.add("tooltip.part.subsystem/stabilizer.description", "Allows your Tardis to switch between Stabilized and Unstabilized Flight Mode. \nTakes 1 damage every 10 seconds when being used");
        this.add("tooltip.part.subsystem/nav_com.description", "Allows your Tardis to be able to set its destination position. \nWithout it, the destination coordinates will be randomised");
        this.add("tooltip.part.blank_upgrade.description", "Template to craft other Upgrades.");
        this.add("tooltip.part.upgrades/atrium.description", "Takes blocks with the exterior. \nConsult the Tardis Manual for more information.");
        this.add("tooltip.part.upgrades/electro_convert.description", "Allows all entities within a 16 block radius around the exterior to breath underwater when exterior is submerged");
        this.add("tooltip.part.upgrades/structure.description", "Allows the Telepathic Circuits to locate valid Structures within a certain radius of the destination coordinates");
        this.add("tooltip.part.upgrades/key_fob.description", "Allows you to lock the Tardis doors using the Tardis Key from a distance");
        this.add("tooltip.part.upgrades/time_link.description", "Allows you to tow another Tardis using your own.");
        this.add("tooltip.part.upgrades/zero_room.description", "Removes Poison Effects and heals players under their max health. \nTakes 1 damage for every heart healed");
        this.add("tooltip.tape_measure.howto", "Right click two blocks to calculate the difference between them");
        this.add("tooltip.tape_measure.howto_2", "Sneak + Right Click on a Block to clear your selection");
        this.add("tooltip.tardis.watch.line1", "Tells the localtime of the dimension your exterior is in");
        this.add("tooltip.tardis.watch.line2", "May go crazy near time or spacial anomalies");
        this.add("tooltip.roundel_tap.purpose", "Allows energy to be taken from the Tardis Forge Energy Buffer");
        this.add("tooltip.roundel_tap.use", "Connect other mod cables to push/pull energy to and from the Tardis' FE Buffer");
        this.add("tooltip.item_access_panel.description_one", "Allows items to be piped throughout the Tardis via this block.");
        this.add("tooltip.item_access_panel.description_two", "Connect hoppers and similar objects to the sides of this block.");
        this.add("tooltip.tardis.mood_change", "CREATIVE ONLY: Changes the timeship's mood.");
        this.add("tooltip.waypoint_bank.desc", "Adds 5 more waypoints to the Tardis.\nWhen broken, deletes waypoints from the Tardis!");
        this.add("tooltip.gui.vm.select", "Activate Function");
        this.add("tooltip.gui.vm.close", "Close GUI");
        this.add("tooltip.gui.vm.dec_func", "Previous Function");
        this.add("tooltip.gui.vm.inc_func", "Next Function");
        this.add("tooltip.gui.vm.inc_subfunc", "Next Sub Function");
        this.add("tooltip.gui.vm.dec_subfunc", "Previous Sub Function");
        this.add("tooltip.gui.monitor_remote.update_arm_length", "Updates the Arm length for Rotating Monitor Block");
        this.add("tooltip.gui.monitor_remote.monitor_mode", "Set the View Mode of the Monitor");
        this.add("tooltip.tardis.data_crystal", "Saved Waypoint: %s");
        this.add("tooltip.tardis.data_crystal_use", "Extracts Waypoints from Waypoint Banks if crystal doesn't have waypoints. \nAdds waypoints to Waypoint Banks if this contains waypoints.");
        this.add("tooltip.tardis.data_crystal.empty", "No Waypoint Stored!");
        this.add("tooltip.tardis.waypoint_bank.bank_input", "Waypoints in Bank ");
        this.add("tooltip.tardis.waypoint_bank.crystal_output", "Waypoints in Crystal");
        this.add("tooltip.tardis.waypoint_bank.copy_from_crystal", "Copy to/Paste from Data Crystal");
        this.add("tooltip.tardis.waypoint_bank.copy_from_bank", "Copy to/Paste from Waypoint Bank");
        this.add("tooltip.tardis.waypoint_bank.delete_from_crystal", "Delete selected Waypoint in Crystal");
        this.add("tooltip.tardis.waypoint_bank.delete_from_bank", "Delete selected Waypoint in Bank");
        this.add("tooltip.sonic.parts", "Casing Types: ");
        this.add("tooltip.tardis.timelink", "Linked to: ");
        this.add("tooltip.gui.monitor_remote.set_arm_length", "Set a number");
        this.add("tooltip.tardis.transduction_barrier.line1", "Blocks Tardises from landing in a 32 block radius if their Landing Code don't match the ones stored in this block.");
        this.add("tooltip.tardis.transduction_barrier.line2", "Requires FE and Redstone to be powered.");
        this.add("tooltip.tardis.transduction_barrier.line3", "Uses FE when blocking Tardises and 1 FE per second when not in use");
        this.add("tooltip.gui.count", " (x%s)");
        this.add("tooltip.tardis.manual.next_page", "Next Page");
        this.add("tooltip.tardis.manual.previous_page", "Previous Page");
        this.add("tooltip.tardis.manual.next_chapter", "Next Chapter");
        this.add("tooltip.tardis.manual.previous_chapter", "Previous Chapter");
        this.add("tooltip.tardis.manual.last_page", "Last Page");
        this.add("tooltip.tardis.manual.first_page", "First Page");
        this.add("gui.quantiscope.mode.weld", "Fabricate");
        this.add("gui.quantiscope.mode.sonic", "Reconfig");
        this.add("gui.tardis.previous", "> Previous");
        this.add("gui.tardis.next", "> Next");
        this.add("gui.tardis.select", "> Select");
        this.add("gui.tardis.confirm", "> Confirm");
        this.add("gui.tardis.save", "> Save");
        this.add("gui.tardis.cancel", "> Cancel");
        this.add("gui.tardis.button.back", "Back");
        this.add("gui.vm.selected_func", "Selected Function:");
        this.add("gui.vm.teleport.tp_type", "Teleport Type:");
        this.add("gui.vm.teleport.setting.top", "Top Block");
        this.add("gui.vm.teleport.setting.precise", "Precise");
        this.add("gui.vm.teleport.tp", "Teleport");
        this.add("gui.vm.teleport.title", "Teleport Player");
        this.add("gui.vm.distress.title", "Distress Signal");
        this.add("gui.vm.teleport.precise_warning", "Warning! This setting may be dangerous!");
        this.add("gui.vm.distress.select_tardis", "Select Timeship:");
        this.add("gui.vm.distress.message", "Optional Message: ");
        this.add("gui.vm.distress.send_signal", "Send Signal");
        this.add("gui.vm.distress.check_name", "Check Name");
        this.add("gui.vm.distress.tardis_found", "Timeship Found!");
        this.add("gui.vm.distress.tardis_invalid", "Invalid Timeship:");
        this.add("gui.tardis.protocol.int_hum", "Interior Hum");
        this.add("gui.tardis.protocol.security", "Security Submenu");
        this.add("gui.tardis.protocol.console", "Change Console Unit");
        this.add("gui.tardis.protocol.interior", "Change Interior");
        this.add("gui.tardis.protocol.interior_properties", "Interior Properties Submenu");
        this.add("gui.tardis.protocol.interior_properties.interior_light_level", "Interior Light Level");
        this.add("gui.tardis.protocol.interior_properties.interior_light_level.slider", "Interior Light Level");
        this.add("gui.tardis.protocol.interior_properties.hum", "Interior Hum");
        this.add("gui.tardis.protocol.interior_properties.console_variant", "> Console Variant: ");
        this.add("gui.tardis.protocol.interior_properties.sound_scheme", "> Flight Sound Scheme");
        this.add("gui.tardis.protocol.exterior", "Change Exterior");
        this.add("gui.tardis.protocol.waypoints", "Waypoint Screen");
        this.add("gui.tardis.protocol.exterior_properties", "Exterior Properties");
        this.add("gui.tardis.protocol.exterior_properties.land_code", "> Set Landing Code");
        this.add("gui.tardis.protocol.exterior_properties.exterior_var", "> Exterior Variant: ");
        this.add("gui.tardis.protocol.info", "Timeship Flight Information");
        this.add("gui.tardis.info.title", "Timeship Flight Information");
        this.add("gui.tardis.info.location", "Location: ");
        this.add("gui.tardis.info.dimension", "Dimension: ");
        this.add("gui.tardis.info.facing", "Facing: ");
        this.add("gui.tardis.info.target_location", "Target: ");
        this.add("gui.tardis.info.target_dimension", "Target Dim: ");
        this.add("gui.tardis.info.artron", "Artron Units: ");
        this.add("gui.tardis.info.journey", "Journey: ");
        this.add("gui.tardis.info.unknown", "UNKNOWN");
        this.add("gui.tardis.interior.change.warning_message", "Any existing bed positons, paintings and placed blocks in the Tardis will be removed!\nWaypoints will be saved inside a Data Crystal Item inside the Reclamation Unit.\nAny blocks in the 'reclamation_blacklist' Block Tag will NOT have their contents saved.");
        this.add("gui.tardis.interior.change.confirm_message", "Are you sure you wish to change interiors?");
        this.add("gui.tardis.interior.change_cancel.warning_message", "The Interior Reconfiguration Process will be cancelled.");
        this.add("gui.tardis.interior.cancel_confirm.confirm_message", "Are you sure you wish to continue with the cancellation?");
        this.add("gui.tardis.sound_scheme.title", "Sound Scheme Selection");
        this.add("gui.tardis.sound_scheme.desc", "Set Flight sounds for this Timeship");
        this.add("gui.tardis.sound_scheme.tv", "TV");
        this.add("gui.tardis.sound_scheme.basic", "Default");
        this.add("gui.tardis.sound_scheme.master", "Master");
        this.add("gui.tardis.sound_scheme.junk", "Junk");
        this.add("gui.tardis.waypoint.title", "Waypoints");
        this.add("gui.tardis.waypoint.name", "Waypoint Name: ");
        this.add("gui.tardis.waypoint.waypoint_bank_position", "Waypoint Bank Position: ");
        this.add("gui.tardis.waypoint.delete", "Delete Current Waypoint");
        this.add("gui.tardis.waypoint.new", "Create New Waypoint");
        this.add("gui.tardis.distress_signal.message_desc", "Enter Distress Message:");
        this.add("gui.tardis.distress_signal.select_ship", "Send signal to:");
        this.add("gui.tardis.ars_tablet.gui_title", "ARS Structure Selection");
        this.add("gui.tardis.ars_tablet.gui_info", "Select Structure Type to Generate:");
        this.add("gui.tardis.ars_tablet.kill.title", "Please confirm room deletion");
        this.add("gui.tardis.ars_tablet.kill.confirm", "> Confirm");
        this.add("gui.tardis.ars_tablet.kill.close", "> Close");
        this.add("gui.tardis.land_code.title", "Timeship Landing Codes");
        this.add("gui.tardis.land_code.desc", "Set Private Landing Code: ");
        this.add("gui.tardis.land_code.set", "> Set Code");
        this.add("gui.tardis.land_code.suggestion.default", "Enter Land Code:");
        this.add("gui.tardis.land_code.suggestion.current_value", "Current Code: ");
        this.add("gui.tardis.waypoint.new.title", "Waypoint Creation");
        this.add("gui.tardis.waypoint.new.desc", "Set New Waypoint Name: ");
        this.add("gui.tardis.waypoint.new.suggestion", "Enter Waypoint Name");
        this.add("gui.tardis.waypoint.no_banks", "No Waypoint Banks Found!");
        this.add("gui.tardis.waypoint.no_saved", "No Saved Waypoints!");
        this.add("gui.tardis.waypoint.delete.confirm_title", "Confirm Waypoint Delete");
        this.add("gui.tardis.waypoint.delete.confirm_message", "Are you sure you wish to delete this waypoint?");
        this.add("gui.tardis.communicator.load", "> Load in Nav-Com");
        this.add("gui.tardis.communicator.ignore", "> Ignore");
        this.add("gui.tardis.communicator.ignore_all", "> Ignore All");
        this.add("gui.tardis.communicator.message_title", "Distress Signal Detected!");
        this.add("gui.tardis.communicator.message_subtitle", "Message Contents:");
        this.add("gui.tardis.remote.view.north_west", "NW");
        this.add("gui.tardis.remote.view.south_east", "SE");
        this.add("gui.tardis.remote.view.orbit", "Orbit");
        this.add("gui.tardis.transduction.title", "Transduction Barrier");
        this.add("gui.tardis.transduction.land_code.update", "Update Land Code");
        this.add("gui.tardis.transduction.land_code.desc", "Set Private Landing Code:");
        this.add("gui.tardis.transduction.land_code.suggestion", "Enter Landing Code");
        this.add("gui.tardis.diagnostic.menu.artron_use", " > Artron Uses");
        this.add("gui.tardis.diagnostic.artron_use", "Artron Uses:");
        this.add("gui.tardis.diagnostic.menu.subsystem", " > Subsystems");
        this.add("gui.tardis.diagnostic.menu.location", " > Timeship Location");
        this.add("gui.tardis.diagnostic.title.location", "Timeship Location");
        this.add("gui.tardis.diagnostic.location", "Located at: %s in %s");
        this.add("gui.tardis.diagnostic.menu.forge_energy", " > Forge Energy");
        this.add("gui.tardis.diagnostic.title.forge_energy", "Forge Energy Buffer");
        this.add("gui.tardis.diagnostic.forge_energy", "%s/%s FE");
        this.add("gui.tardis.monitor_remote.scanner_title", "Scanner View Mode");
        this.add("gui.tardis.monitor_remote.arm_length_title", "Rotatable Monitor Arm Extension Length");
        this.add("gui.tardis.monitor_remote.arm_length_button", "Update Arm Length");
        this.add("gui.tardis.telepathic.title", "Telepathic Circuits");
        this.add("gui.tardis.telepathic.search_suggestion", "Search...");
        this.add("text.tardis.plaque.line1", "TT Type 40, MK. III");
        this.add("text.tardis.plaque.line2", "Kasterborous Blackhole Shipyards");
        this.add("text.tardis.plaque.line3", "Designation: %s");
        this.add("text.tardis.transduction.line1", "");
        this.add("text.tardis.transduction.line2", "WARNING:");
        this.add("text.tardis.transduction.line3", "Redirection device detected!");
        this.add("text.tardis.fall_below_world.line1", "");
        this.add("text.tardis.fall_below_world.line2", "WARNING: ");
        this.add("text.tardis.fall_below_world.line3", "Exterior has fallen below world threshold, redirecting!");
        this.add("overlay.tardis.system_title", "==-Timeship Systems Readout-==");
        this.add("overlay.tardis.fe_power", "Timeship Forge Energy: %s FE");
        this.add("advancements.tardis.title.tardis_mod", "New TARDIS Mod");
        this.add("advancements.tardis.desc.tardis_mod", "An Adventure in Space and Time!");
        this.add("advancements.tardis.title.obtained_tardis", "11D Euclidean Geometry");
        this.add("advancements.tardis.desc.obtained_tardis", "Find and access a broken down TARDIS!");
        this.add("advancements.tardis.title.vortex", "Forward to the Past...");
        this.add("advancements.tardis.desc.vortex", "Travel through the Time Vortex!");
        this.add("advancements.tardis.title.moon", "One Small Step...");
        this.add("advancements.tardis.desc.moon", "Step on the Moon");
        this.add("advancements.tardis.title.space", "The Final Frontier...");
        this.add("advancements.tardis.desc.space", "Enter the endless Space.");
        this.add("advancements.tardis.title.space_suit", "Spaaaaace!");
        this.add("advancements.tardis.desc.space_suit", "Obtain a Spacesuit!");
        this.add("advancements.tardis.title.mission.drone_station.complete", "Timely Rescue!");
        this.add("advancements.tardis.desc.mission.drone_station.complete", "Rescue a space station crew from rogue drones!");
        this.add("command.tardis.setup.success", "Successfully setup Tardis Components, Artron and Key for tardis \u00a7d%s");
        this.add("command.tardis.unlock.exterior_all", "Unlocked All Exteriors for tardis %s");
        this.add("command.tardis.unlock.exterior", "Unlocked Exterior %s for tardis %s");
        this.add("command.tardis.unlock.interior_all", "Unlocked All Interiors for tardis %s");
        this.add("command.tardis.unlock.interior", "Unlocked Interior %s for tardis %s");
        this.add("command.tardis.unlock.console", "Unlocked Console %s for tardis %s");
        this.add("command.tardis.unlock.console_all", "Unlocked All Consoles for tardis %s");
        this.add("command.tardis.name.matching_dim.success", "Matched Dimension: %s");
        this.add("command.tardis.name.matching_name.success", "Matched Name: %s");
        this.add("command.tardis.name.matching_name.fail", "Could not find any matching names for %s");
        this.add("command.tardis.name.matching_dim.fail", "Could not find any matching dimension IDs for %s");
        this.add("command.tardis.loyalty.success", "%s's loyalty to player %s has been updated to %s");
        this.add("command.tardis.loyalty.no_player_found", "Player %s has not interacted with this Tardis");
        this.add("command.tardis.loyalty.check", "Loyalties found for Tardis %s\n%s");
        this.add("command.tardis.refuel.check", "Fuel Values for Tardis %s: \nCurrent Fuel: %s\nMax Capacity: %s\n\nArtron Uses: \n%s");
        this.add("command.tardis.refuel.success", "Set fuel for Tardis %s to: %s AU");
        this.add("command.tardis.artron.check", "Artron value: %s");
        this.add("command.tardis.artron.add", "Requested adding %s charge, %s Artron charge added, value is now %s.");
        this.add("command.tardis.artron.invalid_item", "Error: Item %s is not a valid Artron Battery!");
        this.add("command.tardis.traits.check", "Traits found on %s\n%s");
        this.add("command.tardis.traits.regenerate", "Traits regenerated on %s\nNew Traits: \n%s");
        this.add("command.tardis.attune.success", "Attuned Item %s to tardis: \n%s");
        this.add("command.tardis.attune.invalid", "Error: Item %s is not attunable");
        this.add("command.tardis.interior.success", "Teleported %s to interior of tardis %s");
        this.add("command.tardis.mission.spawn.success", "Succesfully spawned MissionType: %s at %s");
        this.add("command.tardis.mission.spawn.fail", "Failed to spawn MissionType: %s at %s");
        this.add("command.tardis.mission.objective_update.success", "Successfully set objective for stage %s of mission %s at %s to %s");
        this.add("command.tardis.mission.stage_update.success", "Successfully set stage of mission %s at %s to %s");
        this.add("command.tardis.mission.objective_get.success", "Mission %s at %s is currently at Objective %s for stage %s");
        this.add("command.tardis.mission.stage_get.success", "Mission %s at %s is currently at Stage %s");
        this.add("command.tardis.mission.no_mission_found_at_pos", "No Mission found at %s");
        this.add("command.tardis.mission.no_stage_found_for_mission", "Error: No Stage found for Mission %s at %s");
        this.add("command.tardis.mission.invalid_mission", "Error: MissionType not found!");
        this.add("command.tardis.mission.invalid_mission_world", "World %s does not support spawning of missions!");
        this.add("command.tardis.disguise.spawn.success", "Successfully placed blocks of Disguise %s at %s");
        this.add("command.tardis.disguise.invalid_disguise", "Error: Disguise not found, or the Disguise blocks are empty");
        this.add("command.tardis.rift.find.success", "Found Rifts within %s chunks from %s: \n%s");
        this.add("command.tardis.rift.find.error", "Could not find Rift at %s");
        this.add("command.tardis.rift.get_energy.success", "Rift at %s has %s AU");
        this.add("command.tardis.rift.add_energy.success", "Added %s AU to Rift at %s. Rift now has %s AU");
        this.add("command.tardis.rift.create_rift.success", "Created Rift with %s AU at %s");
        this.add("command.tardis.rift.remove_rift.success", "Removed Rift of %s AU at %s");
        this.add("command.tardis.create.success", "Created Tardis %s of Exterior %s, Console Room %s, Console Unit %s");
        this.add("command.suggestion.tardis.no_connections", "Error_No_Connections_to_Any_Tardises");
        this.add("command.suggestion.tardis.no_connections_tooltip", "This player has not interacted with any Tardises");
        this.add("argument.tardis.console_room.invalid", "Invalid Console Room: %s");
        this.add("argument.tardis.exterior.invalid", "Invalid Exterior: %s");
        this.add("argument.tardis.console_unit.invalid", "Invalid Console Unit: %s");
        this.add("argument.tardis.mission_type.invalid", "Invalid Mission Type: %s");
        this.add("argument.tardis.disguise.invalid", "Invalid Disguise: %s");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.ALARM_LOW.get()), "Tardis Cloister Bell");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.AMBIENT_CREAKS.get()), "Tardis creaks");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.BESSIE_DRIVE.get()), "Vrooom");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.BESSIE_HORN.get()), "Honk");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.CANT_START.get()), "Tardis Struggles to Start");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.CAR_LOCK.get()), "Beep Beep");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.COMMUNICATOR_BEEP.get()), "Incoming Transmission");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.COMMUNICATOR_PHONE_PICKUP.get()), "Telephone Rings");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.COMMUNICATOR_RING.get()), "Telephone Rings");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.COMMUNICATOR_STEAM.get()), "Transmission Static");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DIMENSION.get()), "Destination Dimension Changed");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DIRECTION.get()), "Tardis Door Facing Modified");
        this.add("subtitle.tardis.generic_control", "Controls beep");
        this.add("subtitle.tardis.control_landing_type", "Landing Type Modified");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.REFUEL_START.get()), "Refuelling Started");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.REFUEL_STOP.get()), "Refuelling Stopped");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.STABILIZER_OFF.get()), "Stabilizers Deactivated");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.STABILIZER_ON.get()), "Stabilizers Activated");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DALEK_ARM.get()), "Dalek arm rotates");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DALEK_DEATH.get()), "Argghrgwwrhg");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DALEK_EXTERMINATE.get()), "Exterminate!");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DALEK_FIRE.get()), "Energy beam fires");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DALEK_HOVER.get()), "Gravity Projectors Hum");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DALEK_MOVES.get()), "Mechanical Whirring");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DALEK_SW_AIM.get()), "Servo rotates");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DALEK_SW_FIRE.get()), "Energy bolt discharges");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DALEK_SW_HIT_EXPLODE.get()), "Explosion");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DOOR_CLOSE.get()), "Tardis Door closes");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DOOR_KNOCK.get()), "Knock Knock Knock Knock Knock");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DOOR_LOCK.get()), "Tardis Door locked");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DOOR_OPEN.get()), "Tardis Door opens");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.DOOR_UNLOCK.get()), "Tardis Door unlocked");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.ELECTRIC_ARC.get()), "Electricity Arcs");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.ELECTRIC_SPARK.get()), "Circuits Spark");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.EYE_MONITOR_INTERACT.get()), "Monitor activates");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.GADGET_MENU_OPEN.get()), "Gadget Interface Opens");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.HANDBRAKE_ENGAGE.get()), "Handbrake engaged");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.HANDBRAKE_RELEASE.get()), "Handbrake released");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.LASER_GUN_FIRE.get()), "Pew");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.PAPER_DROP.get()), "Paper scatters");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.POWER_DOWN.get()), "Tardis powers down");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.RANDOMISER.get()), "Randomiser wobbles");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.REACHED_DESTINATION.get()), "Tardis Landed");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.REMOTE_ACCEPT.get()), "Device Beeps");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.ROTOR_END.get()), "Time Rotor Shutting Down");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.ROTOR_START.get()), "Time Rotor Starts");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.ROTOR_TICK.get()), "Time Rotor Ticks");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SCREEN_BEEP_SINGLE.get()), "Buttons Beep");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SHIELD_HUM.get()), "Shield Projectors Hum");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SINGLE_CLOISTER.get()), "Tardis Cloister Bell");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SNAP.get()), "Fingers Snap");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SONIC_BROKEN.get()), "Sonic Screwdriver destroyed");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SONIC_FAIL.get()), "Sonic Screwdriver Activation Fail");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SONIC_GENERIC.get()), "Sonic Screwdriver Buzzes");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SONIC_MODE_CHANGE.get()), "Sonic Screwdriver Mode Change");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SONIC_TUNING.get()), "Sonic Screwdriver Tuning");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SPACE_AMBIENT_LOOP.get()), "Space Ambience");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.STEAM_HISS.get()), "Steam Hiss");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.STEAMPUNK_MONITOR_INTERACT.get()), "Monitor Activated");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SUBSYSTEMS_OFF.get()), "Subsystem Deactivated");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.SUBSYSTEMS_ON.get()), "Subsystem Activated");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.TARDIS_FLY_LOOP.get()), "Vworp");
        this.add("subtitle.tardis.tardis_hum", "Tardis Hums");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.TARDIS_LAND.get()), "Tardis Rematerialises");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.TARDIS_LAND_NOTIFICATION.get()), "Tardis Landing Notification");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.TARDIS_POWER_UP.get()), "Tardis Powers Up");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.TARDIS_TAKEOFF.get()), "Tardis Dematerialising");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.TELEPATHIC_CIRCUIT.get()), "Telepathic Circuits Pulse");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.TARDIS_FIRST_ENTRANCE.get()), "Timeship Welcome");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.TARDIS_SHUT_DOWN.get()), "Tardis Shuts Down");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.THROTTLE.get()), "Throttle clicks");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.VM_BUTTON.get()), "Beep");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.VM_TELEPORT.get()), "Vortex Manipulator Teleportation");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.VORTEX_AMBIENT_LOOP.get()), "Vortex Ambience");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.WATCH_MALFUNCTION.get()), "Watch Malfunctions");
        this.add(this.getSoundTranslationKey((SoundEvent)TSounds.WATCH_TICK.get()), "Tick Tick");
        this.add("biome.tardis.tardis", "TARDIS Biome");
        this.add("keys.tardis.main", "TARDIS Mod");
        this.add("key.tardis.snap", "Tardis Door Snap");
        this.add("key.tardis.reload_laser_gun", "Reload Laser Gun");
        this.add("stat.tardis.subsystems_broken", "Tardis Subsystems Broken");
        this.add("stat.tardis.tardis_distance_travelled", "Distance Travelled in Tardis");
        this.add("stat.tardis.tardis_crash_count", "Tardis Crash Landings");
        this.add("stat.tardis.flight_events_completed", "Flight Hazards Avoided");
        this.add("stat.tardis.vortex_travel_count", "Time Vortex Travel Count");
        this.add("stat.tardis.missions_completed", "Mini Missions Completed");
        this.add("compat.tardis.jei.alembic_title", "Alembic");
        this.add("compat.tardis.jei.quantiscope_title", "Quantiscope Welding");
        this.add("compat.tardis.jei.spectrometer_title", "Spectrometer");
        this.add("compat.tardis.jei.ars_title", "ARS System");
        this.add("compat.tardis.jei.attunement_title", "Attunable");
    }

    public Path getSoundPath(Path path, String modid) {
        return path.resolve("data/" + modid + "/sounds/sounds.json");
    }

    public String fixCapitalisations(String text) {
        String original = text.trim().replace("    ", "").replace("_", " ").replace("/", ".");
        String output = Arrays.stream(original.split("\\s+")).map(t -> t.substring(0, 1).toUpperCase() + t.substring(1)).collect(Collectors.joining(" "));
        return output;
    }

    public String getControlTranslationKeyFromEntry(ControlRegistry.ControlEntry entry) {
        ResourceLocation loc = entry.getRegistryName();
        return "control." + loc.func_110624_b() + "." + loc.func_110623_a();
    }

    public String getSoundTranslationKey(SoundEvent sound) {
        String subtitleTranslationKey = "";
        if (subtitleTranslationKey.isEmpty() || subtitleTranslationKey == null) {
            subtitleTranslationKey = Util.func_200697_a((String)"subtitle", (ResourceLocation)sound.getRegistryName());
        }
        return subtitleTranslationKey;
    }
}

