/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.mod.datagen.BaseDataProvider;
import net.tardis.mod.datagen.DataGen;
import net.tardis.mod.tags.TardisItemTags;

public class TardisItemTagGen
extends BaseDataProvider {
    public Map<ResourceLocation, List<ResourceLocation>> tags = Maps.newHashMap();

    public TardisItemTagGen(DataGenerator gen) {
        super(gen);
    }

    public void registerTags() {
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196858_iR.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196850_iN.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196852_iO.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196846_iL.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196842_iJ.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196854_iP.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196834_iF.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196844_iK.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196838_iH.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196832_iE.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196830_iD.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196840_iI.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196848_iM.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196856_iQ.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196828_iC.getRegistryName());
        this.addToTag(TardisItemTags.CONCRETE.func_230234_a_(), Blocks.field_196836_iG.getRegistryName());
        this.addToTag(TardisItemTags.CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_203964_jF);
        this.addToTag(TardisItemTags.CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_204744_jS);
        this.addToTag(TardisItemTags.CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_203965_jG);
        this.addToTag(TardisItemTags.CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_204745_jT);
        this.addToTag(TardisItemTags.CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_203966_jH);
        this.addToTag(TardisItemTags.CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_204746_jU);
        this.addToTag(TardisItemTags.CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_203967_jI);
        this.addToTag(TardisItemTags.CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_204747_jV);
        this.addToTag(TardisItemTags.CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_203963_jE);
        this.addToTag(TardisItemTags.CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_204743_jR);
        this.addToTag(TardisItemTags.DEAD_CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_204405_jF);
        this.addToTag(TardisItemTags.DEAD_CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_211902_kq);
        this.addToTag(TardisItemTags.DEAD_CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_204406_jG);
        this.addToTag(TardisItemTags.DEAD_CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_211903_kr);
        this.addToTag(TardisItemTags.DEAD_CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_204407_jH);
        this.addToTag(TardisItemTags.DEAD_CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_211904_ks);
        this.addToTag(TardisItemTags.DEAD_CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_204408_jI);
        this.addToTag(TardisItemTags.DEAD_CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_211905_kt);
        this.addToTag(TardisItemTags.DEAD_CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_204404_jE);
        this.addToTag(TardisItemTags.DEAD_CORAL.func_230234_a_(), (ForgeRegistryEntry<?>)Blocks.field_211901_kp);
    }

    @Override
    public void act(DirectoryCache cache, Path base) throws IOException {
        this.tags.clear();
        this.registerTags();
        for (Map.Entry<ResourceLocation, List<ResourceLocation>> tag : this.tags.entrySet()) {
            this.generateTag(base, cache, tag.getKey(), tag.getValue());
        }
    }

    public void addToTag(ResourceLocation tag, ResourceLocation item) {
        if (!this.tags.containsKey(tag)) {
            this.tags.put(tag, new ArrayList());
        }
        this.tags.get(tag).add(item);
    }

    public void addToTag(ResourceLocation tag, ForgeRegistryEntry<?> entry) {
        this.addToTag(tag, entry.getRegistryName());
    }

    public void generateTag(Path path, DirectoryCache cache, ResourceLocation name, List<ResourceLocation> items) {
        this.generateTable(cache, this.getPath(path, name), () -> this.serialize(items));
    }

    public void generateTable(DirectoryCache cache, Path path, Supplier<JsonElement> element) {
        try {
            IDataProvider.func_218426_a((Gson)DataGen.GSON, (DirectoryCache)cache, (JsonElement)element.get(), (Path)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Path getPath(Path base, ResourceLocation path) {
        return base.resolve("data/" + path.func_110624_b() + "/tags/items/" + path.func_110623_a() + ".json");
    }

    public JsonElement serialize(List<ResourceLocation> items) {
        JsonObject root = new JsonObject();
        root.add("replace", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        JsonArray itemBlock = new JsonArray();
        for (ResourceLocation s : items) {
            itemBlock.add(s.toString());
        }
        root.add("values", (JsonElement)itemBlock);
        return root;
    }

    @Override
    public String func_200397_b() {
        return "TARDIS Item Tag Gen";
    }
}

