/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraftforge.registries.ForgeRegistries;
import net.tardis.mod.ars.IARS;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.datagen.TardisItemTagGen;
import net.tardis.mod.helper.Helper;

public class TardisARSTagGen
extends TardisItemTagGen {
    protected List<Block> otherTaggedBlocks = new ArrayList<Block>();

    public TardisARSTagGen(DataGenerator gen) {
        super(gen);
    }

    @Override
    public void registerTags() {
    }

    @Override
    public void act(DirectoryCache cache, Path path) throws IOException {
        ArrayList items = Lists.newArrayList();
        this.populateOtherTaggedList();
        for (Block blockEntry : ForgeRegistries.BLOCKS) {
            if (!(blockEntry instanceof IARS) && !this.otherTaggedBlocks.contains(blockEntry)) continue;
            items.add(blockEntry.getRegistryName());
        }
        this.generateTable(cache, this.getPath(path, Helper.createRL("ars")), () -> this.serialize(items));
    }

    protected void populateOtherTaggedList() {
        this.otherTaggedBlocks.add((Block)TBlocks.blinking_lights.get());
        this.otherTaggedBlocks.add((Block)TBlocks.steam_grate.get());
        this.otherTaggedBlocks.add((Block)TBlocks.alabaster_bookshelf.get());
        this.otherTaggedBlocks.add((Block)TBlocks.ebony_bookshelf.get());
        this.otherTaggedBlocks.add((Block)TBlocks.blue_pillar.get());
        this.otherTaggedBlocks.add((Block)TBlocks.foam_pipes.get());
        this.otherTaggedBlocks.add((Block)TBlocks.alabaster.get());
        this.otherTaggedBlocks.add((Block)TBlocks.alabaster_wall.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_pattern.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_pattern_slab.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_pattern_stairs.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_plate.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_plate_small.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_plate_slab.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_plate_stairs.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_pipes.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_pipes_slab.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_pipes_stairs.get());
        this.otherTaggedBlocks.add((Block)TBlocks.tungsten_screen.get());
    }

    @Override
    public String func_200397_b() {
        return "TARDIS ARS Item Tag";
    }
}

