/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.recipe.SpectrometerRecipe;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.Schematics;
import net.tardis.mod.tags.TardisItemTags;

public class SpectrometerRecipeGen
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public SpectrometerRecipeGen(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        if (ConsoleRoom.getRegistry().isEmpty()) {
            ConsoleRoom.registerCoreConsoleRooms();
        }
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221879_fX}), () -> Schematics.Consoles.NEMO);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221738_ce}), () -> Schematics.Consoles.STEAM);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}), () -> Schematics.Consoles.GALVANIC);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199805_a(TardisItemTags.DEAD_CORAL), () -> Schematics.Consoles.CORAL);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TBlocks.xion_crystal.get()}), () -> Schematics.Consoles.XION);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151061_bv}), () -> Schematics.Consoles.NEUTRON);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151068_bn}), () -> Schematics.Consoles.POLYMEDICAL);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151065_br}), () -> Schematics.Exteriors.STEAMPUNK);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221675_bZ}), () -> Schematics.Exteriors.TRUNK);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222109_pP}), () -> Schematics.Exteriors.TELEPHONE);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222089_ms}), () -> Schematics.Exteriors.FORTUNE);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222013_iM}), () -> Schematics.Exteriors.SAFE);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151113_aN}), () -> Schematics.Exteriors.CLOCK);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222068_kQ}), () -> Schematics.Exteriors.BOKKUSU);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150382_bo}), () -> Schematics.Exteriors.APERTURE);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222102_pI}), () -> Schematics.Interiors.STEAM);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221558_K}), () -> Schematics.Interiors.JADE);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_205157_eZ}), () -> Schematics.Interiors.NAUTILUS);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221868_er}), () -> Schematics.Interiors.OMEGA);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221578_f}), () -> Schematics.Interiors.ALABASTER);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199805_a(TardisItemTags.CONCRETE), () -> Schematics.Interiors.ARCHITECT);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199805_a(TardisItemTags.CORAL), () -> Schematics.Interiors.CORAL);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199805_a((ITag)ItemTags.field_202902_o), () -> Schematics.Interiors.PANAMAX);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151021_T}), () -> Schematics.Interiors.TRAVELER);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151166_bC}), () -> Schematics.Interiors.ENVOY);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221665_bU}), () -> Schematics.Interiors.AMETHYST);
        this.createSpectrometerRecipe(path, cache, 200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_234781_rE_}), () -> Schematics.Interiors.IMPERIAL);
    }

    public String func_200397_b() {
        return "TARDIS Spectrometer Recipe Generator";
    }

    public void createSpectrometerRecipe(Path path, DirectoryCache cache, int progressTicks, Ingredient ingredient, Supplier<Schematic> output) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createRecipe(progressTicks, ingredient, output.get()), (Path)SpectrometerRecipeGen.getPath(path, output.get()));
    }

    public void createSpectrometerRecipe(Path path, DirectoryCache cache, Item item, Supplier<Schematic> output) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createRecipe(200, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), output.get()), (Path)SpectrometerRecipeGen.getPath(path, output.get()));
    }

    public static Path getPath(Path path, Schematic output) {
        ResourceLocation key = output.getId();
        return path.resolve("data/" + key.func_110624_b() + "/recipes/spectrometer/" + key.func_110623_a() + ".json");
    }

    public JsonObject createRecipe(int processTicks, Ingredient ingredient, Schematic output) {
        SpectrometerRecipe recipe = new SpectrometerRecipe(processTicks, ingredient, output.getId());
        JsonObject recipeJson = recipe.serialise();
        return recipeJson;
    }
}

