/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.Tardis;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.blocks.XionCrystalBlock;
import net.tardis.mod.items.TItems;
import net.tardis.mod.recipe.TardisRecipeSerialisers;
import net.tardis.mod.recipe.WeldRecipe;

public class QuantiscopeRecipeGen
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public QuantiscopeRecipeGen(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        this.createNormalRecipe(path, cache, (Item)TItems.CHAMELEON_CIRCUIT.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222078_li}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222079_lj}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222083_lx})}));
        this.createRepairRecipe(path, cache, (Item)TItems.CHAMELEON_CIRCUIT.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151079_bi})}));
        this.createNormalRecipe(path, cache, (Item)TItems.DEMAT_CIRCUIT.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151079_bi}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221650_am}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()})}));
        this.createRepairRecipe(path, cache, (Item)TItems.DEMAT_CIRCUIT.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151079_bi})}));
        this.createNormalRecipe(path, cache, (Item)TItems.FLUID_LINK.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.MERCURY_BOTTLE.get()})}));
        this.createRepairRecipe(path, cache, (Item)TItems.FLUID_LINK.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.MERCURY_BOTTLE.get()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.INTERSTITIAL_ANTENNA.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221792_df}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221858_em})}));
        this.createRepairRecipe(path, cache, (Item)TItems.INTERSTITIAL_ANTENNA.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.NAV_COM.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151113_aN}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151111_aL}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151061_bv}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()})}));
        this.createRepairRecipe(path, cache, (Item)TItems.NAV_COM.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.SHEILD_GENERATOR.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151045_i}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151043_k}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222029_iU}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()})}));
        this.createRepairRecipe(path, cache, (Item)TItems.SHEILD_GENERATOR.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151043_k}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221858_em})}));
        this.createNormalRecipe(path, cache, (Item)TItems.STABILIZERS.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221655_bP}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221698_bk}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221698_bk}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221655_bP})}));
        this.createRepairRecipe(path, cache, (Item)TItems.STABILIZERS.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151111_aL}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.TEMPORAL_GRACE.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185159_cQ}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151153_ao}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221858_em})}));
        this.createRepairRecipe(path, cache, (Item)TItems.TEMPORAL_GRACE.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151074_bl})}));
        this.createNormalRecipe(path, cache, (Item)TItems.ATRIUM_UPGRADE.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.BLANK_UPGRADE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151079_bi}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151043_k})}));
        this.createNormalRecipe(path, cache, (Item)TItems.ELECTRO_CONVERT_UPGRADE.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.BLANK_UPGRADE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179563_cD}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151133_ar})}));
        this.createNormalRecipe(path, cache, (Item)TItems.KEY_FOB_UPGRADE.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.BLANK_UPGRADE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222013_iM}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221737_dE}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151043_k})}));
        this.createNormalRecipe(path, cache, (Item)TItems.TIME_LINK_UPGRADE.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.BLANK_UPGRADE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151061_bv}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.ZERO_ROOM_UPGRADE.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.BLANK_UPGRADE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151073_bk}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151072_bj}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()})}));
        this.createNormalRecipe(path, cache, ((Block)TBlocks.ars_egg.get()).func_199767_j(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151110_aK}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.ARS_TABLET.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221650_am}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((Block)TBlocks.ars_egg.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221805_eM})}));
        this.createNormalRecipe(path, cache, (Item)TItems.ARTRON_BATTERY.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221650_am}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.ARTRON_BATTERY_MED.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221858_em}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221650_am}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.ARTRON_BATTERY_HIGH.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.ARTRON_BATTERY_MED.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221650_am}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.ARTRON_CAPACITOR.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.MERCURY_BOTTLE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151043_k}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221858_em}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.MERCURY_BOTTLE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151043_k})}));
        this.createNormalRecipe(path, cache, (Item)TItems.ARTRON_CAPACITOR_MEDIUM.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.MERCURY_BOTTLE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221858_em}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.ARTRON_CAPACITOR.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151065_br}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151065_br})}));
        this.createNormalRecipe(path, cache, (Item)TItems.ARTRON_CAPACITOR_HIGH.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151045_i}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.ARTRON_CAPACITOR_MEDIUM.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.MERCURY_BOTTLE.get()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.CIRCUITS.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUIT_PASTE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151074_bl}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151074_bl}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.DATA_CRYSTAL.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151074_bl}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151074_bl}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.MONITOR_REMOTE.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221766_cs}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221766_cs}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j})}));
        this.createNormalRecipe(path, cache, (Item)TItems.POCKET_WATCH.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151113_aN})}));
        this.createNormalRecipe(path, cache, ((Block)TBlocks.roundel_tap.get()).func_199767_j(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.ARTRON_CAPACITOR.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221650_am}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax})}));
        this.createNormalRecipe(path, cache, (Item)TItems.SONIC_ACTIVATOR.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221766_cs})}));
        this.createNormalRecipe(path, cache, (Item)TItems.SONIC_EMITTER.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da})}));
        this.createNormalRecipe(path, cache, (Item)TItems.SONIC_EMITTER.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da})}));
        this.createNormalRecipe(path, cache, (Item)TItems.SONIC_HANDLE.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_191525_da})}));
        this.createNormalRecipe(path, cache, (Item)TItems.SONIC.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.SONIC_EMITTER.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.SONIC_ACTIVATOR.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.SONIC_HANDLE.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.SONIC_END.get()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.DIAGNOSTIC_TOOL.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.ARTRON_BATTERY.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((XionCrystalBlock)TBlocks.xion_crystal.get()).func_199767_j()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221650_am}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()})}));
        this.createNormalRecipe(path, cache, (Item)TItems.TARDIS_BACKDOOR.get(), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.INT_DOOR.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151074_bl}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TItems.CIRCUITS.get()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151079_bi})}));
    }

    public String func_200397_b() {
        return "TARDIS Quantiscope Recipe Generator";
    }

    public static Path getPath(Path base, Item output) {
        ResourceLocation key = output.getRegistryName();
        return base.resolve("data/" + key.func_110624_b() + "/recipes/quantiscope/" + key.func_110623_a() + ".json");
    }

    public static Path getPathRepair(Path base, Item output) {
        ResourceLocation key = output.getRegistryName();
        return base.resolve("data/" + key.func_110624_b() + "/recipes/quantiscope/" + key.func_110623_a() + "_repair.json");
    }

    public void createNormalRecipe(Path base, DirectoryCache cache, Item output, List<Ingredient> ingredients) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createRecipe(output, ingredients), (Path)QuantiscopeRecipeGen.getPath(base, output));
    }

    public void createNormalRecipe(Path base, DirectoryCache cache, Item output, List<Ingredient> ingredients, int progressTicks) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createRecipeWithProcessTicks(output, ingredients, progressTicks), (Path)QuantiscopeRecipeGen.getPath(base, output));
    }

    public void createRepairRecipe(Path base, DirectoryCache cache, Item itemToRepair, List<Ingredient> repairItems) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createRepairRecipe(itemToRepair, repairItems), (Path)QuantiscopeRecipeGen.getPathRepair(base, itemToRepair));
    }

    public JsonObject createRecipe(Item output, List<Ingredient> ingredients) {
        WeldRecipe recipe = new WeldRecipe(false, Optional.empty(), ingredients, Optional.of(new WeldRecipe.RecipeResult(output)));
        return ((JsonElement)WeldRecipe.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).get().ifLeft(element -> {
            JsonObject json = element.getAsJsonObject();
            json.addProperty("type", TardisRecipeSerialisers.WELD_RECIPE_TYPE_LOC.toString());
        }).ifRight(right -> Tardis.LOGGER.error(right.message())).orThrow()).getAsJsonObject();
    }

    public JsonObject createRecipeWithProcessTicks(Item output, List<Ingredient> ingredients, int progressTicks) {
        WeldRecipe recipe = new WeldRecipe(false, Optional.empty(), Optional.of(progressTicks), ingredients, Optional.of(new WeldRecipe.RecipeResult(output)));
        return ((JsonElement)WeldRecipe.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).get().ifLeft(element -> {
            JsonObject json = element.getAsJsonObject();
            json.addProperty("type", TardisRecipeSerialisers.WELD_RECIPE_TYPE_LOC.toString());
        }).ifRight(right -> Tardis.LOGGER.error(right.message())).orThrow()).getAsJsonObject();
    }

    public JsonObject createRepairRecipe(Item itemToRepair, List<Ingredient> repairItems) {
        WeldRecipe recipe = new WeldRecipe(true, Optional.of(itemToRepair), Optional.of(200), repairItems, Optional.of(new WeldRecipe.RecipeResult(itemToRepair)));
        return ((JsonElement)WeldRecipe.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).get().ifLeft(element -> {
            JsonObject json = element.getAsJsonObject();
            json.addProperty("type", TardisRecipeSerialisers.WELD_RECIPE_TYPE_LOC.toString());
        }).ifRight(right -> Tardis.LOGGER.error(right.message())).orThrow()).getAsJsonObject();
    }

    public JsonObject createRepairRecipeWithProgress(Item itemToRepair, List<Ingredient> repairItems, int progressTicks) {
        WeldRecipe recipe = new WeldRecipe(true, Optional.of(itemToRepair), Optional.of(progressTicks), repairItems, Optional.of(new WeldRecipe.RecipeResult(itemToRepair)));
        return ((JsonElement)WeldRecipe.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).get().ifLeft(element -> {
            JsonObject json = element.getAsJsonObject();
            json.addProperty("type", TardisRecipeSerialisers.WELD_RECIPE_TYPE_LOC.toString());
        }).ifRight(right -> Tardis.LOGGER.error(right.message())).orThrow()).getAsJsonObject();
    }
}

