/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.Tardis;
import net.tardis.mod.recipe.AttunableRecipe;
import net.tardis.mod.recipe.TardisRecipeSerialisers;

public class AttunableRecipeGen
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public AttunableRecipeGen(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        this.createAttuneableRecipeWithOutTag(path, cache, 120, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151082_bd}), Items.field_151083_be);
        this.createAttuneableRecipeWithOutTag(path, cache, 120, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179561_bm}), Items.field_179557_bn);
        this.createAttuneableRecipeWithOutTag(path, cache, 120, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151076_bf}), Items.field_151077_bg);
        this.createAttuneableRecipeWithOutTag(path, cache, 120, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151147_al}), Items.field_151157_am);
        this.createAttuneableRecipeWithOutTag(path, cache, 120, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW}), Items.field_196102_ba);
        this.createAttuneableRecipeWithOutTag(path, cache, 120, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196087_aX}), Items.field_196104_bb);
        this.createAttuneableRecipeWithOutTag(path, cache, 120, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179558_bo}), Items.field_179559_bp);
    }

    public String func_200397_b() {
        return "TARDIS Attuneable Recipe Generator";
    }

    public void createAttuneableRecipeWithOutTag(Path path, DirectoryCache cache, int attunementTicks, Ingredient ingredient, Item output) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createRecipe(attunementTicks, ingredient, output), (Path)AttunableRecipeGen.getPath(path, output));
    }

    public void createAttuneableRecipeWithTag(Path path, DirectoryCache cache, int attunementTicks, Ingredient ingredient, Item output) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createRecipeWithNBTTags(true, attunementTicks, ingredient, output), (Path)AttunableRecipeGen.getPath(path, output));
    }

    public static Path getPath(Path path, Item output) {
        ResourceLocation key = output.getRegistryName();
        return path.resolve("data/" + key.func_110624_b() + "/recipes/attunable/" + key.func_110623_a() + ".json");
    }

    public JsonObject createRecipeWithNBTTags(boolean addNBTTags, int attunementTicks, Ingredient ingredient, Item output) {
        AttunableRecipe recipe = new AttunableRecipe(addNBTTags, attunementTicks, ingredient, new AttunableRecipe.RecipeResult(output));
        return ((JsonElement)recipe.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).get().ifLeft(element -> {
            JsonObject json = element.getAsJsonObject();
            json.addProperty("type", TardisRecipeSerialisers.ATTUNEABLE_TYPE_LOC.toString());
        }).ifRight(right -> Tardis.LOGGER.error(right.message())).orThrow()).getAsJsonObject();
    }

    public JsonObject createRecipe(int attunementTicks, Ingredient ingredient, Item output) {
        AttunableRecipe recipe = new AttunableRecipe(attunementTicks, ingredient, new AttunableRecipe.RecipeResult(output));
        return ((JsonElement)recipe.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).get().ifLeft(element -> {
            JsonObject json = element.getAsJsonObject();
            json.addProperty("type", TardisRecipeSerialisers.ATTUNEABLE_TYPE_LOC.toString());
        }).ifRight(right -> Tardis.LOGGER.error(right.message())).orThrow()).getAsJsonObject();
    }
}

