/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.items.TItems;
import net.tardis.mod.recipe.AlembicRecipe;
import net.tardis.mod.tags.TardisItemTags;

public class AlembicRecipeGen
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public AlembicRecipeGen(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        this.createAlembicRecipeWithTag(path, cache, 1000, Ingredient.func_199805_a(TardisItemTags.PLANTS), 16, new ItemStack((IItemProvider)TItems.CIRCUIT_PASTE.get(), 1));
        this.createFluidGenerationRecipe(path, cache, "mercury", 500, Ingredient.func_199805_a(TardisItemTags.CINNABAR), 1, 250);
    }

    public String func_200397_b() {
        return "TARDIS Alembic Recipe Generator";
    }

    public static Path getPath(Path path, Item output) {
        ResourceLocation key = output.getRegistryName();
        return path.resolve("data/" + key.func_110624_b() + "/recipes/alembic/" + key.func_110623_a() + ".json");
    }

    public static Path getPathSpecial(Path path, String modID, String fileName) {
        return path.resolve("data/" + modID + "/recipes/alembic/" + fileName + ".json");
    }

    public void createAlembicRecipeWithItem(Path path, DirectoryCache cache, int requiredWater, Ingredient ingredient, int requiredIngredientCount, ItemStack output) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createRecipeWithItem(requiredWater, ingredient, requiredIngredientCount, output), (Path)AlembicRecipeGen.getPath(path, output.func_77973_b()));
    }

    public void createAlembicRecipeWithTag(Path path, DirectoryCache cache, int requiredWater, Ingredient ingredient, int requiredIngredientCount, ItemStack output) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createRecipeWithTag(requiredWater, ingredient, requiredIngredientCount, output), (Path)AlembicRecipeGen.getPath(path, output.func_77973_b()));
    }

    public void createFluidGenerationRecipe(Path base, DirectoryCache cache, String fileName, int requiredWater, Ingredient ingredient, int requiredIngredientCount, int generatedFluidAmount) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.createFluidGenerationRecipe(requiredWater, ingredient, requiredIngredientCount, generatedFluidAmount), (Path)AlembicRecipeGen.getPathSpecial(base, "tardis", fileName));
    }

    public JsonObject createRecipeWithItem(int requiredWater, Ingredient ingredient, int requiredIngredientCount, ItemStack output) {
        AlembicRecipe recipe = new AlembicRecipe(requiredWater, requiredIngredientCount, ingredient, output);
        return recipe.toJson();
    }

    public JsonObject createRecipeWithTag(int requiredWater, Ingredient ingredient, int requiredIngredientCount, ItemStack output) {
        AlembicRecipe recipe = new AlembicRecipe(requiredWater, requiredIngredientCount, ingredient, output);
        return recipe.toJson();
    }

    public JsonObject createFluidGenerationRecipe(int requiredWater, Ingredient ingredient, int requiredIngredientCount, int generatedFluid) {
        AlembicRecipe recipe = new AlembicRecipe(requiredWater, requiredIngredientCount, ingredient).setGeneratedFluid(generatedFluid);
        return recipe.toJson();
    }

    public JsonObject createItemFromMercuryRecipe(int requiredFluid, Ingredient ingredient, int requiredIngredientCount, AlembicRecipe.ResultType resultType, ItemStack output, int resultCount) {
        ItemStack result = output;
        output.func_190920_e(resultCount);
        AlembicRecipe recipe = new AlembicRecipe(requiredFluid, requiredIngredientCount, resultType, ingredient, result);
        return recipe.toJson();
    }
}

