/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.controls.HandbrakeControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class ThrottleControl
extends BaseControl {
    private float throttle = 0.0f;

    public ThrottleControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.throttle = tag.func_74760_g("throttle");
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74776_a("throttle", this.throttle);
        return tag;
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        return EntitySize.func_220314_b((float)0.225f, (float)0.225f);
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(0.0625, 0.5, -0.8125);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(0.2658954996435158, 0.5, 0.8247037291009587);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(-0.015556977219671198, 0.65625, 0.5999143096893602);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(-0.293, 0.375, 0.773);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(0.21, 0.406, 0.787);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(-0.4830320079849174, 0.25, -0.8288558019362365);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(0.5754439439677996, 0.5625, 0.9782320680707324);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(0.2848366089721458, 0.375, 1.022849836743878);
        }
        return new Vector3d(-0.9568176187101369, 0.48749999701976776, -0.2428564747162537);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        return this.doThrottleAction(console, player, 0.1f);
    }

    @Override
    public boolean onHit(ConsoleTile console, PlayerEntity player) {
        this.doThrottleAction(console, player, 1.0f);
        return true;
    }

    private boolean doThrottleAction(ConsoleTile console, PlayerEntity player, float amt) {
        if (!player.field_70170_p.field_72995_K) {
            this.throttle = (float)MathHelper.func_151237_a((double)(this.throttle + (player.func_225608_bj_() ? -amt : amt)), (double)0.0, (double)1.0);
            if (this.shouldTakeoff(console)) {
                console.takeoff();
            } else if (console.isInFlight()) {
                if (this.throttle <= 0.0f) {
                    player.field_70170_p.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> console.initLand()));
                } else {
                    console.updateFlightTime();
                }
            }
        }
        return true;
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return (SoundEvent)TSounds.SINGLE_CLOISTER.get();
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return (SoundEvent)TSounds.THROTTLE.get();
    }

    public float getAmount() {
        return this.throttle;
    }

    public void setAmount(float amt) {
        this.throttle = amt;
        this.markDirty();
    }

    private boolean shouldTakeoff(ConsoleTile console) {
        boolean free = false;
        HandbrakeControl br = console.getControl(HandbrakeControl.class).orElse(null);
        if (br != null) {
            free = br.isFree();
        }
        return free && this.throttle > 0.0f && !console.isInFlight();
    }
}

