/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.TelepathicGetStructuresMessage;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.PlayerTelepathicConnection;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;
import net.tardis.mod.upgrades.StructureLocatorUpgrade;

public class TelepathicControl
extends BaseControl {
    private boolean canUseStructures = false;

    public TelepathicControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return EntitySize.func_220311_c((float)0.25f, (float)0.25f);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.375f, (float)0.375f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.375f, (float)0.25f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.3125f, (float)0.3125f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        return EntitySize.func_220311_c((float)0.375f, (float)0.25f);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (!player.func_225608_bj_() && console.func_145831_w().field_72995_K) {
            ClientHelper.openGUI(12, null);
        } else if (!console.func_145831_w().func_201670_d()) {
            console.getUpgrade(StructureLocatorUpgrade.class).ifPresent(structure -> {
                this.canUseStructures = structure.isActivated() && structure.isUsable();
            });
            if (player.func_225608_bj_()) {
                PlayerTelepathicConnection connection = new PlayerTelepathicConnection(console, player, 13000);
                console.getEmotionHandler().addConnectedPlayer(connection);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.telepathic.connected"), true);
            } else {
                console.getControl(TelepathicControl.class).ifPresent(tele -> {
                    if (tele.canSeeStructures()) {
                        Network.sendTo(TelepathicGetStructuresMessage.create(player.func_184102_h(), player.func_130014_f_()), (ServerPlayerEntity)player);
                    }
                });
            }
        }
        this.startAnimation();
        return true;
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(0.6875, 0.4375, 0.375);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(0.4108330938524687, 0.59375, -0.2363353443240117);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(0.8145038135858447, 0.40625, 0.005);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(-0.006, 0.438, -0.654);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(0.516, 0.469, 0.316);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(0.007514401909703539, 0.21875, -0.6239749761798724);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(0.6490099209678046, 0.59375, -1.0235097045412442);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(1.0653904217105583, 0.28125, -0.20452082946839545);
        }
        return new Vector3d(0.6875, 0.4375, 0.375);
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return null;
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return (SoundEvent)TSounds.TELEPATHIC_CIRCUIT.get();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("structures", this.canUseStructures);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.canUseStructures = nbt.func_74767_n("structures");
    }

    public boolean canSeeStructures() {
        return this.canUseStructures;
    }
}

