/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.items.TItems;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.StabilizerSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class StabilizerControl
extends BaseControl {
    public StabilizerControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (!console.func_145831_w().field_72995_K) {
            console.getSubsystem(StabilizerSubsystem.class).ifPresent(sys -> {
                if (sys.canBeUsed()) {
                    sys.setControlActivated(!sys.isControlActivated());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.control.stabilizer." + sys.isControlActivated()), true);
                } else {
                    ItemStack name = new ItemStack((IItemProvider)TItems.STABILIZERS.get());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.no_subsystem", new Object[]{name.func_200301_q().getString()}), true);
                }
            });
            this.setAnimationTicks(20);
            this.markDirty();
        }
        return true;
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(0.84375, 0.4375, 0.15625);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(0.5455551641720471, 0.425, -0.5866870884910467);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(-0.5442238848074868, 0.34375, 0.7);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(0.166, 0.344, 0.728);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(0.0, 0.375, 0.756);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(0.45423586733985566, 0.3125, -0.769970078434481);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(0.018837774181529765, 0.375, -1.0038470729956595);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(0.6131817947812537, 0.4375, -0.49161027485812314);
        }
        return new Vector3d(-0.4375, 0.625, 0.25);
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return null;
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        ObjectWrapper<IForgeRegistryEntry> sound = new ObjectWrapper<IForgeRegistryEntry>(TSounds.STABILIZER_ON.get());
        console.getSubsystem(StabilizerSubsystem.class).ifPresent(sys -> {
            if (!sys.isControlActivated()) {
                sound.setValue(TSounds.STABILIZER_OFF.get());
            }
        });
        return (SoundEvent)sound.getValue();
    }

    public CompoundNBT serializeNBT() {
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
    }

    @Override
    public void setConsole(ConsoleTile console, ControlEntity entity) {
        super.setConsole(console, entity);
    }
}

