/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import java.util.HashSet;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.items.TItems;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class SonicPortControl
extends BaseControl {
    public SonicPortControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (!console.func_145831_w().func_201670_d()) {
            if (player.func_184614_ca().func_77973_b() == TItems.SONIC.get() && console.getSonicItem().func_190926_b()) {
                console.setSonicItem(player.func_184614_ca());
                player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                console.getSonicItem().getCapability(Capabilities.SONIC_CAPABILITY).ifPresent(cap -> {
                    HashSet<Schematic> uniqueSchematics = new HashSet<Schematic>();
                    uniqueSchematics.addAll(cap.getSchematics());
                    for (Schematic s : uniqueSchematics) {
                        if (!s.onConsumedByTARDIS(console, player)) continue;
                        cap.getSchematics().remove(s);
                    }
                });
            } else if (player.func_184614_ca().func_190926_b() && !console.getSonicItem().func_190926_b()) {
                InventoryHelper.func_180173_a((World)console.func_145831_w(), (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)console.getSonicItem());
                console.setSonicItem(ItemStack.field_190927_a);
            }
        }
        return true;
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(0.0, 0.375, 0.6875);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(0.4405431448823669, 0.59375, 0.2563013906978433);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(8.4E-5, 0.46875, 0.925973550627678);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(0.812, 0.419, -0.104);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(-0.568, 0.531, 0.18);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(0.5, 0.425, 0.30095038457786805);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(-0.6386732096349401, 0.4375, 0.3380022588333057);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(-0.7754584326851953, 0.46875, 0.11659741289809078);
        }
        return new Vector3d(-0.6875, 0.375, 0.375);
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return null;
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return console.getSonicItem() != null ? SoundEvents.field_187620_cL : SoundEvents.field_187629_cO;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
    }
}

