/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.items.TItems;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.FluidLinksSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class RefuelerControl
extends BaseControl {
    private static final TranslationTextComponent ON = new TranslationTextComponent("message.tardis.control.refuel.true");
    private static final TranslationTextComponent OFF = new TranslationTextComponent("message.tardis.control.refuel.false");
    private boolean isRefueling = false;

    public RefuelerControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.0825f, (float)0.0825f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (!console.func_145831_w().func_201670_d()) {
            LazyOptional<FluidLinksSubsystem> links = console.getSubsystem(FluidLinksSubsystem.class);
            links.ifPresent(link -> {
                if (link.canBeUsed()) {
                    this.isRefueling = !this.isRefueling;
                    console.updateClient();
                    player.func_146105_b((ITextComponent)(this.isRefueling ? ON : OFF), true);
                    this.startAnimation();
                } else {
                    ItemStack name = new ItemStack((IItemProvider)TItems.FLUID_LINK.get());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.no_subsystem", new Object[]{name.func_200301_q().getString()}), true);
                }
            });
        }
        return true;
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(0.25, 0.375, -0.75);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(0.813087980367591, 0.375, 0.19558907625845867);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(0.2303583465628734, 0.55, -0.4);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(-0.55, 0.438, -0.442);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(0.002, 0.45, -0.754);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(0.9418336762858615, 0.375, 0.015390332810151897);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(0.8955769767178283, 0.375, -0.46198242608214435);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(0.28281338270450995, 0.46875, 0.756872738705749);
        }
        return new Vector3d(0.34375, 0.375, -1.0);
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return null;
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return this.isRefueling ? (SoundEvent)TSounds.REFUEL_START.get() : (SoundEvent)TSounds.REFUEL_STOP.get();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("is_fueling", this.isRefueling);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.isRefueling = nbt.func_74767_n("is_fueling");
    }

    public boolean isRefueling() {
        return this.isRefueling;
    }

    public void setRefueling(boolean refuel) {
        this.isRefueling = refuel;
        this.markDirty();
    }
}

