/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.contexts.gui.EntityContext;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.misc.IMonitor;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;
import net.tardis.mod.tileentities.monitors.MonitorTile;

public class MonitorControl
extends BaseControl
implements IMonitor {
    private MonitorTile.MonitorView view = MonitorTile.MonitorView.PANORAMIC;

    public MonitorControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.3125f, (float)0.3125f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.375f, (float)0.375f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.3125f, (float)0.3125f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.3125f, (float)0.3125f);
        }
        return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (console.func_145831_w().field_72995_K) {
            if (PlayerHelper.InEitherHand((LivingEntity)player, stack -> stack.func_77973_b() == TItems.MONITOR_REMOTE.get())) {
                ClientHelper.openGUI(23, new EntityContext(this.getEntity()));
                return true;
            }
            if (console instanceof GalvanicConsoleTile) {
                ClientHelper.openGUI(9, null);
                return true;
            }
            if (console instanceof XionConsoleTile) {
                ClientHelper.openGUI(18, null);
                return true;
            }
            if (console instanceof ToyotaConsoleTile) {
                ClientHelper.openGUI(19, null);
                return true;
            }
            if (console instanceof CoralConsoleTile) {
                ClientHelper.openGUI(20, null);
                return true;
            }
            ClientHelper.openGUI(8, null);
            return true;
        }
        return true;
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(0.35, 0.6875, 0.525789599508169);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(0.534, 0.469, -0.35);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(0.29892208354437577, 0.8125, 0.478818161338896);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(0.010354376833276668, 0.4375, -0.8105755249479349);
        }
        return new Vector3d(-0.5282378865176893, 0.59375, -0.2954572166748212);
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return null;
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return null;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("view", this.view.ordinal());
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.view = MonitorTile.MonitorView.values()[nbt.func_74762_e("view")];
    }

    @Override
    public MonitorTile.MonitorView getView() {
        return this.view;
    }

    @Override
    public void setView(MonitorTile.MonitorView view) {
        this.view = view;
        this.markDirty();
    }
}

