/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class LandingTypeControl
extends BaseControl {
    private EnumLandType landType = EnumLandType.UP;

    public LandingTypeControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.1625f, (float)0.1625f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.15f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.0625f, (float)0.0625f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        return EntitySize.func_220314_b((float)0.3125f, (float)0.25f);
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(-0.75, 0.4375, -0.1875);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(-0.5335388604239691, 0.39374999701976776, 0.5526540125111579);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(-0.41553599579609124, 0.53125, -0.625);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(0.509, 0.5, 0.442);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(0.2, 0.469, -0.676);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(-0.2667170339295745, 0.625, 0.5812400555777666);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(0.7645579019481885, 0.375, -0.689489363943395);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(-0.2943457727866642, 0.46875, 0.7714165309469789);
        }
        return new Vector3d(-0.03125, 0.3125, -0.9375);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            this.landType = this.landType == EnumLandType.UP ? EnumLandType.DOWN : EnumLandType.UP;
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.control.land_type").func_230529_a_((ITextComponent)new StringTextComponent(this.getLandType().name()).func_240699_a_(TextFormatting.LIGHT_PURPLE)), true);
            this.setAnimationTicks(20);
        }
        return true;
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return (SoundEvent)TSounds.SINGLE_CLOISTER.get();
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return this.landType == EnumLandType.UP ? (SoundEvent)TSounds.LANDING_TYPE_UP.get() : (SoundEvent)TSounds.LANDING_TYPE_DOWN.get();
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.landType = EnumLandType.values()[tag.func_74762_e("land_type")];
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("land_type", this.landType.ordinal());
        return tag;
    }

    public void setLandType(EnumLandType type) {
        this.landType = type;
    }

    public EnumLandType getLandType() {
        return this.landType;
    }

    public static enum EnumLandType {
        UP,
        DOWN;

    }
}

