/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class IncModControl
extends BaseControl {
    public static final String USE_TRANSLATION = "message.tardis.control.inc_mod";
    public static int[] COORD_MODS = new int[]{1, 10, 100, 1000, 10000};
    public int index;

    public IncModControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.1625f, (float)0.1625f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        return EntitySize.func_220314_b((float)0.1875f, (float)0.125f);
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(-0.8125, 0.375, 0.4375);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(-0.6071484912786207, 0.39374999701976776, 0.3642372909987306);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(-0.5, 0.5625, 0.3175);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(-0.59, 0.469, 0.092);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(-0.503, 0.469, 0.525);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(0.5333379834907053, 0.34375, 0.9640984733364331);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(0.8195188587203308, 0.375, 0.47455568332207365);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(0.6633852686396295, 0.34375, -0.9062030791378303);
        }
        return new Vector3d(-0.6875, 0.4375, -0.6875);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (!console.func_145831_w().func_201670_d()) {
            if (player.func_225608_bj_()) {
                this.index = this.index - 1 < 0 ? COORD_MODS.length - 1 : --this.index;
                console.coordIncr = COORD_MODS[this.index];
            } else {
                this.index = this.index + 1 >= COORD_MODS.length ? 0 : ++this.index;
                console.coordIncr = COORD_MODS[this.index];
                console.updateClient();
            }
            this.startAnimation();
            player.func_146105_b((ITextComponent)new TranslationTextComponent(USE_TRANSLATION).func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(console.coordIncr)).func_240699_a_(TextFormatting.LIGHT_PURPLE)), true);
        }
        return true;
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return (SoundEvent)TSounds.SINGLE_CLOISTER.get();
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return (SoundEvent)TSounds.GENERIC_TWO.get();
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.index = tag.func_74762_e("index");
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("index", this.index);
        return tag;
    }
}

