/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.controls.ThrottleControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.misc.CrashTypes;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class HandbrakeControl
extends BaseControl {
    public static final ResourceLocation SAVE_KEY = new ResourceLocation("tardis", "handbrake_data");
    private boolean isFree = false;

    public HandbrakeControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(-0.125, 0.5, -0.8125);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(-0.2982304929003854, 0.375, 0.8465142260574359);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(-0.7203601993321677, 0.5625, -0.3625);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(-0.059, 0.375, 0.774);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(-0.206, 0.375, 0.768);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(-1.127392157437948, 0.1875, -0.0012375564178497278);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(-1.1546022251848151, 0.59375, -0.00377360907123081);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(0.4691775280536088, 0.375, 1.0251364745327698);
        }
        return new Vector3d(0.31798977635472236, 0.48749999701976776, 0.9024203281819716);
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.isFree = tag.func_74767_n("free");
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("free", this.isFree);
        return tag;
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (console == null || !console.func_145830_o()) {
            return false;
        }
        if (!console.func_145831_w().func_201670_d()) {
            boolean bl = this.isFree = !this.isFree;
            if (console.isInFlight() && !this.isFree) {
                console.crash(CrashTypes.DEFAULT);
            }
            console.getControl(ThrottleControl.class).ifPresent(throttle -> {
                if (throttle.getAmount() > 0.0f && this.isFree()) {
                    console.takeoff();
                }
            });
            this.markDirty();
        }
        return true;
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return (SoundEvent)TSounds.SINGLE_CLOISTER.get();
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return this.isFree() ? (SoundEvent)TSounds.HANDBRAKE_RELEASE.get() : (SoundEvent)TSounds.HANDBRAKE_ENGAGE.get();
    }

    public boolean isFree() {
        return this.isFree;
    }

    public void setFree(boolean free) {
        this.isFree = free;
        this.markDirty();
    }

    @Override
    public ResourceLocation getAdditionalDataSaveKey() {
        return SAVE_KEY;
    }

    @Override
    public void setConsole(ConsoleTile console, ControlEntity entity) {
        super.setConsole(console, entity);
        console.registerDataHandler(SAVE_KEY, this);
    }
}

