/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class FastReturnControl
extends BaseControl {
    public FastReturnControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.099999994f, (float)0.099999994f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.2f, (float)0.325f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (!console.func_145831_w().func_201670_d() && console.getLandTime() <= 0) {
            SpaceTimeCoord coord = console.getReturnLocation();
            RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)coord.getDimRL());
            console.setDestination((RegistryKey<World>)worldKey, coord.getPos());
            console.setExteriorFacingDirection(coord.getFacing());
            this.startAnimation();
        }
        return true;
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(0.5625, 0.4375, 0.65625);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(-0.26433123161703187, 0.45625, -0.8173110443482853);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(-0.3252235365186568, 0.15, -1.05);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(0.002, 0.438, 0.375);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(-0.206, 0.531, -0.617);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(-0.28484833473880095, 0.71875, -0.5101038312508607);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(-0.7006116964503074, 0.46875, -0.6819940772792219);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(0.8303029743618082, 0.46875, -0.15396611984219444);
        }
        return new Vector3d(1.0, 0.4375, 0.15625);
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return null;
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return (SoundEvent)TSounds.GENERIC_ONE.get();
    }

    public CompoundNBT serializeNBT() {
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
    }
}

