/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class FacingControl
extends BaseControl {
    private Direction facing = Direction.NORTH;

    public FacingControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.125f);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.1625f, (float)0.1625f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.0625f, (float)0.0625f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        return EntitySize.func_220314_b((float)0.1875f, (float)0.3125f);
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(-0.5625, 0.5, -0.5625);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(-0.7350152138595012, 0.39374999701976776, 0.20420024945559656);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(-0.24328874178188886, 0.53125, 0.425);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(0.648, 0.5, 0.225);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(-0.763, 0.406, -0.185);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(1.1245386855892283, 0.125, -0.015023021137454462);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(0.3273009412682333, 0.4375, 1.064750650987496);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(0.9364063741581483, 0.40625, 0.2252643279138704);
        }
        return new Vector3d(-0.33125, 0.3125, 0.9375);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        int index = this.getDirection().func_176736_b() + (player.func_225608_bj_() ? -1 : 1);
        if (index < 0) {
            index = 3;
        } else if (index > 3) {
            index = 0;
        }
        this.facing = Direction.func_176731_b((int)index);
        if (!player.field_70170_p.field_72995_K) {
            console.setExteriorFacingDirection(this.facing);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.control.facing").func_230529_a_((ITextComponent)new StringTextComponent(this.facing.func_176742_j().toUpperCase()).func_240699_a_(TextFormatting.LIGHT_PURPLE)), true);
            this.setAnimationTicks(20);
        }
        return true;
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return (SoundEvent)TSounds.SINGLE_CLOISTER.get();
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return (SoundEvent)TSounds.DIRECTION.get();
    }

    public void deserializeNBT(CompoundNBT tag) {
    }

    public CompoundNBT serializeNBT() {
        return new CompoundNBT();
    }

    public void setDirection(Direction facing) {
        this.facing = facing;
    }

    public Direction getDirection() {
        return this.facing;
    }
}

