/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import java.util.ArrayList;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ConsoleUpdateMessage;
import net.tardis.mod.network.packets.console.DataTypes;
import net.tardis.mod.network.packets.console.DimensionData;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class DimensionControl
extends BaseControl {
    private static final String MESSAGE = "message.tardis.control.dimchange";
    private ArrayList<ServerWorld> dimList = new ArrayList();
    private int index = 0;
    private int avaliableDimensions = 1;

    public DimensionControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.225f, (float)0.225f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.3125f, (float)0.3125f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        return EntitySize.func_220314_b((float)0.375f, (float)0.125f);
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(0.0, 0.75, 0.5);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(0.004546756986454792, 0.5499999970197678, 0.43130290108982927);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(-0.1918160605288799, 0.28125, 0.85162353648727);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(0.605, 0.469, -0.516);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(-0.557, 0.438, -0.313);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(-0.4978632379852379, 0.5, 0.30190849470534653);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(0.04, 0.40625, 0.8683701375027411);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(-0.9009227420613739, 0.28125, -0.5234101003733683);
        }
        return new Vector3d(-0.00625, 0.4375, 0.75);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (!console.hasNavCom()) {
            return false;
        }
        return this.doDimChangeAction(console, player);
    }

    private boolean doDimChangeAction(ConsoleTile console, PlayerEntity player) {
        if (!console.func_145831_w().func_201670_d() && console.getLandTime() <= 0) {
            this.createDimListIfEmpty();
            if (!this.dimList.isEmpty()) {
                this.modIndex(player.func_225608_bj_() ? -1 : 1);
                ServerWorld type = this.dimList.get(this.index);
                console.setDestination((RegistryKey<World>)type.func_234923_W_(), console.getDestinationPosition());
                player.func_146105_b((ITextComponent)new TranslationTextComponent(MESSAGE).func_230529_a_((ITextComponent)new StringTextComponent(WorldHelper.formatDimName((RegistryKey<World>)type.func_234923_W_())).func_240699_a_(TextFormatting.LIGHT_PURPLE)), true);
                this.startAnimation();
                ConsoleTile tile = this.getConsole();
                if (tile != null) {
                    Network.sendToTrackingTE(new ConsoleUpdateMessage(DataTypes.DIMENSION_LIST, new DimensionData(this.dimList.size(), this.index)), tile);
                }
            } else {
                this.index = 0;
            }
            return true;
        }
        return false;
    }

    private void modIndex(int i) {
        if (this.index + i >= this.dimList.size()) {
            this.index = 0;
            return;
        }
        if (this.index + i < 0) {
            this.index = this.dimList.size() - 1;
            return;
        }
        this.index += i;
    }

    private void createDimListIfEmpty() {
        if (this.dimList.isEmpty()) {
            ServerLifecycleHooks.getCurrentServer().func_212370_w().forEach(world -> {
                if (WorldHelper.canTravelToDimension((World)world)) {
                    this.dimList.add((ServerWorld)world);
                }
            });
        }
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return (SoundEvent)TSounds.SONIC_FAIL.get();
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return (SoundEvent)TSounds.DIMENSION.get();
    }

    public void deserializeNBT(CompoundNBT tag) {
    }

    public CompoundNBT serializeNBT() {
        return new CompoundNBT();
    }

    public void setAvailableDimensions(int dims) {
        this.avaliableDimensions = dims;
    }

    public int getAvailableDimensions() {
        return this.avaliableDimensions;
    }

    public int getDimListIndex() {
        return this.index;
    }

    public void setDimIndex(int index) {
        this.index = index;
    }
}

