/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.contexts.gui.ConsoleContext;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.misc.ITickable;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.TardisNameGuiMessage;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.AntennaSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.consoles.CoralConsoleTile;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;
import net.tardis.mod.tileentities.consoles.HartnellConsoleTile;
import net.tardis.mod.tileentities.consoles.KeltConsoleTile;
import net.tardis.mod.tileentities.consoles.NemoConsoleTile;
import net.tardis.mod.tileentities.consoles.NeutronConsoleTile;
import net.tardis.mod.tileentities.consoles.ToyotaConsoleTile;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class CommunicatorControl
extends BaseControl
implements ITickable {
    public CommunicatorControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity) {
        super(entry, console, entity);
        if (this.getConsole() != null) {
            this.getConsole().registerTicker(this);
        }
    }

    @Override
    public EntitySize getSize() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return EntitySize.func_220314_b((float)0.3f, (float)0.3f);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return EntitySize.func_220314_b((float)0.1625f, (float)0.1625f);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof HartnellConsoleTile || this.getConsole() instanceof XionConsoleTile) {
            return EntitySize.func_220314_b((float)0.125f, (float)0.125f);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return EntitySize.func_220314_b((float)0.1875f, (float)0.1875f);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return EntitySize.func_220314_b((float)0.25f, (float)0.25f);
        }
        return EntitySize.func_220314_b((float)0.4f, (float)0.4f);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (!console.func_145831_w().field_72995_K) {
            this.startAnimation();
        }
        if (!console.getDistressSignals().isEmpty() && console.func_145831_w().field_72995_K) {
            if (this.usePhoneSounds(console)) {
                ClientHelper.shutTheFuckUp((SoundEvent)TSounds.COMMUNICATOR_RING.get(), SoundCategory.BLOCKS);
                console.func_145831_w().func_184133_a(player, console.func_174877_v(), (SoundEvent)TSounds.COMMUNICATOR_PHONE_PICKUP.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            ClientHelper.openGUI(15, null);
        }
        if (console.getDistressSignals().isEmpty()) {
            if (console.func_145831_w().field_72995_K) {
                ClientHelper.openGUI(25, new ConsoleContext(console));
            } else if (!console.func_145831_w().field_72995_K) {
                Network.sendTo(TardisNameGuiMessage.create(player.func_184102_h()), (ServerPlayerEntity)player);
            }
        }
        return true;
    }

    @Override
    public Vector3d getPos() {
        if (this.getConsole() instanceof NemoConsoleTile) {
            return new Vector3d(0.375, 0.75, -0.25);
        }
        if (this.getConsole() instanceof GalvanicConsoleTile) {
            return new Vector3d(-0.5577870538580397, 0.33124999701976776, -0.6428223124704939);
        }
        if (this.getConsole() instanceof CoralConsoleTile) {
            return new Vector3d(-0.7, 0.375, -0.1);
        }
        if (this.getConsole() instanceof HartnellConsoleTile) {
            return new Vector3d(0.617, 0.469, -0.171);
        }
        if (this.getConsole() instanceof ToyotaConsoleTile) {
            return new Vector3d(-0.588, 0.375, 0.334);
        }
        if (this.getConsole() instanceof XionConsoleTile) {
            return new Vector3d(-0.725851740394144, 0.3, -0.5289371401696679);
        }
        if (this.getConsole() instanceof NeutronConsoleTile) {
            return new Vector3d(-0.6431637508770778, 0.46875, -0.36798860366348973);
        }
        if (this.getConsole() instanceof KeltConsoleTile) {
            return new Vector3d(-0.7746081391896208, 0.46875, 0.4170838642472918);
        }
        return new Vector3d(0.0, 0.5, -0.375);
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return null;
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return console instanceof NemoConsoleTile ? SoundEvents.field_219603_Y : (SoundEvent)TSounds.COMMUNICATOR_STEAM.get();
    }

    public CompoundNBT serializeNBT() {
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
    }

    @Override
    public void tick(ConsoleTile console) {
        if (console == null || console.func_145831_w() == null) {
            return;
        }
        if (!console.func_145831_w().field_72995_K && !console.getDistressSignals().isEmpty() && console.func_145831_w().func_82737_E() % 100L == 0L) {
            if (this.usePhoneSounds(console)) {
                console.func_145831_w().func_184133_a(null, console.func_174877_v(), (SoundEvent)TSounds.COMMUNICATOR_RING.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                console.func_145831_w().func_184133_a(null, console.func_174877_v(), (SoundEvent)TSounds.COMMUNICATOR_BEEP.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            console.getSubsystem(AntennaSubsystem.class).ifPresent(sys -> {
                if (!sys.canBeUsed()) {
                    console.getDistressSignals().clear();
                }
            });
        }
    }

    public boolean usePhoneSounds(ConsoleTile tile) {
        return this.getConsole() instanceof CoralConsoleTile || this.getConsole() instanceof XionConsoleTile || this.getConsole() instanceof ToyotaConsoleTile;
    }
}

