/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.tardis.mod.controls.BaseControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.NavComSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;

public abstract class AxisControl
extends BaseControl {
    Direction.Axis axis = Direction.Axis.X;

    public AxisControl(ControlRegistry.ControlEntry entry, ConsoleTile console, ControlEntity entity, Direction.Axis axis) {
        super(entry, console, entity);
        this.axis = axis;
    }

    public Direction.Axis getAxis() {
        return this.axis;
    }

    public void setAxis(Direction.Axis axis) {
        this.axis = axis;
    }

    public BlockPos getAddPos(int scale) {
        switch (this.axis) {
            case X: {
                return new BlockPos(scale, 0, 0);
            }
            case Y: {
                return new BlockPos(0, scale, 0);
            }
        }
        return new BlockPos(0, 0, scale);
    }

    @Override
    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        if (!console.func_145831_w().func_201670_d() && console.getLandTime() <= 0) {
            NavComSubsystem navCom = (NavComSubsystem)console.getSubsystem(NavComSubsystem.class).orElse(null);
            if (navCom == null || !navCom.canBeUsed()) {
                navCom.playDenySound(console);
                return false;
            }
            console.setDestination(console.getDestinationDimension(), console.getDestinationPosition().func_177971_a((Vector3i)this.getAddPos(player.func_225608_bj_() ? -console.getCoordIncr() : console.getCoordIncr())));
            this.setAnimationTicks(10);
        }
        return true;
    }

    @Override
    public SoundEvent getFailSound(ConsoleTile console) {
        return (SoundEvent)TSounds.GENERIC_ONE.get();
    }

    @Override
    public SoundEvent getSuccessSound(ConsoleTile console) {
        return (SoundEvent)TSounds.GENERIC_ONE.get();
    }
}

