/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.controls;

import javax.annotation.Nullable;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.tileentities.ConsoleTile;

public abstract class AbstractControl
implements INBTSerializable<CompoundNBT> {
    private final ControlRegistry.ControlEntry entry;

    public AbstractControl(ControlRegistry.ControlEntry entry) {
        this.entry = entry;
    }

    public EntitySize getSize() {
        return EntitySize.func_220314_b((float)1.0f, (float)1.0f);
    }

    public boolean onRightClicked(ConsoleTile console, PlayerEntity player) {
        return true;
    }

    public abstract Vector3d getPos();

    public boolean onHit(ConsoleTile console, PlayerEntity player) {
        return this.onRightClicked(console, player);
    }

    public abstract void setConsole(ConsoleTile var1, ControlEntity var2);

    public abstract ConsoleTile getConsole();

    public abstract SoundEvent getFailSound(ConsoleTile var1);

    public abstract SoundEvent getSuccessSound(ConsoleTile var1);

    public abstract String getTranslationKey();

    public abstract TranslationTextComponent getDisplayName();

    public abstract int getAnimationTicks();

    public abstract void setAnimationTicks(int var1);

    public abstract int getMaxAnimationTicks();

    public abstract float getAnimationProgress();

    public abstract void onPacketUpdate();

    public abstract void markDirty();

    public abstract void clean();

    public abstract boolean isDirty();

    public abstract boolean isGlowing();

    public abstract void setGlow(boolean var1);

    public abstract ControlEntity getEntity();

    @Nullable
    public abstract ResourceLocation getAdditionalDataSaveKey();

    public ControlRegistry.ControlEntry getEntry() {
        return this.entry;
    }
}

