/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.containers;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.containers.BaseContainer;
import net.tardis.mod.containers.TContainers;
import net.tardis.mod.containers.slot.EngineSlot;
import net.tardis.mod.helper.TInventoryHelper;
import net.tardis.mod.items.ArtronCapacitorItem;
import net.tardis.mod.items.TItems;
import net.tardis.mod.tileentities.inventory.PanelInventory;

public class EngineContainer
extends BaseContainer {
    Direction panel;

    protected EngineContainer(ContainerType<?> type, int id) {
        super(type, id);
    }

    public EngineContainer(int id, PlayerInventory inv, PacketBuffer buf) {
        this((ContainerType)TContainers.ENGINE.get(), id);
        this.panel = Direction.func_82600_a((int)buf.readInt());
        ClientHelper.getClientWorld().getCapability(Capabilities.TARDIS_DATA).ifPresent(world -> this.init(inv, world.getEngineInventoryForSide(this.panel)));
    }

    public EngineContainer(int id, PlayerInventory inv, PanelInventory engine, Direction panel) {
        this((ContainerType)TContainers.ENGINE.get(), id);
        this.panel = panel;
        this.init(inv, engine);
    }

    public void init(PlayerInventory inv, PanelInventory engine) {
        if (engine.getPanelDirection() == Direction.NORTH) {
            EngineSlot slot;
            int i;
            for (i = 0; i < 4; ++i) {
                slot = new EngineSlot(engine.getPanelDirection(), (IItemHandler)engine, i, 18 + i * 42, 1);
                if (i == 0) {
                    slot.setFilter(stack -> stack.func_77973_b() == TItems.DEMAT_CIRCUIT.get());
                }
                if (i == 1) {
                    slot.setFilter(stack -> stack.func_77973_b() == TItems.NAV_COM.get());
                }
                if (i == 2) {
                    slot.setFilter(stack -> stack.func_77973_b() == TItems.CHAMELEON_CIRCUIT.get());
                }
                if (i == 3) {
                    slot.setFilter(stack -> stack.func_77973_b() == TItems.TEMPORAL_GRACE.get());
                }
                this.func_75146_a((Slot)slot);
            }
            for (i = 0; i < 4; ++i) {
                slot = new EngineSlot(engine.getPanelDirection(), (IItemHandler)engine, i + 4, 18 + i * 42, 22);
                if (i == 0) {
                    slot.setFilter(stack -> stack.func_77973_b() == TItems.FLUID_LINK.get());
                }
                if (i == 1) {
                    slot.setFilter(stack -> stack.func_77973_b() == TItems.STABILIZERS.get());
                }
                if (i == 2) {
                    slot.setFilter(stack -> stack.func_77973_b() == TItems.INTERSTITIAL_ANTENNA.get());
                }
                if (i == 3) {
                    slot.setFilter(stack -> stack.func_77973_b() == TItems.SHEILD_GENERATOR.get());
                }
                this.func_75146_a((Slot)slot);
            }
        } else if (engine.getPanelDirection() == Direction.SOUTH) {
            for (int i = 0; i < 10; ++i) {
                this.func_75146_a((Slot)new EngineSlot(engine.getPanelDirection(), (IItemHandler)engine, i, 16 + (int)Math.ceil((double)(i / 2) * 32.5), 1 + i % 2 * 21));
            }
        } else if (engine.getPanelDirection() == Direction.EAST) {
            for (int i = 0; i < 4; ++i) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)engine, i, 32 + i / 2 * 22, -1 + i % 2 * 22));
            }
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)engine, 4, 119, 10));
        } else if (engine.getPanelDirection() == Direction.WEST) {
            for (int i = 0; i < 10; ++i) {
                this.func_75146_a((Slot)new EngineSlot(stack -> stack.func_77973_b() instanceof ArtronCapacitorItem, this.getPanelDirection(), (IItemHandler)engine, i, 19 + i / 2 * 31, 1 + i % 2 * 21));
            }
        }
        TInventoryHelper.addPlayerInvContainer(this, inv, 0, -19);
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        return ItemStack.field_190927_a;
    }

    public Direction getPanelDirection() {
        return this.panel;
    }
}

