/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class TConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static Client CLIENT;
    public static ForgeConfigSpec CLIENT_SPEC;
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    public static String createTranslationKey(String trans) {
        return "config.tardis." + trans;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        Pair specClientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specClientPair.getRight();
        CLIENT = (Client)specClientPair.getLeft();
        Pair specServerPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)specServerPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)specServerPair.getRight();
    }

    public static class Common {
        public ForgeConfigSpec.ConfigValue<Integer> tardisSpawnProbability;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> tardisSpawnDimBlacklist;
        public ForgeConfigSpec.ConfigValue<Integer> xionCrystalSpawnChance;
        public ForgeConfigSpec.ConfigValue<Integer> cinnabarOreSpawnChance;
        public ForgeConfigSpec.ConfigValue<Integer> crashedStructureSpawnChance;
        public ForgeConfigSpec.ConfigValue<Integer> crashedStructureSeperation;
        public ForgeConfigSpec.ConfigValue<Integer> crashedStructureSpacing;
        public ForgeConfigSpec.ConfigValue<Integer> spaceStationMissionSpawnChance;
        public ForgeConfigSpec.ConfigValue<Integer> spaceStationMissionSeperation;
        public ForgeConfigSpec.ConfigValue<Integer> spaceStationMissionSpacing;
        public ForgeConfigSpec.ConfigValue<Integer> dalekSaucerSpawnChance;
        public ForgeConfigSpec.ConfigValue<Integer> dalekSaucerSeperation;
        public ForgeConfigSpec.ConfigValue<Integer> dalekSaucerSpacing;
        public ForgeConfigSpec.ConfigValue<Integer> abandonedSpaceshipSpawnChance;
        public ForgeConfigSpec.ConfigValue<Integer> abandonedSpaceshipSeperation;
        public ForgeConfigSpec.ConfigValue<Integer> abandonedSpaceshipSpacing;
        public ForgeConfigSpec.ConfigValue<Integer> moonLanderSpawnChance;
        public ForgeConfigSpec.ConfigValue<Integer> moonLanderSeperation;
        public ForgeConfigSpec.ConfigValue<Integer> moonLanderSpacing;
        public ForgeConfigSpec.ConfigValue<Integer> observatorySpawnWeightPlains;
        public ForgeConfigSpec.ConfigValue<Integer> observatorySpawnWeightDesert;
        public ForgeConfigSpec.ConfigValue<Integer> observatorySpawnWeightSavanna;
        public ForgeConfigSpec.ConfigValue<Boolean> dalekJoinVillageRaid;
        public ForgeConfigSpec.ConfigValue<List<? extends Integer>> dalekVillageRaidSpawnCount;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("World Generation");
            builder.comment(new String[]{"Requires Server Restart to take effect.", "If you don't restart, unknown side effects can occur"});
            this.tardisSpawnProbability = builder.translation("config.tardis.tardis_spawn_chance").comment(new String[]{"The probability that a Broken Tardis Exterior will spawn in a valid position", "This must be a whole number, no decimals"}).comment(new String[]{"This value is divided by 100 to form the final probability", "Example: Value = 1, Spawn Chance = 1/100"}).define("tardisSpawnProbability", (Object)10);
            this.tardisSpawnDimBlacklist = builder.translation("config.tardis.tardis_spawn_dim_blacklist").comment(new String[]{"The list of dimension ids that a Broken Tardis Exterior cannot spawn in", "Example. tardis:moon", "Add an asterisk after the mod id to blacklist all dimensions.", "Example. tardis:*"}).defineList("tardisSpawnDimBlacklist", (List)Lists.newArrayList((Object[])new String[]{"twilightforest:twilightforest", "twilightforest:skylight_forest", "regen:*"}), String.class::isInstance);
            this.cinnabarOreSpawnChance = builder.translation("config.tardis.cinnabar_ore_spawn_chance").comment(new String[]{"The chance for Cinnabar Ore to spawn in the world", "This must be a whole number, no decimals", "The final spawn chance is equal to 1 divided by this config value", "Example: Value = 2, Spawn Chance = 1/2", "Use 1 to always generate this ore, 1001 to disable generation"}).defineInRange("cinnabarOreSpawnChance", 2, 1, 1001);
            this.xionCrystalSpawnChance = builder.translation("config.tardis.xion_crystal_spawn_chance").comment(new String[]{"The chance for Xion Crystals to spawn in the world", "This option does not allow decimal points", "This value is divided by 100 to form the final probability", "Example: Value = 1, Spawn Chance = 1/100"}).define("xionCrystalSpawnChance", (Object)30);
            builder.push("Crashed Structure");
            this.crashedStructureSpawnChance = builder.translation("config.tardis.structure_spawn_chance").comment(new String[]{"The chance for Crashed Structures such as Spaceships or Shuttles, to spawn in the world", "This option does not allow decimal points"}).comment(new String[]{"This value is divided by 100 to form the final probability", "Example: Value = 1, Spawn Chance = 1/100"}).define("crashedStructureSpawnChance", (Object)10);
            this.crashedStructureSeperation = builder.translation("config.tardis.structure_seperation").comment(new String[]{"The number of chunks that can seperate two instances of this structure", "This option does not allow decimal points"}).define("crashedStructureSeperation", (Object)60);
            this.crashedStructureSpacing = builder.translation("config.tardis.structure_spacing").comment(new String[]{"The chunk radius around a potential spawn location in which this structure can spawn.", "Structure Spacing value must be larger than Structure Seperation", "This option does not allow decimal points"}).define("crashedStructureSpacing", (Object)100);
            builder.pop();
            builder.push("Space Station");
            this.spaceStationMissionSpawnChance = builder.translation("config.tardis.structure_spawn_chance").comment(new String[]{"The chance for a Space Station Structure and its mission, to spawn in the world", "This option allows does allow decimal points", "This structure only spawns in the Space Dimension", "This value is divided by 100 to form the final probability", "Example: Value = 1, Spawn Chance = 1/100"}).define("spaceStationMissionSpawnChance", (Object)5);
            this.spaceStationMissionSeperation = builder.translation("config.tardis.structure_seperation").comment(new String[]{"The number of chunks that can seperate two instances of this structure", "This option does not allow decimal points"}).define("spaceStationMissionSeperation", (Object)40);
            this.spaceStationMissionSpacing = builder.translation("config.tardis.structure_spacing").comment(new String[]{"The chunk radius around a potential spawn location in which this structure can spawn.", "Structure Spacing value must be larger than Structure Seperation", "This option does not allow decimal points"}).define("spaceStationMissionSpacing", (Object)100);
            builder.pop();
            builder.push("Dalek Saucer");
            this.dalekSaucerSpawnChance = builder.translation("config.tardis.structure_spawn_chance").comment(new String[]{"The chance for a Dalek Saucer Structure to spawn in the world", "This option does not allow decimal points", "This value is divided by 100 to form the final probability", "Example: Value = 1, Spawn Chance = 1/100"}).define("dalekSaucerSpawnChance", (Object)3);
            this.dalekSaucerSeperation = builder.translation("config.tardis.structure_seperation").comment(new String[]{"The number of chunks that can seperate two instances of this structure", "This option does not allow decimal points"}).define("dalekSaucerSeperation", (Object)50);
            this.dalekSaucerSpacing = builder.translation("config.tardis.structure_spacing").comment(new String[]{"The chunk radius around a potential spawn location in which this structure can spawn.", "Structure Spacing value must be larger than Structure Seperation", "This option does not allow decimal points"}).define("dalekSaucerSpacing", (Object)200);
            builder.pop();
            builder.push("Abandoned Spaceship");
            this.abandonedSpaceshipSpawnChance = builder.translation("config.tardis.structure_spawn_chance").comment(new String[]{"The chance for Abandoned Spaceship Structure, to spawn in the world", "This option does not allow decimal points", "This value is divided by 100 to form the final probability", "Example: Value = 1, Spawn Chance = 1/100"}).define("abandonedSpaceshipSpawnChance", (Object)8);
            this.abandonedSpaceshipSeperation = builder.translation("config.tardis.structure_seperation").comment(new String[]{"The number of chunks that can seperate two instances of this structure", "This option does not allow decimal points"}).define("abandonedSpaceshipSeperation", (Object)20);
            this.abandonedSpaceshipSpacing = builder.translation("config.tardis.structure_spacing").comment(new String[]{"The chunk radius around a potential spawn location in which this structure can spawn.", "Structure Spacing value must be larger than Structure Seperation", "This option does not allow decimal points"}).define("abandonedSpaceshipSpacing", (Object)70);
            builder.pop();
            builder.push("Moon Lander");
            this.moonLanderSpawnChance = builder.translation("config.tardis.structure_spawn_chance").comment(new String[]{"The chance for Moon Lander Structure to spawn in the world", "This option does not allow decimal points", "This structure only spawns in the Moon Dimension", "This value is divided by 100 to form the final probability", "Example: Value = 1, Spawn Chance = 1/100"}).define("moonLanderSpawnChance", (Object)35);
            this.moonLanderSeperation = builder.translation("config.tardis.structure_seperation").comment(new String[]{"The number of chunks that can seperate two instances of this structure", "This option does not allow decimal points"}).define("moonLanderSeperation", (Object)10);
            this.moonLanderSpacing = builder.translation("config.tardis.structure_spacing").comment(new String[]{"The chunk radius around a potential spawn location in which this structure can spawn.", "Structure Spacing value must be larger than Structure Seperation", "This option does not allow decimal points"}).define("moonLanderSpacing", (Object)15);
            builder.pop();
            builder.push("Observatory");
            builder.push("Plains");
            this.observatorySpawnWeightPlains = builder.translation("config.tardis.village_structure_weight").comment(new String[]{"The spawn weight of the village street which can spawn this structure in villages.", "Higher weight means number of times it can spawn, so more chance of spawning", "Cannot contain decimal points"}).defineInRange("observatorySpawnWeightPlains", 7, 1, 50);
            builder.pop();
            builder.push("Desert");
            this.observatorySpawnWeightDesert = builder.translation("config.tardis.village_structure_weight").comment(new String[]{"The spawn weight of the village street which can spawn this structure in villages.", "Higher weight means number of times it can spawn, so more chance of spawning", "Cannot contain decimal points"}).defineInRange("observatorySpawnWeightDesert", 7, 1, 50);
            builder.pop();
            builder.push("Savanna");
            this.observatorySpawnWeightSavanna = builder.translation("config.tardis.village_structure_weight").comment(new String[]{"The spawn weight of the village street which can spawn this structure in villages.", "Higher weight means number of times it can spawn, so more chance of spawning", "Cannot contain decimal points"}).defineInRange("observatorySpawnWeightSavanna", 6, 1, 50);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.push("Entity Spawns");
            builder.comment(new String[]{"Requires Server Restart to take effect.", "If you don't restart, unknown side effects can occur"});
            this.dalekJoinVillageRaid = builder.translation("config.tardis.dalek_join_village_raid").comment("Toggle if Daleks should spawn in each Village Raid Wave").define("dalekJoinVillageRaid", true);
            this.dalekVillageRaidSpawnCount = builder.translation("config.tardis.dalek_village_raid_spawn_count").comment(new String[]{"Number of Daleks that should spawn in each Village Raid Wave", "The index of the number determines which raid you are setting", "E.g. A list of {0,1,3,5,6,7,8} means the 1st wave will contain 0 Daleks, 2nd wave contains 1 Dalek, 3rd wave contains 3 Daleks, etc."}).defineList("dalekVillageRaidSpawnCount", (List)Lists.newArrayList((Object[])new Integer[]{0, 1, 3, 5, 6, 7, 8}), Integer.class::isInstance);
            builder.pop();
        }
    }

    public static class Server {
        public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedDims;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedDimTypes;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> dimsToHandleTardisVoidTeleport;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> tardisDimEntitySpawnBlacklist;
        public ForgeConfigSpec.ConfigValue<Integer> controlTime;
        public ForgeConfigSpec.ConfigValue<Integer> interiorChangeProcessTime;
        public ForgeConfigSpec.ConfigValue<Integer> interiorChangeCooldownTime;
        public ForgeConfigSpec.ConfigValue<Integer> interiorChangeArtronUse;
        public ForgeConfigSpec.ConfigValue<Integer> tardisAbandonmentTimer;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> botiBlacklistedBlocks;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> botiBlacklistedEntities;
        public ForgeConfigSpec.ConfigValue<Float> FEtoAURate;
        public ForgeConfigSpec.ConfigValue<Integer> exteriorEnergyTransferRate;
        public ForgeConfigSpec.ConfigValue<Integer> transductionEffectiveRange;
        public ForgeConfigSpec.ConfigValue<Integer> transductionEnergyMaxCapacity;
        public ForgeConfigSpec.ConfigValue<Integer> roundelTapEnergyTransferRate;
        public ForgeConfigSpec.ConfigValue<Integer> collisionRange;
        public ForgeConfigSpec.ConfigValue<Float> artronPylonRiftDrainRate;
        public ForgeConfigSpec.ConfigValue<Float> artronCollectorBatteryChargeRate;
        public ForgeConfigSpec.ConfigValue<Integer> transductionDrainAmount;
        public ForgeConfigSpec.BooleanValue toggleVMWhitelistDims;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelistedVMDims;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedVMDims;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedVMDimTypes;
        public ForgeConfigSpec.ConfigValue<Integer> vmTeleportRange;
        public ForgeConfigSpec.ConfigValue<Integer> vmCooldownTime;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> vmSideEffects;
        public ForgeConfigSpec.ConfigValue<List<? extends Integer>> vmSideEffectTime;
        public ForgeConfigSpec.ConfigValue<Integer> vmBaseFuelUsage;
        public ForgeConfigSpec.ConfigValue<Double> vmFuelUsageMultiplier;
        public ForgeConfigSpec.ConfigValue<Integer> vmFuelUsageTime;
        public ForgeConfigSpec.BooleanValue detonateCreeper;
        public ForgeConfigSpec.BooleanValue shearSheep;
        public ForgeConfigSpec.BooleanValue dismantleSkeleton;
        public ForgeConfigSpec.BooleanValue inkSquid;
        public ForgeConfigSpec.BooleanValue detonateTnt;
        public ForgeConfigSpec.BooleanValue redstoneLamps;
        public ForgeConfigSpec.BooleanValue openDoors;
        public ForgeConfigSpec.BooleanValue openTrapDoors;
        public ForgeConfigSpec.BooleanValue coordinateTardis;
        public ForgeConfigSpec.BooleanValue specialWeaponsAlwaysExplode;
        public ForgeConfigSpec.BooleanValue dalekBlockGrief;
        public ForgeConfigSpec.BooleanValue dalekImmuneToProjectiles;
        public ForgeConfigSpec.BooleanValue dalekTargetAllLiving;
        public ForgeConfigSpec.BooleanValue dalekTargetHostileOnly;
        public ForgeConfigSpec.BooleanValue dalekTargetAnimals;
        public ForgeConfigSpec.BooleanValue dalekTargetVillagers;
        public ForgeConfigSpec.BooleanValue dalekTargetPlayers;
        public ForgeConfigSpec.ConfigValue<Double> dalekShieldDisableChance;
        public ForgeConfigSpec.ConfigValue<Integer> specialWeaponExplosionRadius;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Tardis Configurations");
            this.blacklistedDims = builder.translation("config.tardis.blacklistedDims").comment(new String[]{"List of Dimension IDs Tardis cannot travel to, everything else is allowed", "Seperate every entry except the last one with commas"}).defineList("blacklistedDims", (List)Lists.newArrayList((Object[])new String[]{"minecraft:the_end"}), String.class::isInstance);
            this.blacklistedDimTypes = builder.translation("config.tardis.blacklisted_dimension_types").comment(new String[]{"List of DimensionType IDs the Tardis cannot travel to.", "DimensionTypes can be thought of as a group of Dimensions.", "Mods can categorise many Dimensions under one DimensionType.", "Example: Dimension IDs of rftools:my_custom_dimension and rftools:my_other_dimension might share the same DimensionType ID of rftools:fixed_day", "Seperate every entry except the last one with commas"}).defineList("blacklistedDimTypes", (List)Lists.newArrayList((Object[])new String[]{"rftoolsdim:fixed_day", "rftools:fixed_night", "hyperbox:hyperbox"}), String.class::isInstance);
            this.collisionRange = builder.translation("config.tardis.collision").comment(new String[]{"The minimum between two Tardises before a Time Ram event will occur", "If two Tardises are closer than this number, they are considered 'colliding'", "When they collide, a Time Ram event is initiated"}).define("collisionRange", (Object)16, Integer.class::isInstance);
            this.dimsToHandleTardisVoidTeleport = builder.translation("config.tardis.dims_handle_tardis_void_teleport").comment(new String[]{"List of Dimension IDs which cause the Tardis Exterior to be teleported to the Overworld if the exterior goes below the minimum height of this dimension.", "Seperate every entry except the last one with commas"}).defineList("dimsToHandleTardisVoidTeleport", (List)Lists.newArrayList((Object[])new String[]{"tardis:space"}), String.class::isInstance);
            this.exteriorEnergyTransferRate = builder.translation("config.tardis.exterior_energy_transfer_rate").comment("Define how much Forge Energy the Tardis exterior will pull from the Tardis interior's internal energy buffer").define("exteriorEnergyTransferRate", (Object)10, Integer.class::isInstance);
            this.tardisAbandonmentTimer = builder.translation("config.tardis.tardis_abandonment_timer").comment(new String[]{"Define Minecraft days before a Tardis will lose mood from being abandoned by its pilot", "Abandonment occurs if there are no players inside a Tardis interior dimension."}).define("tardisAbandonmentTimer", (Object)1, Integer.class::isInstance);
            this.tardisDimEntitySpawnBlacklist = builder.translation("config.tardis.blacklisted_entity_spawns").comment(new String[]{"List of entity type IDs which cannot spawn in the Tardis", "Seperate every entry except the last one with commas", "Example. minecraft:enderman", "Add an asterisk after the mod id to blacklist all entity types from the specified mod id.", "Example. rats:*"}).defineList("tardisDimEntitySpawnBlacklist", (List)Lists.newArrayList((Object[])new String[]{"rats:demon_rat", "minecraft:enderman"}), String.class::isInstance);
            this.botiBlacklistedBlocks = builder.translation("config.tardis.botiBlacklistedBlocks").comment(new String[]{"List of block ids that will be blacklisted from included in the Bigger On the Inside Portal", "Example: minecraft:tall_grass", "Seperate every entry except the last one with commas", "To blacklist all blocks from a mod, use YourModId:*"}).defineList("botiBlacklistedBlocks", (List)Lists.newArrayList((Object[])new String[]{""}), String.class::isInstance);
            this.botiBlacklistedEntities = builder.translation("config.tardis.botiBlacklistedEntities").comment(new String[]{"List of entity ids that will be blacklisted from being included in the Bigger On the Inside Portal", "Example: minecraft:ender_dragon", "Seperate every entry except the last one with commas", "To blacklist all entities from a mod, use YourModId:*"}).defineList("botiBlacklistedEntities", (List)Lists.newArrayList((Object[])new String[]{""}), String.class::isInstance);
            this.controlTime = builder.translation(TConfig.createTranslationKey("flight_event_time")).comment("The amount of time in seconds at full throttle before missing a flight event").define("flight_event_time", (Object)3, Integer.class::isInstance);
            builder.pop();
            builder.push("Interior Change Configuration");
            this.interiorChangeProcessTime = builder.translation("config.tardis.interiorChangeProcessTime").comment("Sets the seconds of time needed before the Tardis finishes changing its interior").define("interiorChangeProcessTime", (Object)300, Integer.class::isInstance);
            this.interiorChangeCooldownTime = builder.translation("config.tardis.interiorChangeCooldownTime").comment("Sets the seconds of cooldown time between each changing of the Tardis Interior").define("interiorChangeCooldownTime", (Object)60, Integer.class::isInstance);
            this.interiorChangeArtronUse = builder.translation("config.tardis.interiorChangeArtronUse").comment("Sets the amount of Artron fuel required between each changing of the Tardis Interior").define("interiorChangeArtronUse", (Object)100, Integer.class::isInstance);
            builder.pop();
            builder.push("Machines Configuration");
            this.artronPylonRiftDrainRate = builder.translation("config.tardis.machines.artron_pylon_rift_drain_rate").comment("Define how much artron is taken from a Rift Chunk each second by the Artron Pylon Machine").define("artronPylonRiftDrainRate", (Object)Float.valueOf(10.0f), Float.class::isInstance);
            this.artronCollectorBatteryChargeRate = builder.translation("config.tardis.machines.artron_collector_battery_charge_rift").comment("Define how much Artron Units is taken from the Artron Collector each second to charge Artron Batteries").define("artronCollectorBatteryChargeRate", (Object)Float.valueOf(50.0f), Float.class::isInstance);
            this.transductionDrainAmount = builder.translation("config.tardis.machines.transduction_drain_amount").comment("Define how much Artron Units is taken from the Transduction Barrier machine after it blocks a Tardis from landing").define("transductionDrainAmount", (Object)500, Integer.class::isInstance);
            this.transductionEnergyMaxCapacity = builder.translation("config.tardis.machines.transduction_energy_max_capacity").comment("Define the max Forge Energy Capacity for the Transduction Barrier").define("transductionEnergyMaxCapacity", (Object)10000, Integer.class::isInstance);
            this.transductionEffectiveRange = builder.translation("config.tardis.machines.transduction_effective_range").comment("Define the radius around a Transduction Barrier block which Tardises cannot land within").define("transductionEffectiveRange", (Object)32, Integer.class::isInstance);
            this.roundelTapEnergyTransferRate = builder.translation("config.tardis.machines.roundel_tap_energy_transfer_rate").comment("Define how much Forge Energy is transferred to and from the Roundel Tap").define("roundelTapEnergyTransferRate", (Object)10, Integer.class::isInstance);
            builder.pop();
            builder.push("Vortex Manipulator (VM) Configurations");
            builder.push("Travel Configurations");
            this.toggleVMWhitelistDims = builder.translation("config.tardis.vm.toggleVMDimWhitelist").comment("Toggle whether to use the Dimension Whitelist. By default, uses the Blacklist").define("toggleVMWhitelistDims", false);
            this.whitelistedVMDims = builder.translation("config.tardis.vm.whitelistedDims").comment(new String[]{"List of Dimension IDs the VM can travel inside, anything else is not allowed", "Seperate every entry except the last one with commas"}).defineList("whitelistedVMDims", (List)Lists.newArrayList((Object[])new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"}), String.class::isInstance);
            this.blacklistedVMDims = builder.translation("config.tardis.vm.blacklistedDims").comment(new String[]{"List of Dimension IDs the VM cannot travel inside, everything else is allowed", "Seperate every entry except the last one with commas"}).defineList("blacklistedVMDims", (List)Lists.newArrayList((Object[])new String[]{"modID:dimensionName"}), String.class::isInstance);
            this.vmTeleportRange = builder.translation("config.tardis.vm.teleportRange").comment("Sets the maximum Teleport Range the Vortex Manipulator can teleport to").define("vmTeleportRange", (Object)5000, Integer.class::isInstance);
            builder.pop();
            builder.push("Limitations");
            this.vmCooldownTime = builder.translation("config.tardis.vm.cooldownTime").comment("Sets the seconds of cooldown time needed between uses of the Vortex Manipulator").define("vmCooldownTime", (Object)10, Integer.class::isInstance);
            this.vmSideEffects = builder.translation("config.tardis.vm.sideEffects").comment("Sets the effect side effects experienced after using the Vortex Manipulator").defineList("vmSideEffects", (List)Lists.newArrayList((Object[])new String[]{"minecraft:nausea", "minecraft:blindness", "minecraft:weakness"}), String.class::isInstance);
            this.vmSideEffectTime = builder.translation("config.tardis.vm.sideEffectTime").comment(new String[]{"Sets the duration in seconds for each effect in the above value", "The order of the numbers should match each the order of effect in vmSideEffects."}).defineList("vmSideEffectTime", (List)Lists.newArrayList((Object[])new Integer[]{5, 5, 10}), Integer.class::isInstance);
            builder.pop();
            builder.push("Fuel Control");
            this.vmBaseFuelUsage = builder.translation("config.tardis.vm.baseFuelUsage").comment(new String[]{"Sets the base value that scales for how much fuel is used by the VM", "Fuel Usage = YourInputValue + (YourMultiplier * TeleportDistance)", "E.g. If you want the fuel usage to be 20 charge per 100 blocks, you would set the base value to 20 + (0.005 * 100)"}).define("vmBaseFuelUsage", (Object)5, Integer.class::isInstance);
            this.vmFuelUsageMultiplier = builder.translation("config.tardis.vm.fuelUsageMultiplier").comment(new String[]{"Sets the figure that scales how much fuel is used by the VM per amount of seconds set by user", "Fuel Usage = YourBaseInputValue + (YourMultiplier * TeleportDistance)", "E.g. If you want the fuel usage to be 20 charge per 100 blocks, you would set the base value to 20 + (0.005 * 100)"}).define("vmFuelUsageMultiplier", (Object)0.1, Double.class::isInstance);
            this.vmFuelUsageTime = builder.translation("config.tardis.vm.fuelUsageTime").comment("Sets the seconds of time that must elapse before the VM uses up fuel").define("vmFuelUsageTime", (Object)1, Integer.class::isInstance);
            builder.pop();
            builder.pop();
            builder.push("Sonic Screwdriver");
            builder.push("Block Interactions");
            this.detonateTnt = builder.translation("config.tardis.detonate_tnt").comment("Toggle whether sonics can detonate TNT").define("detonate_tnt", true);
            this.redstoneLamps = builder.translation("config.tardis.redstone_lamps").comment("Toggle whether sonics can toggle Lamps").define("redstone_lamps", true);
            this.openDoors = builder.translation("config.tardis.open_doors").comment("Toggle whether sonics can open doors").define("open_doors", true);
            this.openTrapDoors = builder.translation("config.tardis.open_trapdoors").comment("Toggle whether sonics can open Trap doors").define("open_trapdoors", true);
            builder.pop();
            builder.push("Entity Interactions");
            this.detonateCreeper = builder.translation("config.tardis.detonate_creeper").comment("Toggle whether sonics can detonate Creepers").define("detonate_creeper", true);
            this.shearSheep = builder.translation("config.tardis.shear_sheep").comment("Toggle whether sonics can Shear Sheep").define("shear_sheep", true);
            this.dismantleSkeleton = builder.translation("config.tardis.dismantle_skeleton").comment("Toggle whether sonics can dismantle Skeleton like entities").define("dismantle_skeletons", true);
            this.inkSquid = builder.translation("config.tardis.ink_squid").comment("Toggle whether sonics can cause Squids to squirt ink").define("ink_squid", true);
            builder.pop();
            builder.push("Tardis");
            this.coordinateTardis = builder.translation("config.tardis.coordinate_tardis").comment("Toggle whether sonics can tell the Tardis where to land").define("coordinate_tardis", true);
            builder.pop();
            builder.pop();
            builder.push("Mob Entity Configurations");
            builder.push("Daleks");
            this.dalekBlockGrief = builder.translation("config.tardis.dalek.dalek_block_grief").comment(new String[]{"If certain Daleks should be able grief blocks when Gamerule mobGriefing is enabled", "If false, other mobs can still grief blocks, but Daleks will not."}).define("dalekBlockGrief", true);
            this.dalekImmuneToProjectiles = builder.translation("config.tardis.dalek.dalek_immune_projectile").comment(new String[]{"If Daleks will always be immune to projectile damage", "If false, Daleks will only be immune to projectiles in Hard Mode"}).define("dalekImmuneToProjectiles", true);
            this.specialWeaponsAlwaysExplode = builder.translation("config.tardis.dalek_special_weapons_always_explode").comment(new String[]{"If Special Weapon Dalek lasers should always be explosive on impact", "If false, lasers will only make explosions if it hits a block"}).define("specialWeaponsAlwaysExplode", true);
            this.specialWeaponExplosionRadius = builder.translation("config.tardis.dalek.special_weapon_explosion_radius").comment(new String[]{"Radius of the Special Weapon Dalek Explosion, between 1 and 100", "Does not accept decimal points"}).defineInRange("specialWeaponExplosionRadius", 3, 1, 100);
            this.dalekTargetAllLiving = builder.translation("config.tardis.dalek.dalek_target_all").comment(new String[]{"Determine if Daleks should target all living entities.", "If this is false, you can fine tune the targeting, such as hostiles only, or blacklist animals."}).define("dalekTargetAllLiving", true);
            this.dalekTargetHostileOnly = builder.translation("config.tardis.dalek.dalek_target_hostile_only").comment(new String[]{"If Daleks should only target other hostile mobs.", "Requires dalekTargetAllLiving to be false."}).define("dalekTargetHostileOnly", false);
            this.dalekTargetAnimals = builder.translation("config.tardis.dalek.dalek_target_animals").comment(new String[]{"If Daleks should target 'animal' entites such as cows and sheep.", "Requires dalekTargetAllLiving and dalekTargetHostileOnly to be false."}).define("dalekTargetAnimals", true);
            this.dalekTargetVillagers = builder.translation("config.tardis.dalek.dalek_target_villagers").comment(new String[]{"If Daleks should target Villager entities.", "Requires dalekTargetAllLiving and dalekTargetHostileOnly to be false."}).define("dalekTargetVillagers", true);
            this.dalekTargetPlayers = builder.translation("config.tardis.dalek.dalek_target_players").comment(new String[]{"If Daleks should target Player entities.", "Requires dalekTargetAllLiving and dalekTargetHostileOnly to be false"}).define("dalekTargetPlayers", true);
            this.dalekShieldDisableChance = builder.translation("config.tardis.dalek.dalek_disable_shield_chance").comment("Chance to disable shields").defineInRange("dalekShieldDisableChance", 0.1, 0.0, 1.0);
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue openVMEmptyHand;
        public ForgeConfigSpec.BooleanValue interiorShake;
        public ForgeConfigSpec.BooleanValue playToolNotificationSounds;
        public ForgeConfigSpec.BooleanValue enableBoti;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> botiBlacklistedBlocks;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> botiBlacklistedEntities;
        public ForgeConfigSpec.BooleanValue showMoreMachineTooltips;
        public ForgeConfigSpec.BooleanValue displayOptifineWarning;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("Client Settings");
            this.enableBoti = builder.comment(new String[]{"Toggle whether to render the Bigger On the Inside effect on the Tardis Interior Door and Exterior block", "Server Owners: BOTI Packets cannot be disabled on server side because they need to be sent to allow BOTI to update", "BOTI packets will only be processed on the server if the portal needs to update."}).translation("config.tardis.enableBoti").define("enableBoti", true);
            this.botiBlacklistedBlocks = builder.translation("config.tardis.botiBlacklistedBlocks").comment(new String[]{"List block ids that will be blacklisted from rendering in the Bigger On the Inside Effect", "Example: minecraft:tall_grass", "Seperate every entry except the last one with commas", "To blacklist all blocks from a mod, use YourModId:*"}).defineList("botiBlacklistedBlocks", (List)Lists.newArrayList((Object[])new String[]{""}), String.class::isInstance);
            this.botiBlacklistedEntities = builder.translation("config.tardis.botiBlacklistedEntities").comment(new String[]{"List entity ids that will be blacklisted from rendering in the Bigger On the Inside Effect", "Example: minecraft:ender_dragon", "Seperate every entry except the last one with commas", "To blacklist all entities from a mod, use YourModId:*"}).defineList("botiBlacklistedEntities", (List)Lists.newArrayList((Object[])new String[]{""}), String.class::isInstance);
            this.showMoreMachineTooltips = builder.translation("config.tardis.show_more_machine_tooltips").comment("Define if machine tooltips should show more information. E.g. Show Progress in ticks").define("showMoreMachineTooltips", false);
            this.playToolNotificationSounds = builder.translation("config.tardis.play_tool_notification_sound").comment(new String[]{"Define if tools such as the Sonic Screwdriver will play their sounds when notifying the player", "Example: Sonic playing sound when it detects a Rift Chunk"}).define("playToolNotificationSounds", true);
            this.displayOptifineWarning = builder.translation("config.tardis.disable_optifine_warning").comment(new String[]{"Display the Optifine Warning message when logging in", "Use Optifine at your own risk..."}).define("displayOptifineWarning", true);
            builder.push("Vortex Manipulator");
            this.openVMEmptyHand = builder.comment("Toggles whether the Vortex Manipulator in the inventory will open its GUI if the player right clicks with an empty hand").translation("config.tardis.openVMEmptyHand").define("openVMEmptyHand", false);
            builder.pop();
            builder.push("Tardis Client Settings");
            this.interiorShake = builder.comment("Toggles whether to shake the camera during flight or when the exterior is hit").translation("config.tardis.interiorShake").define("interiorShake", true);
            builder.pop();
            builder.pop();
        }
    }
}

