/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.compat.jei.JEIHelper;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.recipe.WeldRecipe;

public class WeldRecipeCategory
implements IRecipeCategory<WeldRecipe> {
    public static final ResourceLocation NAME = new ResourceLocation("tardis", "quantiscope_weld");
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/gui/containers/quantiscope/weld_jei.png");
    private IDrawable background;
    private IDrawable icon;
    private IDrawable arrow;

    public WeldRecipeCategory(IGuiHelper gui) {
        this.background = gui.createDrawable(TEXTURE, 12, 5, 153, 64);
        this.icon = gui.createDrawableIngredient((Object)new ItemStack((IItemProvider)TBlocks.quantiscope_brass.get()));
        this.arrow = gui.drawableBuilder(TEXTURE, 178, 0, 22, 16).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return NAME;
    }

    public Class<WeldRecipe> getRecipeClass() {
        return WeldRecipe.class;
    }

    public String getTitle() {
        return TardisConstants.Translations.QUANTISCOPE_JEI_TITLE.getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(WeldRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)recipe.getResult().get().getOutput()));
    }

    public void draw(WeldRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((Object)recipe, matrixStack, mouseX, mouseY);
        this.arrow.draw(matrixStack, 78, 25);
        int maxProgress = recipe.getProcessingTicks().orElse(200);
        List<ITextComponent> progressText = TextHelper.createProgressBarTooltip(0, maxProgress, true);
        int mouseXPos = (int)mouseX;
        int mouseYPos = (int)mouseY;
        Minecraft mc = Minecraft.func_71410_x();
        if (Helper.isInBounds(mouseXPos, mouseYPos, 75, 25, 100, 40)) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, progressText, (int)mouseXPos, (int)mouseYPos, (int)200, (int)50, (int)100, (FontRenderer)mc.field_71466_p);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, WeldRecipe recipe, IIngredients ingredients) {
        ItemStack[] item = new ItemStack[5];
        List<Ingredient> ingredientList = recipe.getRequiredIngredients();
        JEIHelper.addInputSlot(recipeLayout, 0, 40, 3, JEIHelper.getValidIngredientFromList(0, ingredientList).func_193365_a());
        JEIHelper.addInputSlot(recipeLayout, 1, 19, 3, JEIHelper.getValidIngredientFromList(1, ingredientList).func_193365_a());
        JEIHelper.addInputSlot(recipeLayout, 2, 6, 23, JEIHelper.getValidIngredientFromList(2, ingredientList).func_193365_a());
        JEIHelper.addInputSlot(recipeLayout, 3, 19, 43, JEIHelper.getValidIngredientFromList(3, ingredientList).func_193365_a());
        JEIHelper.addInputSlot(recipeLayout, 4, 40, 43, JEIHelper.getValidIngredientFromList(4, ingredientList).func_193365_a());
        if (recipe.isRepair()) {
            ItemStack repair = new ItemStack((IItemProvider)recipe.getResult().get().getOutput());
            repair.func_196085_b(repair.func_77958_k() - 1);
            JEIHelper.addInputSlot(recipeLayout, 5, 54, 23, repair);
        }
        recipeLayout.getItemStacks().init(6, false, 110, 23);
        recipeLayout.getItemStacks().set(6, new ItemStack((IItemProvider)recipe.getResult().get().getOutput()));
    }
}

