/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.recipe.SpectrometerRecipe;

public class SpectrometerRecipeCategory
implements IRecipeCategory<SpectrometerRecipe> {
    private ResourceLocation TEXTURE = Helper.createRL("textures/gui/containers/spectrometer.png");
    public static final ResourceLocation NAME = new ResourceLocation("tardis", "spectrometer");
    private IDrawable background;
    private IDrawable icon;

    public SpectrometerRecipeCategory(IGuiHelper gui) {
        this.background = gui.createDrawable(this.TEXTURE, 0, 0, 176, 70);
        this.icon = gui.createDrawableIngredient((Object)new ItemStack((IItemProvider)TBlocks.NEUTRONIC_SPECTROMETER.get()));
    }

    public ResourceLocation getUid() {
        return NAME;
    }

    public Class<? extends SpectrometerRecipe> getRecipeClass() {
        return SpectrometerRecipe.class;
    }

    public String getTitle() {
        return TardisConstants.Translations.SPECTROMETER_JEI_TITLE.getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SpectrometerRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ItemStack resultStack = new ItemStack((IItemProvider)TItems.SONIC.get());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)resultStack);
    }

    public void setRecipe(IRecipeLayout recipeLayout, SpectrometerRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 40, 26);
        List<ItemStack> stacksInIngredient = Arrays.asList(recipe.getIngredient().func_193365_a());
        if (!stacksInIngredient.isEmpty()) {
            ArrayList<ItemStack> displayStacks = new ArrayList<ItemStack>();
            for (ItemStack stack : stacksInIngredient) {
                displayStacks.add(stack);
            }
            recipeLayout.getItemStacks().set(0, displayStacks);
        }
        ItemStack resultStack = new ItemStack((IItemProvider)TItems.SONIC.get());
        recipeLayout.getItemStacks().init(1, false, 146, 46);
        recipeLayout.getItemStacks().set(1, resultStack);
    }

    public void draw(SpectrometerRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String text = recipe.getSchematicObject().getDisplayName();
        float scale = 40.0f / (float)fr.func_78256_a(text);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(125.0, 10.0, 0.0);
        if (scale < 1.0f) {
            matrixStack.func_227862_a_(scale, scale, scale);
        }
        fr.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(text), 0.0f, 0.0f, 4516674);
        matrixStack.func_227865_b_();
    }
}

