/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.client.guis.containers.AlembicScreen;
import net.tardis.mod.client.guis.containers.QuantiscopeWeldScreen;
import net.tardis.mod.client.guis.containers.SpectrometerScreen;
import net.tardis.mod.compat.jei.ARSRecipeCategory;
import net.tardis.mod.compat.jei.AlembicRecipeCategory;
import net.tardis.mod.compat.jei.AttunableRecipeCategory;
import net.tardis.mod.compat.jei.SpectrometerRecipeCategory;
import net.tardis.mod.compat.jei.WeldRecipeCategory;
import net.tardis.mod.items.misc.IAttunable;
import net.tardis.mod.recipe.AlembicRecipe;
import net.tardis.mod.recipe.AttunableRecipe;
import net.tardis.mod.recipe.SpectrometerRecipe;
import net.tardis.mod.recipe.WeldRecipe;
import net.tardis.mod.tags.TardisItemTags;

@JeiPlugin
public class JEI
implements IModPlugin {
    public static final ResourceLocation NAME = new ResourceLocation("tardis", "jei");

    public ResourceLocation getPluginUid() {
        return NAME;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(QuantiscopeWeldScreen.class, 85, 30, 24, 16, new ResourceLocation[]{WeldRecipeCategory.NAME});
        registry.addRecipeClickArea(AlembicScreen.class, 89, 30, 23, 16, new ResourceLocation[]{AlembicRecipeCategory.NAME});
        registry.addRecipeClickArea(SpectrometerScreen.class, 108, 25, 33, 35, new ResourceLocation[]{SpectrometerRecipeCategory.NAME});
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new AlembicRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new ARSRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new WeldRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new AttunableRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new SpectrometerRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TBlocks.alembic.get()), new ResourceLocation[]{AlembicRecipeCategory.NAME});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TBlocks.ars_egg.get()), new ResourceLocation[]{ARSRecipeCategory.NAME});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TBlocks.quantiscope_brass.get()), new ResourceLocation[]{WeldRecipeCategory.NAME});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TBlocks.quantiscope_iron.get()), new ResourceLocation[]{WeldRecipeCategory.NAME});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TBlocks.NEUTRONIC_SPECTROMETER.get()), new ResourceLocation[]{SpectrometerRecipeCategory.NAME});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        ClientWorld world = Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
        reg.addRecipes(AlembicRecipe.getAllRecipes((World)world), AlembicRecipeCategory.NAME);
        ArrayList<ARSRecipeCategory.ARSRecipe> ars = new ArrayList<ARSRecipeCategory.ARSRecipe>();
        for (Object item : ForgeRegistries.ITEMS) {
            if (!item.func_206844_a(TardisItemTags.ARS)) continue;
            ars.add(new ARSRecipeCategory.ARSRecipe(new ItemStack((IItemProvider)item)));
        }
        reg.addRecipes(ars, ARSRecipeCategory.NAME);
        reg.addRecipes(WeldRecipe.getAllRecipes((World)world), WeldRecipeCategory.NAME);
        Collection<AttunableRecipe> attunable = AttunableRecipe.getAllRecipes((World)world);
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof IAttunable)) continue;
            IAttunable attunableItem = (IAttunable)item;
            attunable.add(new AttunableRecipe(false, attunableItem.getAttunementTime(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), new AttunableRecipe.RecipeResult(item)).setRegistryId(item.getRegistryName()));
        }
        reg.addRecipes(attunable, AttunableRecipeCategory.NAME);
        Collection<SpectrometerRecipe> spectrometer = SpectrometerRecipe.getAllRecipes((World)world);
        reg.addRecipes(spectrometer, SpectrometerRecipeCategory.NAME);
    }
}

