/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.compat.jei;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.recipe.AlembicRecipe;

public class AlembicRecipeCategory
implements IRecipeCategory<AlembicRecipe> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/gui/containers/alembic.png");
    public static final ResourceLocation NAME = new ResourceLocation("tardis", "alembic");
    private IDrawable background;
    private IDrawable icon;
    private IDrawable arrow;

    public AlembicRecipeCategory(IGuiHelper help) {
        this.background = help.createDrawable(TEXTURE, 4, 3, 169, 67);
        this.icon = help.createDrawableIngredient((Object)new ItemStack((IItemProvider)TBlocks.alembic.get()));
        this.arrow = help.drawableBuilder(TEXTURE, 178, 1, 21, 14).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return NAME;
    }

    public Class<AlembicRecipe> getRecipeClass() {
        return AlembicRecipe.class;
    }

    public String getTitle() {
        return TardisConstants.Translations.ALEMBIC_JEI_TITLE.getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(AlembicRecipe recipe, IIngredients ingre) {
        ingre.setInputIngredients((List)Lists.newArrayList((Object[])new Ingredient[]{recipe.getRequiredBurnableIngredient()}));
        if (!recipe.getResult().func_190926_b()) {
            ingre.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
        } else {
            ingre.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)TItems.MERCURY_BOTTLE.get()));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, AlembicRecipe recipe, IIngredients ingre) {
        if (recipe.getResultType() != AlembicRecipe.ResultType.FLUID_COLLECTION) {
            recipeLayout.getItemStacks().init(0, false, 20, 7);
            recipeLayout.getItemStacks().set(0, recipe.getRequiredWater() != 0 ? new ItemStack((IItemProvider)Items.field_151131_as) : new ItemStack((IItemProvider)Items.field_190931_a));
            recipeLayout.getItemStacks().init(1, false, 20, 43);
            recipeLayout.getItemStacks().set(1, recipe.getRequiredWater() != 0 ? new ItemStack((IItemProvider)Items.field_151133_ar) : new ItemStack((IItemProvider)Items.field_190931_a));
            recipeLayout.getItemStacks().init(2, true, 57, 7);
            ArrayList resultStacks = Lists.newArrayList((Object[])recipe.getRequiredBurnableIngredient().func_193365_a());
            if (!resultStacks.isEmpty()) {
                ArrayList<ItemStack> displayStacks = new ArrayList<ItemStack>();
                for (ItemStack stack : resultStacks) {
                    stack.func_190920_e(recipe.getRequiredIngredientCount());
                    displayStacks.add(stack);
                }
                recipeLayout.getItemStacks().set(2, displayStacks);
            }
            ArrayList burnables = Lists.newArrayList((Object[])Ingredient.func_199805_a((ITag)ItemTags.field_219775_L).func_193365_a());
            recipeLayout.getItemStacks().init(3, false, 57, 43);
            recipeLayout.getItemStacks().set(3, (List)burnables);
            if (!recipe.getResult().func_190926_b()) {
                recipeLayout.getItemStacks().init(4, false, 135, 43);
                recipeLayout.getItemStacks().set(4, recipe.getResult());
            }
        } else {
            recipeLayout.getItemStacks().init(0, false, 135, 7);
            ArrayList fluidCollectionStacks = Lists.newArrayList((Object[])recipe.getFluidCollectionIngredient().func_193365_a());
            ArrayList<ItemStack> displayFluidCollectionStacks = new ArrayList<ItemStack>();
            for (ItemStack stack : fluidCollectionStacks) {
                stack.func_190920_e(recipe.getRequiredIngredientCount());
                displayFluidCollectionStacks.add(stack);
            }
            recipeLayout.getItemStacks().set(0, displayFluidCollectionStacks);
            recipeLayout.getItemStacks().init(1, false, 135, 43);
            recipeLayout.getItemStacks().set(1, recipe.getResult().func_190926_b() ? new ItemStack((IItemProvider)TItems.MERCURY_BOTTLE.get()) : recipe.getResult());
        }
    }

    public void draw(AlembicRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((Object)recipe, matrixStack, mouseX, mouseY);
        this.arrow.draw(matrixStack, 86, 28);
        int mouseXPos = (int)mouseX;
        int mouseYPos = (int)mouseY;
        Minecraft mc = Minecraft.func_71410_x();
        TranslationTextComponent waterName = new TranslationTextComponent(Fluids.field_204546_a.getAttributes().getTranslationKey());
        int requiredNonWaterFluid = recipe.getResultType() == AlembicRecipe.ResultType.FLUID_COLLECTION ? recipe.getRequiredNonWaterFluidAmount() : recipe.getGeneratedFluid();
        List<ITextComponent> nonWaterFluidTankText = TextHelper.createSpecialCaseFluidTankToolTip(requiredNonWaterFluid, 1000, TardisConstants.ContainerComponentTranslations.MERCURY);
        List<ITextComponent> waterTankText = TextHelper.createSpecialCaseFluidTankToolTip(recipe.getRequiredWater(), 1000, (IFormattableTextComponent)waterName);
        List<ITextComponent> progressText = TextHelper.createProgressBarTooltip(0, recipe.getRequiredProgressTicks(), true);
        if (Helper.isInBounds(mouseXPos, mouseYPos, 40, 7, 50, 60)) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, waterTankText, (int)mouseXPos, (int)mouseYPos, (int)150, (int)50, (int)100, (FontRenderer)mc.field_71466_p);
        }
        if (Helper.isInBounds(mouseXPos, mouseYPos, 115, 7, 125, 60)) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, nonWaterFluidTankText, (int)mouseXPos, (int)mouseYPos, (int)100, (int)50, (int)100, (FontRenderer)mc.field_71466_p);
        }
        if (Helper.isInBounds(mouseXPos, mouseYPos, 85, 20, 110, 40)) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, progressText, (int)mouseXPos, (int)mouseYPos, (int)100, (int)50, (int)100, (FontRenderer)mc.field_71466_p);
        }
        mc.field_71446_o.func_110577_a(TEXTURE);
        int waterScaled = (int)(53.0 * (1.0 - (double)recipe.getRequiredWater() / 1000.0));
        int offsetWaterBlit = 53 - (53 - waterScaled);
        Screen.func_238463_a_((MatrixStack)matrixStack, (int)42, (int)(7 + offsetWaterBlit), (float)193.0f, (float)(19 + offsetWaterBlit), (int)10, (int)(53 - offsetWaterBlit), (int)256, (int)256);
        Screen.func_238463_a_((MatrixStack)matrixStack, (int)45, (int)9, (float)182.0f, (float)21.0f, (int)7, (int)49, (int)256, (int)256);
        int nonWaterScaled = (int)(53.0 * (1.0 - (double)requiredNonWaterFluid / 1000.0));
        int offsetNonWaterBlit = 53 - (53 - nonWaterScaled);
        Screen.func_238463_a_((MatrixStack)matrixStack, (int)115, (int)(7 + offsetNonWaterBlit), (float)207.0f, (float)(19 + offsetNonWaterBlit), (int)10, (int)(53 - offsetNonWaterBlit), (int)256, (int)256);
        Screen.func_238463_a_((MatrixStack)matrixStack, (int)118, (int)9, (float)182.0f, (float)21.0f, (int)7, (int)49, (int)256, (int)256);
    }
}

