/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.commands.argument.ConsoleRoomArgument;
import net.tardis.mod.commands.argument.ConsoleUnitArgument;
import net.tardis.mod.commands.argument.ExteriorArgument;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.helper.CommandHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.misc.Console;
import net.tardis.mod.tileentities.ConsoleTile;

public class UnlockCommand
extends TCommand {
    private static int unlockExterior(CommandContext<CommandSource> context, ServerPlayerEntity player, AbstractExterior exterior) {
        return UnlockCommand.unlockExterior(context, player.func_71121_q(), exterior);
    }

    private static int unlockExterior(CommandContext<CommandSource> context, ServerWorld world, AbstractExterior item) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).isPresent()) {
            ConsoleTile console = (ConsoleTile)((Object)TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).orElse(null));
            console.getUnlockManager().addExterior(item);
            TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.unlock.exterior", new Object[]{item.getDisplayName(), tardisIdentifier}), true);
            console.updateClient();
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    private static int unlockAllExteriors(CommandContext<CommandSource> context, ServerWorld world) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).isPresent()) {
            ConsoleTile console = (ConsoleTile)((Object)TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).orElse(null));
            console.getUnlockManager().unlockAllExteriors();
            TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.unlock.exterior_all", new Object[]{tardisIdentifier}), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    private static int unlockInterior(CommandContext<CommandSource> context, ServerPlayerEntity player, ConsoleRoom room) {
        return UnlockCommand.unlockInterior(context, player.func_71121_q(), room);
    }

    private static int unlockInterior(CommandContext<CommandSource> context, ServerWorld world, ConsoleRoom item) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).isPresent()) {
            ConsoleTile console = (ConsoleTile)((Object)TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).orElse(null));
            console.getUnlockManager().addConsoleRoom(item);
            TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.unlock.interior", new Object[]{item.getDisplayName(), tardisIdentifier}), true);
            console.updateClient();
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    private static int unlockAllInteriors(CommandContext<CommandSource> context, ServerWorld world) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).isPresent()) {
            ConsoleTile console = (ConsoleTile)((Object)TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).orElse(null));
            console.getUnlockManager().clearConsoleRoomList();
            console.getUnlockManager().unlockAllConsoleRooms();
            TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.unlock.interior_all", new Object[]{tardisIdentifier}), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    private static int unlockConsoleUnit(CommandContext<CommandSource> context, ServerPlayerEntity player, Console console) {
        return UnlockCommand.unlockConsoleUnit(context, player.func_71121_q(), console);
    }

    private static int unlockConsoleUnit(CommandContext<CommandSource> context, ServerWorld world, Console item) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).isPresent()) {
            ConsoleTile console = (ConsoleTile)((Object)TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).orElse(null));
            console.getUnlockManager().addConsole(item);
            TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.unlock.console", new Object[]{item.getDisplayName(), tardisIdentifier}), true);
            console.updateClient();
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    private static int unlockAllConsoles(CommandContext<CommandSource> context, ServerWorld world) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).isPresent()) {
            ConsoleTile console = (ConsoleTile)((Object)TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).orElse(null));
            if (console != null) {
                console.getUnlockManager().unlockAllConsoles();
                TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.unlock.console_all", new Object[]{tardisIdentifier}), true);
                return 1;
            }
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
            return 0;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"unlock").requires(context -> context.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"exterior").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"*").executes(context -> UnlockCommand.unlockAllExteriors((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h().func_71121_q()))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> UnlockCommand.unlockAllExteriors((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis")))))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"item", (ArgumentType)ExteriorArgument.getExteriorArgument()).executes(context -> UnlockCommand.unlockExterior((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), ExteriorArgument.getExterior((CommandContext<CommandSource>)context, "item")))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> UnlockCommand.unlockExterior((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis"), ExteriorArgument.getExterior((CommandContext<CommandSource>)context, "item"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"interior").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"*").executes(context -> UnlockCommand.unlockAllInteriors((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h().func_71121_q()))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> UnlockCommand.unlockAllInteriors((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis")))))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"item", (ArgumentType)ConsoleRoomArgument.getConsoleRoomArgument()).executes(context -> UnlockCommand.unlockInterior((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), ConsoleRoomArgument.getConsoleRoom((CommandContext<CommandSource>)context, "item")))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> UnlockCommand.unlockInterior((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis"), ConsoleRoomArgument.getConsoleRoom((CommandContext<CommandSource>)context, "item"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"console").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"*").executes(context -> UnlockCommand.unlockAllConsoles((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h().func_71121_q()))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> UnlockCommand.unlockAllConsoles((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis")))))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"item", (ArgumentType)ConsoleUnitArgument.getConsoleUnitArgument()).executes(context -> UnlockCommand.unlockConsoleUnit((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), ConsoleUnitArgument.getConsoleUnit((CommandContext<CommandSource>)context, "item")))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> UnlockCommand.unlockConsoleUnit((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis"), ConsoleUnitArgument.getConsoleUnit((CommandContext<CommandSource>)context, "item"))))))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"connected_tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltipForPlayer(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i(), EntityArgument.func_197089_d((CommandContext)context, (String)"player")))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"exterior").then(Commands.func_197057_a((String)"*").executes(context -> UnlockCommand.unlockAllExteriors((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"connected_tardis"))))).then(Commands.func_197056_a((String)"item", (ArgumentType)ExteriorArgument.getExteriorArgument()).executes(context -> UnlockCommand.unlockExterior((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"connected_tardis"), ExteriorArgument.getExterior((CommandContext<CommandSource>)context, "item")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"interior").then(Commands.func_197057_a((String)"*").executes(context -> UnlockCommand.unlockAllInteriors((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"connected_tardis"))))).then(Commands.func_197056_a((String)"item", (ArgumentType)ConsoleRoomArgument.getConsoleRoomArgument()).executes(context -> UnlockCommand.unlockInterior((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"connected_tardis"), ConsoleRoomArgument.getConsoleRoom((CommandContext<CommandSource>)context, "item")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"console").then(Commands.func_197057_a((String)"*").executes(context -> UnlockCommand.unlockAllConsoles((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"connected_tardis"))))).then(Commands.func_197056_a((String)"item", (ArgumentType)ConsoleUnitArgument.getConsoleUnitArgument()).executes(context -> UnlockCommand.unlockConsoleUnit((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"connected_tardis"), ConsoleUnitArgument.getConsoleUnit((CommandContext<CommandSource>)context, "item")))))));
    }
}

