/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.helper.CommandHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.traits.TardisTrait;

public class TraitsCommand
extends TCommand {
    private static int checkTardisTraits(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        return TraitsCommand.checkTardisTraits(context, player.func_71121_q());
    }

    private static int checkTardisTraits(CommandContext<CommandSource> context, ServerWorld world) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).isPresent()) {
            Optional<ConsoleTile> console = TardisHelper.getConsoleInWorld((World)world);
            console.ifPresent(tile -> tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                TardisTrait[] tardisTraits;
                StringBuilder traits = new StringBuilder();
                for (TardisTrait trait : tardisTraits = tile.getEmotionHandler().getTraits()) {
                    if (trait == null) continue;
                    traits.append(trait.getType().getRegistryName().toString()).append("\n");
                }
                TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world, data);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.traits.check", new Object[]{tardisIdentifier, traits.toString()}), true);
            }));
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    private static int regenerateTardisTraits(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        return TraitsCommand.regenerateTardisTraits(context, player.func_71121_q());
    }

    private static int regenerateTardisTraits(CommandContext<CommandSource> context, ServerWorld world) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).isPresent()) {
            Optional<ConsoleTile> console = TardisHelper.getConsoleInWorld((World)world);
            console.ifPresent(tile -> tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                TardisTrait[] tardisTraits;
                tile.getEmotionHandler().regenerateTraits();
                StringBuilder traits = new StringBuilder();
                for (TardisTrait trait : tardisTraits = tile.getEmotionHandler().getTraits()) {
                    if (trait == null) continue;
                    traits.append(trait.getType().getRegistryName().toString()).append("\n");
                }
                TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world, data);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.traits.regenerate", new Object[]{tardisIdentifier, traits.toString()}), true);
            }));
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"traits").requires(context -> context.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"check").executes(context -> TraitsCommand.checkTardisTraits((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> TraitsCommand.checkTardisTraits((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"regenerate").executes(context -> TraitsCommand.regenerateTardisTraits((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> TraitsCommand.regenerateTardisTraits((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis")))));
    }
}

