/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.helper.TardisHelper;

public class TardisNameCommand
extends TCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_TARDISES = (context, suggestionBuilder) -> {
        Set<RegistryKey<World>> collection = TardisHelper.getTardisWorldKeys(((CommandSource)context.getSource()).func_197028_i());
        return ISuggestionProvider.func_212476_a(collection.stream().map(RegistryKey::func_240901_a_), (SuggestionsBuilder)suggestionBuilder);
    };

    private static int findDimForTardisName(CommandContext<CommandSource> context, MinecraftServer server, String tardisName) {
        Set<RegistryKey<World>> matchingWorlds = TardisHelper.getTardisWorldKeyByName(server, tardisName);
        if (matchingWorlds.isEmpty()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.name.matching_dim.fail", new Object[]{tardisName}));
            return 0;
        }
        for (RegistryKey<World> worldKey : matchingWorlds) {
            String dimName = worldKey.func_240901_a_().toString();
            IFormattableTextComponent suggestion = new TranslationTextComponent("\n==== Tardis Name ===\n%s\n=== Dimension ID ===\n%s", new Object[]{tardisName, dimName}).func_230529_a_((ITextComponent)new StringTextComponent("\n[Click to Copy]").func_240699_a_(TextFormatting.RED)).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, dimName)));
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.name.matching_dim.success", new Object[]{suggestion}), true);
        }
        return 1;
    }

    private static int findTardisNameForDim(CommandContext<CommandSource> context, MinecraftServer server, ServerWorld world) {
        Set<String> matchingNames = TardisHelper.getTardisNamesByWorldKey(server, (RegistryKey<World>)world.func_234923_W_());
        if (matchingNames.isEmpty()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.name.matching_name.fail", new Object[]{world.func_234923_W_()}));
            return 0;
        }
        for (String name : matchingNames) {
            String dimName = world.func_234923_W_().func_240901_a_().toString();
            IFormattableTextComponent suggestion = new TranslationTextComponent("\n==== Dimension ID ===\n%s\n=== Tardis Name ===\n%s", new Object[]{dimName, name}).func_230529_a_((ITextComponent)new StringTextComponent("\n[Click to Copy]").func_240699_a_(TextFormatting.RED)).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, name)));
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.name.matching_name.success", new Object[]{suggestion}), true);
        }
        return 1;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"find").requires(context -> context.func_197034_c(2))).then(Commands.func_197057_a((String)"tardis_name").then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).suggests(SUGGEST_TARDISES).executes(context -> TardisNameCommand.findTardisNameForDim((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197028_i(), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension")))))).then(Commands.func_197057_a((String)"world_key").then(Commands.func_197056_a((String)"tardis_name", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(TardisHelper.getTardisNames(((CommandSource)context.getSource()).func_197028_i()), (SuggestionsBuilder)suggestionBuilder)).executes(context -> TardisNameCommand.findDimForTardisName((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197028_i(), StringArgumentType.getString((CommandContext)context, (String)"tardis_name")))));
    }
}

