/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.helper.CommandHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.items.KeyItem;
import net.tardis.mod.items.TItems;
import net.tardis.mod.subsystem.AntennaSubsystem;
import net.tardis.mod.subsystem.ChameleonSubsystem;
import net.tardis.mod.subsystem.FlightSubsystem;
import net.tardis.mod.subsystem.FluidLinksSubsystem;
import net.tardis.mod.subsystem.NavComSubsystem;
import net.tardis.mod.subsystem.ShieldGeneratorSubsystem;
import net.tardis.mod.subsystem.StabilizerSubsystem;
import net.tardis.mod.subsystem.TemporalGraceSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.inventory.PanelInventory;

public class SetupCommand
extends TCommand {
    private static int setUpTardis(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        ItemStack key = new ItemStack((IItemProvider)TItems.KEY.get());
        ServerWorld world = player.func_71121_q();
        if (TardisHelper.getConsoleInWorld((World)world).isPresent()) {
            if (key.func_77973_b() instanceof KeyItem) {
                KeyItem key2 = (KeyItem)key.func_77973_b();
                ItemStack attunedKey = key2.onAttuned(key, TardisHelper.getConsoleInWorld((World)world).get());
                if (attunedKey != null) {
                    player.func_191521_c(attunedKey);
                } else {
                    player.func_191521_c(key);
                }
            }
            return SetupCommand.setUpTardis(context, world);
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    private static int setUpTardis(CommandContext<CommandSource> context, ServerWorld world) {
        Optional<ConsoleTile> console = TardisHelper.getConsoleInWorld((World)world);
        CommandSource source = (CommandSource)context.getSource();
        console.ifPresent(tile -> tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
            PanelInventory inv = data.getEngineInventoryForSide(Direction.NORTH);
            tile.getSubsystem(FlightSubsystem.class).ifPresent(flight -> {
                inv.setStackInSlot(0, new ItemStack((IItemProvider)flight.getItemKey()));
                flight.setActivated(true);
            });
            tile.getSubsystem(NavComSubsystem.class).ifPresent(navcom -> {
                inv.setStackInSlot(1, new ItemStack((IItemProvider)navcom.getItemKey()));
                navcom.setActivated(true);
            });
            tile.getSubsystem(ChameleonSubsystem.class).ifPresent(chameleon -> {
                inv.setStackInSlot(2, new ItemStack((IItemProvider)chameleon.getItemKey()));
                chameleon.setActivated(true);
            });
            tile.getSubsystem(TemporalGraceSubsystem.class).ifPresent(grace -> {
                inv.setStackInSlot(3, new ItemStack((IItemProvider)grace.getItemKey()));
                grace.setActivated(true);
            });
            tile.getSubsystem(FluidLinksSubsystem.class).ifPresent(links -> {
                inv.setStackInSlot(4, new ItemStack((IItemProvider)links.getItemKey()));
                links.setActivated(true);
            });
            tile.getSubsystem(StabilizerSubsystem.class).ifPresent(stabilizer -> {
                inv.setStackInSlot(5, new ItemStack((IItemProvider)stabilizer.getItemKey()));
                stabilizer.setActivated(true);
            });
            tile.getSubsystem(AntennaSubsystem.class).ifPresent(antenna -> {
                inv.setStackInSlot(6, new ItemStack((IItemProvider)antenna.getItemKey()));
                antenna.setActivated(true);
            });
            tile.getSubsystem(ShieldGeneratorSubsystem.class).ifPresent(shield -> {
                inv.setStackInSlot(7, new ItemStack((IItemProvider)shield.getItemKey()));
                shield.setActivated(true);
            });
            PanelInventory artronInv = data.getEngineInventoryForSide(Direction.WEST);
            for (int i = 0; i < artronInv.getSlots(); ++i) {
                artronInv.setStackInSlot(i, new ItemStack((IItemProvider)TItems.ARTRON_CAPACITOR_HIGH.get()));
            }
            TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world, data);
            tile.updateArtronValues();
            tile.setArtron(Float.MAX_VALUE);
            tile.updateClient();
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.setup.success", new Object[]{tardisIdentifier}), true);
        }));
        return 1;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"setup").requires(context -> context.func_197034_c(2))).executes(context -> SetupCommand.setUpTardis((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> SetupCommand.setUpTardis((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis"))));
    }
}

