/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.WorldHelper;

public class RiftCommand
extends TCommand {
    private static int findRift(CommandSource source, ServerWorld sWorld, ILocationArgument searchPos, int chunkRadius) {
        return RiftCommand.findRift(source, sWorld, searchPos.func_197280_c(source), chunkRadius);
    }

    private static int findRift(CommandSource source, ServerWorld sWorld, BlockPos searchPos, int chunkRadius) {
        TextComponent riftStartPosText = TextHelper.createTextComponentWithTipSuggest(WorldHelper.formatBlockPosDebug(searchPos).toString(), "/tp @p " + WorldHelper.formatBlockPosDebug(searchPos).toString());
        StringTextComponent riftPositionsText = new StringTextComponent("");
        riftPositionsText.func_240700_a_(style -> {
            style.func_240712_a_(TextFormatting.WHITE);
            style.func_240716_a_(null);
            style.func_240715_a_(null);
            return style;
        });
        HashSet riftPositions = new HashSet();
        for (int x = 0; x < chunkRadius; ++x) {
            for (int z = 0; z < chunkRadius; ++z) {
                ChunkPos cPos = new ChunkPos(searchPos);
                int newChunkX = cPos.field_77276_a + x;
                int newChunkZ = cPos.field_77275_b + z;
                ChunkPos newCPos = new ChunkPos(newChunkX, newChunkZ);
                Chunk c = sWorld.func_212866_a_(newCPos.field_77276_a, newCPos.field_77275_b);
                if (!c.getCapability(Capabilities.RIFT).isPresent()) continue;
                c.getCapability(Capabilities.RIFT).ifPresent(rift -> {
                    if (rift.isRift()) {
                        BlockPos foundPos = new BlockPos(newCPos.func_180334_c(), searchPos.func_177956_o(), newCPos.func_180333_d());
                        riftPositions.add(foundPos);
                    }
                });
            }
        }
        for (BlockPos pos : riftPositions) {
            TextComponent riftPos = TextHelper.createTextComponentWithTip(WorldHelper.formatBlockPosDebug(pos).toString(), "/tp @p " + WorldHelper.formatBlockPosDebug(pos).toString());
            StringTextComponent riftPositionString = new StringTextComponent("\n");
            riftPositionsText.func_230529_a_((ITextComponent)riftPos).func_230529_a_((ITextComponent)riftPositionString);
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.rift.find.success", new Object[]{chunkRadius, riftStartPosText, riftPositionsText}), true);
        return 1;
    }

    private static int getRiftEnergy(CommandSource source, ServerWorld sWorld, ILocationArgument searchPos) {
        return RiftCommand.getRiftEnergy(source, sWorld, searchPos.func_197280_c(source));
    }

    private static int getRiftEnergy(CommandSource source, ServerWorld sWorld, BlockPos searchPos) {
        TextComponent riftPosText = TextHelper.createTextComponentWithTip(WorldHelper.formatBlockPosDebug(searchPos).toString(), "/tp @p " + WorldHelper.formatBlockPosDebug(searchPos).toString());
        Chunk c = sWorld.func_175726_f(searchPos);
        if (c.getCapability(Capabilities.RIFT).isPresent()) {
            c.getCapability(Capabilities.RIFT).ifPresent(rift -> {
                if (rift.isRift()) {
                    source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.rift.get_energy.success", new Object[]{riftPosText, Float.valueOf(rift.getRiftEnergy())}), true);
                } else {
                    source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.rift.find.error", new Object[]{riftPosText}));
                }
            });
            return 1;
        }
        source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.rift.find.error", new Object[]{riftPosText}));
        return 0;
    }

    private static int addRiftEnergy(CommandSource source, ServerWorld sWorld, float addAmount, ILocationArgument searchPos) {
        return RiftCommand.addRiftEnergy(source, sWorld, addAmount, searchPos.func_197280_c(source));
    }

    private static int addRiftEnergy(CommandSource source, ServerWorld sWorld, float addAmount, BlockPos searchPos) {
        TextComponent riftPosText = TextHelper.createTextComponentWithTip(WorldHelper.formatBlockPosDebug(searchPos).toString(), "/tp @p " + WorldHelper.formatBlockPosDebug(searchPos).toString());
        Chunk c = sWorld.func_175726_f(searchPos);
        if (c.getCapability(Capabilities.RIFT).isPresent()) {
            c.getCapability(Capabilities.RIFT).ifPresent(rift -> {
                if (rift.isRift()) {
                    rift.addEnergy(addAmount);
                    source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.rift.add_energy.success", new Object[]{Float.valueOf(addAmount), riftPosText, Float.valueOf(rift.getRiftEnergy())}), true);
                } else {
                    source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.rift.find.error", new Object[]{riftPosText}));
                }
            });
            return 1;
        }
        source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.rift.find.error", new Object[]{riftPosText}));
        return 0;
    }

    private static int createOrRemoveRift(CommandSource source, ServerWorld sWorld, ILocationArgument searchPos, boolean create) {
        return RiftCommand.createOrRemoveRift(source, sWorld, searchPos.func_197280_c(source), create);
    }

    private static int createOrRemoveRift(CommandSource source, ServerWorld sWorld, BlockPos searchPos, boolean create) {
        TextComponent riftPosText = TextHelper.createTextComponentWithTip(WorldHelper.formatBlockPosDebug(searchPos).toString(), "/tp @p " + WorldHelper.formatBlockPosDebug(searchPos).toString());
        Chunk c = sWorld.func_175726_f(searchPos);
        if (c.getCapability(Capabilities.RIFT).isPresent()) {
            c.getCapability(Capabilities.RIFT).ifPresent(rift -> {
                rift.setRift(create);
                String feedbackTranslationKey = create ? "command.tardis.rift.create_rift.success" : "command.tardis.rift.remove_rift.success";
                source.func_197030_a((ITextComponent)new TranslationTextComponent(feedbackTranslationKey, new Object[]{Float.valueOf(rift.getRiftEnergy()), riftPosText}), true);
            });
            return 1;
        }
        source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.rift.find.error", new Object[]{riftPosText}));
        return 0;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"rift").requires(context -> context.func_197034_c(2))).then(Commands.func_197057_a((String)"find").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"start_location", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> RiftCommand.findRift((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"start_location"), 10))).then(Commands.func_197056_a((String)"chunk_radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> RiftCommand.findRift((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"start_location"), IntegerArgumentType.getInteger((CommandContext)context, (String)"chunk_radius"))))))).then(Commands.func_197057_a((String)"create").then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> RiftCommand.createOrRemoveRift((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"location"), true))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> RiftCommand.createOrRemoveRift((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"location"), false))))).then(Commands.func_197057_a((String)"get_energy").then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> RiftCommand.getRiftEnergy((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"location")))))).then(Commands.func_197057_a((String)"add_energy").then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).then(Commands.func_197056_a((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> RiftCommand.addRiftEnergy((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"), Vec3Argument.func_200385_b((CommandContext)context, (String)"location"))))));
    }
}

