/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.CommandHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.ArtronUse;

public class RefuelCommand
extends TCommand {
    private static int checkTardisFuel(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        return RefuelCommand.checkTardisFuel(context, player.func_71121_q());
    }

    private static int checkTardisFuel(CommandContext<CommandSource> context, ServerWorld world) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsoleInWorld((World)world).isPresent()) {
            Optional<ConsoleTile> console = TardisHelper.getConsoleInWorld((World)world);
            console.ifPresent(tile -> tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                StringTextComponent artronUsesTextComponent = new StringTextComponent("");
                artronUsesTextComponent.func_240700_a_(style -> {
                    style.func_240712_a_(TextFormatting.WHITE);
                    style.func_240716_a_(null);
                    style.func_240715_a_(null);
                    return style;
                });
                IFormattableTextComponent totalFuel = new StringTextComponent(Float.toString(tile.getArtron())).func_230529_a_((ITextComponent)TardisConstants.Suffix.ARTRON_UNITS);
                IFormattableTextComponent maxFuel = new StringTextComponent(Float.toString(tile.getMaxArtron())).func_230529_a_((ITextComponent)TardisConstants.Suffix.ARTRON_UNITS);
                for (ArtronUse use : tile.getArtronUses().values()) {
                    if (use == null || !use.isActive()) continue;
                    TranslationTextComponent useName = use.getType().getTranslation();
                    float usePerTick = use.getArtronUsePerTick() * 20.0f;
                    StringTextComponent artronUseValue = new StringTextComponent(" - " + useName.getString() + ": " + usePerTick + " AU/s\n");
                    artronUsesTextComponent.func_230529_a_((ITextComponent)artronUseValue);
                }
                TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world, data);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.refuel.check", new Object[]{tardisIdentifier, totalFuel, maxFuel, artronUsesTextComponent}), true);
            }));
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    private static int addFuel(CommandContext<CommandSource> context, ServerPlayerEntity player, int value) {
        return RefuelCommand.addFuel(context, player.func_71121_q(), player, value);
    }

    private static int addFuel(CommandContext<CommandSource> context, ServerWorld world, ServerPlayerEntity player, int value) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsoleInWorld((World)world).isPresent()) {
            Optional<ConsoleTile> console = TardisHelper.getConsoleInWorld((World)world);
            console.ifPresent(tile -> tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                tile.setArtron(tile.getArtron() + (float)value);
                TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world, data);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.refuel.success", new Object[]{tardisIdentifier, Float.valueOf(tile.getArtron())}), true);
            }));
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"refuel").requires(context -> context.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"check").executes(context -> RefuelCommand.checkTardisFuel((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> RefuelCommand.checkTardisFuel((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis")))))).then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> RefuelCommand.addFuel((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> RefuelCommand.addFuel((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis"), ((CommandSource)context.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))));
    }
}

