/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.commands.argument.MissionStageArgument;
import net.tardis.mod.commands.argument.MissionTypeArgument;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.missions.MiniMission;
import net.tardis.mod.missions.MiniMissionType;
import net.tardis.mod.missions.stages.MissionStage;

public class MissionCommand
extends TCommand {
    private static boolean successfulObjectiveUpdate = false;
    private static boolean successfulStageUpdate = false;

    private static int spawnMission(CommandSource source, MiniMissionType missionType, ServerWorld sWorld, ILocationArgument startPos) {
        return MissionCommand.spawnMission(source, missionType, sWorld, startPos.func_197280_c(source));
    }

    private static int spawnMission(CommandSource source, MiniMissionType missionType, ServerWorld sWorld, BlockPos startPos) {
        if (missionType != null) {
            if (sWorld.getCapability(Capabilities.MISSION).isPresent()) {
                Structure missionStructure = ((StructureFeature)sWorld.func_73046_m().func_244267_aX().func_243612_b((RegistryKey)Registry.field_243553_av).func_243576_d(missionType.getStructureKey())).field_236268_b_;
                BlockPos spawnPos = missionType.spawnAndFindNearestMission(sWorld, sWorld.func_241112_a_(), startPos, 5000, true, sWorld.func_72905_C(), sWorld.func_72863_F().func_201711_g().func_235957_b_().func_236197_a_(missionStructure));
                TextComponent spawnedPosText = TextHelper.createTextWithoutTooltip("/tp @p " + WorldHelper.formatBlockPosDebug(spawnPos).toString());
                if (!spawnPos.equals((Object)BlockPos.field_177992_a)) {
                    source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.spawn.success", new Object[]{missionType.getRegistryName(), spawnedPosText}), false);
                    return 1;
                }
                source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.spawn.fail", new Object[]{missionType.getRegistryName(), spawnedPosText}));
                return 0;
            }
            source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.invalid_mission_world", new Object[]{sWorld.func_234923_W_().func_240901_a_()}));
            return 0;
        }
        source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.invalid_mission"));
        return 0;
    }

    private static int getMissionStage(CommandSource source, ServerWorld sWorld, ILocationArgument missionPos) {
        return MissionCommand.getMissionStage(source, sWorld, missionPos.func_197280_c(source));
    }

    private static int getMissionStage(CommandSource source, ServerWorld sWorld, BlockPos missionPos) {
        TextComponent spawnedPosText = TextHelper.createTextWithoutTooltip(WorldHelper.formatBlockPosDebug(missionPos).toString());
        if (sWorld.getCapability(Capabilities.MISSION).isPresent()) {
            sWorld.getCapability(Capabilities.MISSION).ifPresent(cap -> {
                MiniMission mission = cap.getMissionForPos(missionPos);
                if (mission != null) {
                    MissionStage currentStage = mission.getCurrentStage();
                    source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.stage_get.success", new Object[]{mission.getType().getRegistryName(), spawnedPosText, currentStage.getRegistryName().toString()}), false);
                } else {
                    source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.no_mission_found_at_pos", new Object[]{spawnedPosText}));
                }
            });
            return 1;
        }
        source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.invalid_mission_world", new Object[]{sWorld.func_234923_W_().func_240901_a_()}));
        return 0;
    }

    private static int setMissionStage(CommandSource source, ServerWorld sWorld, ILocationArgument missionPos, MissionStage stage) {
        return MissionCommand.setMissionStage(source, sWorld, missionPos.func_197280_c(source), stage);
    }

    private static int setMissionStage(CommandSource source, ServerWorld sWorld, BlockPos missionPos, MissionStage stage) {
        TextComponent spawnedPosText = TextHelper.createTextWithoutTooltip(WorldHelper.formatBlockPosDebug(missionPos).toString());
        if (sWorld.getCapability(Capabilities.MISSION).isPresent()) {
            sWorld.getCapability(Capabilities.MISSION).ifPresent(cap -> {
                MiniMission mission = cap.getMissionForPos(missionPos);
                if (mission != null) {
                    mission.setCurrentStage(stage);
                    mission.setObjective(0);
                    mission.setAwarded(false);
                    source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.stage_update.success", new Object[]{stage.getRegistryName().toString(), mission.getType().getRegistryName(), spawnedPosText}), false);
                    successfulStageUpdate = true;
                } else {
                    successfulStageUpdate = false;
                    source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.no_mission_found_at_pos", new Object[]{spawnedPosText}));
                }
            });
            if (successfulStageUpdate) {
                return 1;
            }
            return 0;
        }
        source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.invalid_mission_world", new Object[]{sWorld.func_234923_W_().func_240901_a_()}));
        return 0;
    }

    private static int getMissionObjective(CommandSource source, ServerWorld sWorld, ILocationArgument missionPos) {
        return MissionCommand.getMissionObjective(source, sWorld, missionPos.func_197280_c(source));
    }

    private static int getMissionObjective(CommandSource source, ServerWorld sWorld, BlockPos missionPos) {
        return MissionCommand.getMissionObjective(source, sWorld, missionPos, MissionCommand.getCurrentMissionStage(sWorld, missionPos));
    }

    private static int getMissionObjective(CommandSource source, ServerWorld sWorld, BlockPos missionPos, MissionStage stage) {
        TextComponent spawnedPosText = TextHelper.createTextWithoutTooltip(WorldHelper.formatBlockPosDebug(missionPos).toString());
        if (sWorld.getCapability(Capabilities.MISSION).isPresent()) {
            sWorld.getCapability(Capabilities.MISSION).ifPresent(cap -> {
                MiniMission mission = cap.getMissionForPos(missionPos);
                if (mission != null) {
                    MissionStage stageFound = mission.getStageByKey(stage.getRegistryName());
                    if (stageFound != null) {
                        int objectiveIndex = mission.getStageByKey(stage.getRegistryName()).getCurrentObjectiveIndex();
                        source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.objective_get.success", new Object[]{mission.getType().getRegistryName(), spawnedPosText, objectiveIndex, stage.getRegistryName().toString()}), false);
                    } else {
                        source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.no_stage_found_for_mission", new Object[]{mission.getType().getRegistryName(), spawnedPosText}));
                    }
                } else {
                    source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.no_mission_found_at_pos", new Object[]{spawnedPosText}));
                }
            });
            return 1;
        }
        source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.invalid_mission_world", new Object[]{sWorld.func_234923_W_().func_240901_a_()}));
        return 0;
    }

    private static int setMissionObjective(CommandSource source, ServerWorld sWorld, ILocationArgument missionPos, MissionStage stage, int objective) {
        return MissionCommand.setMissionObjective(source, sWorld, missionPos.func_197280_c(source), stage, objective);
    }

    private static int setMissionObjective(CommandSource source, ServerWorld sWorld, BlockPos missionPos, MissionStage stage, int objective) {
        TextComponent spawnedPosText = TextHelper.createTextWithoutTooltip(WorldHelper.formatBlockPosDebug(missionPos).toString());
        if (sWorld.getCapability(Capabilities.MISSION).isPresent()) {
            sWorld.getCapability(Capabilities.MISSION).ifPresent(cap -> {
                MiniMission mission = cap.getMissionForPos(missionPos);
                if (mission != null) {
                    mission.setObjectiveForStage(stage.getRegistryName(), objective);
                    mission.setAwarded(false);
                    source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.objective_update.success", new Object[]{stage.getRegistryName().toString(), mission.getType().getRegistryName(), spawnedPosText, mission.getCurrentObjective()}), false);
                    successfulObjectiveUpdate = true;
                } else {
                    successfulObjectiveUpdate = false;
                    source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.no_mission_found_at_pos", new Object[]{spawnedPosText}));
                }
            });
            if (successfulObjectiveUpdate) {
                return 1;
            }
            return 0;
        }
        source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.mission.invalid_mission_world", new Object[]{sWorld.func_234923_W_().func_240901_a_()}));
        return 0;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"mission").requires(context -> context.func_197034_c(2))).then(Commands.func_197057_a((String)"spawn").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)MissionTypeArgument.getMissionTypeArgument()).executes(context -> MissionCommand.spawnMission((CommandSource)context.getSource(), MissionTypeArgument.getMissionType((CommandContext<CommandSource>)context, "type"), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), ((CommandSource)context.getSource()).func_197035_h().func_233580_cy_()))).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> MissionCommand.spawnMission((CommandSource)context.getSource(), MissionTypeArgument.getMissionType((CommandContext<CommandSource>)context, "type"), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"location"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"objective").executes(context -> MissionCommand.getMissionObjective((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), ((CommandSource)context.getSource()).func_197035_h().func_233580_cy_(), MissionCommand.getCurrentMissionStage(((CommandSource)context.getSource()).func_197035_h().func_71121_q(), ((CommandSource)context.getSource()).func_197035_h().func_233580_cy_())))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"mission_location", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> MissionCommand.getMissionObjective((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"mission_location")))).then(Commands.func_197056_a((String)"stage_type", (ArgumentType)MissionStageArgument.getMissionStageArgument()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197014_a(MissionCommand.getMissionStagesFromMission((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)context, (String)"mission_location")), (SuggestionsBuilder)suggestionBuilder)).executes(context -> MissionCommand.getMissionObjective((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"mission_location").func_197280_c((CommandSource)context.getSource()), MissionStageArgument.getMissionStage((CommandContext<CommandSource>)context, "stage_type"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"stage").executes(context -> MissionCommand.getMissionStage((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), ((CommandSource)context.getSource()).func_197035_h().func_233580_cy_()))).then(Commands.func_197056_a((String)"mission_location", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> MissionCommand.getMissionStage((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"mission_location"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").then(Commands.func_197057_a((String)"objective").then(Commands.func_197056_a((String)"mission_location", (ArgumentType)Vec3Argument.func_197301_a()).then(Commands.func_197056_a((String)"stage", (ArgumentType)MissionStageArgument.getMissionStageArgument()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197014_a(MissionCommand.getMissionStagesFromMission((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)context, (String)"mission_location")), (SuggestionsBuilder)suggestionBuilder)).then(Commands.func_197056_a((String)"objective_level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> MissionCommand.setMissionObjective((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"mission_location"), MissionStageArgument.getMissionStage((CommandContext<CommandSource>)context, "stage"), IntegerArgumentType.getInteger((CommandContext)context, (String)"objective_level")))))))).then(Commands.func_197057_a((String)"stage").then(Commands.func_197056_a((String)"mission_location", (ArgumentType)Vec3Argument.func_197301_a()).then(Commands.func_197056_a((String)"stage_type", (ArgumentType)MissionStageArgument.getMissionStageArgument()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197014_a(MissionCommand.getMissionStagesFromMission((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197023_e(), Vec3Argument.func_200385_b((CommandContext)context, (String)"mission_location")), (SuggestionsBuilder)suggestionBuilder)).executes(context -> MissionCommand.setMissionStage((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), Vec3Argument.func_200385_b((CommandContext)context, (String)"mission_location"), MissionStageArgument.getMissionStage((CommandContext<CommandSource>)context, "stage_type")))))));
    }

    public static Collection<ResourceLocation> getMissionStagesFromMission(CommandSource source, ServerWorld sWorld, ILocationArgument missionPos) {
        return MissionCommand.getMissionStagesFromMission(source, sWorld, missionPos.func_197280_c(source));
    }

    public static Collection<ResourceLocation> getMissionStagesFromMission(CommandSource source, ServerWorld sWorld, BlockPos missionPos) {
        ArrayList stages = Lists.newArrayList();
        sWorld.getCapability(Capabilities.MISSION).ifPresent(cap -> {
            MiniMission mission = cap.getMissionForPos(missionPos);
            for (MissionStage stage : mission.getStages().values()) {
                if (stage.getRegistryName() == null) continue;
                stages.add(stage.getRegistryName());
            }
        });
        return stages;
    }

    public static MissionStage getCurrentMissionStage(ServerWorld sWorld, BlockPos missionPos) {
        ArrayList stages = Lists.newArrayList();
        sWorld.getCapability(Capabilities.MISSION).ifPresent(cap -> {
            MiniMission mission = cap.getMissionForPos(missionPos);
            stages.add(mission.getCurrentStage());
        });
        return (MissionStage)((Object)stages.get(0));
    }
}

