/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.helper.CommandHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.EmotionHandler;

public class LoyaltyCommand
extends TCommand {
    private static int checkTardisLoyalty(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        return LoyaltyCommand.checkTardisLoyalty(context, player.func_71121_q());
    }

    private static int checkTardisLoyalty(CommandContext<CommandSource> context, ServerWorld world) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).isPresent()) {
            Optional<ConsoleTile> console = TardisHelper.getConsoleInWorld((World)world);
            console.ifPresent(tile -> tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                EmotionHandler emotionHandler = tile.getEmotionHandler();
                StringTextComponent playerLoyaltiesTextComponent = new StringTextComponent("");
                playerLoyaltiesTextComponent.func_240700_a_(style -> {
                    style.func_240712_a_(TextFormatting.WHITE);
                    style.func_240716_a_(null);
                    style.func_240715_a_(null);
                    return style;
                });
                Set<UUID> crew = emotionHandler.getLoyaltyTrackingCrew();
                for (UUID id : crew) {
                    if (id == null) continue;
                    TextComponent thisPlayer = TextHelper.getPlayerTextObject(world, id);
                    StringTextComponent loyaltyValue = new StringTextComponent(String.format(": (%d)\n", emotionHandler.getLoyalty(id)));
                    playerLoyaltiesTextComponent.func_230529_a_((ITextComponent)thisPlayer).func_230529_a_((ITextComponent)loyaltyValue);
                }
                TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world, data);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.loyalty.check", new Object[]{tardisIdentifier, playerLoyaltiesTextComponent}), true);
            }));
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    private static int addTardisLoyalty(CommandContext<CommandSource> context, ServerPlayerEntity player, int value) {
        return LoyaltyCommand.addTardisLoyalty(context, player.func_71121_q(), player, value);
    }

    private static int addTardisLoyalty(CommandContext<CommandSource> context, ServerWorld world, ServerPlayerEntity player, int value) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsole(((CommandSource)context.getSource()).func_197028_i(), (World)world).isPresent()) {
            Optional<ConsoleTile> console = TardisHelper.getConsoleInWorld((World)world);
            console.ifPresent(tile -> tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                EmotionHandler emotionHandler = tile.getEmotionHandler();
                if (emotionHandler.getLoyaltyTrackingCrew().contains(player.func_110124_au())) {
                    emotionHandler.addLoyalty((PlayerEntity)player, value);
                    TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world, data);
                    source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.loyalty.success", new Object[]{tardisIdentifier, player.func_200200_C_(), emotionHandler.getLoyalty(player.func_110124_au())}), true);
                } else {
                    source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.loyalty.no_player_found", new Object[]{player.func_145748_c_()}));
                }
            }));
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"loyalty").requires(context -> context.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"check").executes(context -> LoyaltyCommand.checkTardisLoyalty((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> LoyaltyCommand.checkTardisLoyalty((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis")))))).then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> LoyaltyCommand.addTardisLoyalty((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> LoyaltyCommand.addTardisLoyalty((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis"), ((CommandSource)context.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> LoyaltyCommand.addTardisLoyalty((CommandContext<CommandSource>)context, DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis"), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))));
    }
}

