/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.CommandHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.WorldHelper;

public class InteriorCommand
extends TCommand {
    private static int teleportEntityToInterior(CommandContext<CommandSource> context, Entity entityToTeleport, ServerWorld target) {
        CommandSource source = (CommandSource)context.getSource();
        if (TardisHelper.getConsoleInWorld((World)target).isPresent()) {
            WorldHelper.teleportEntities(entityToTeleport, target, (double)TardisHelper.TARDIS_POS.func_177958_n() + 0.5, TardisHelper.TARDIS_POS.func_177956_o() + 1, (double)TardisHelper.TARDIS_POS.func_177952_p() + 0.5, entityToTeleport.field_70125_A, entityToTeleport.field_70177_z);
            TardisHelper.getConsole(source.func_197028_i(), (World)target).ifPresent(tile -> tile.getDoor().ifPresent(door -> door.setOpenState(EnumDoorState.CLOSED)));
            TextComponent tardisIdentifier = TextHelper.getTardisDimObject(target);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.interior.success", new Object[]{entityToTeleport.func_145748_c_(), tardisIdentifier}), true);
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{target.func_234923_W_().func_240901_a_().toString()}));
        return 0;
    }

    private static int teleportToInterior(CommandContext<CommandSource> context, ServerPlayerEntity playerToTeleport, ServerWorld target) throws CommandSyntaxException {
        return InteriorCommand.teleportEntityToInterior(context, (Entity)playerToTeleport, target);
    }

    private static int teleportToInterior(CommandContext<CommandSource> context, Collection<? extends Entity> entitiesToTeleport, ServerWorld target) throws CommandSyntaxException {
        entitiesToTeleport.forEach(entity -> InteriorCommand.teleportEntityToInterior(context, entity, target));
        return 1;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"interior").requires(context -> context.func_197034_c(2))).executes(context -> InteriorCommand.teleportToInterior((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), ((CommandSource)context.getSource()).func_197035_h().func_71121_q()))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> InteriorCommand.teleportToInterior((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis"))))).then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> InteriorCommand.teleportToInterior((CommandContext<CommandSource>)context, EntityArgument.func_197090_e((CommandContext)context, (String)"players"), DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis")))));
    }
}

