/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.commands.argument.DisguiseArgument;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.Disguise;

public class DisguiseCommand
extends TCommand {
    private static int placeDisguiseBlocks(CommandSource source, Disguise disguise, ServerWorld world, BlockPos pos) {
        if (disguise != null) {
            if (!disguise.getOtherBlocks().isEmpty()) {
                for (Map.Entry<BlockPos, BlockState> entry : disguise.getOtherBlocks().entrySet()) {
                    world.func_180501_a(pos.func_177971_a((Vector3i)entry.getKey()), entry.getValue(), 3);
                }
            }
            world.func_180501_a(pos.func_177977_b(), disguise.getBottomState(), 3);
            world.func_180501_a(pos, disguise.getTopState(), 3);
            TextComponent spawnedPosText = TextHelper.createTextWithoutTooltip("/tp @p " + WorldHelper.formatBlockPosDebug(pos).toString());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.disguise.spawn.success", new Object[]{disguise.getRegistryName(), spawnedPosText}), false);
            return 1;
        }
        source.func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.disguise.invalid_disguise"));
        return 0;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"disguise").requires(context -> context.func_197034_c(2))).then(Commands.func_197057_a((String)"spawn").then(Commands.func_197056_a((String)"type", (ArgumentType)DisguiseArgument.getDisguiseArgument()).executes(context -> DisguiseCommand.placeDisguiseBlocks((CommandSource)context.getSource(), DisguiseArgument.getDisguise((CommandContext<CommandSource>)context, "type"), ((CommandSource)context.getSource()).func_197035_h().func_71121_q(), ((CommandSource)context.getSource()).func_197035_h().func_233580_cy_()))));
    }
}

