/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.commands.argument.ConsoleRoomArgument;
import net.tardis.mod.commands.argument.ConsoleUnitArgument;
import net.tardis.mod.commands.argument.ExteriorArgument;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.misc.Console;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;

public class CreateCommand
extends TCommand {
    private static int createTardis(CommandSource source, ServerWorld sWorld, AbstractExterior ext, ConsoleRoom room, Console console) {
        BlockPos sourcePos = new BlockPos(source.func_197036_d().field_72450_a, source.func_197036_d().field_72448_b, source.func_197036_d().field_72449_c).func_177972_a(Direction.NORTH);
        BlockPos placePos = sourcePos.func_177984_a();
        if (room != null) {
            ServerWorld tardisInteriorWorld = TardisHelper.setupTardisDim(sWorld.func_73046_m(), console.getState(), room);
            TardisHelper.getConsoleInWorld((World)tardisInteriorWorld).ifPresent(tile -> {
                tile.getUnlockManager().addConsole(console);
                tile.getUnlockManager().addConsoleRoom(room);
                tile.getUnlockManager().addExterior(ext);
                tile.setExteriorType(ext);
                tile.setCurrentLocation((RegistryKey<World>)sWorld.func_234923_W_(), sourcePos);
                tile.setDestination((RegistryKey<World>)sWorld.func_234923_W_(), sourcePos);
                tile.getExteriorType().place((ConsoleTile)((Object)tile), (RegistryKey<World>)sWorld.func_234923_W_(), placePos);
                tile.getExteriorType().getExteriorTile((ConsoleTile)((Object)tile)).setInteriorDimensionKey((World)tardisInteriorWorld);
                tile.getExteriorType().getExteriorTile((ConsoleTile)((Object)tile)).setDoorState(EnumDoorState.ONE);
                if (source.func_197022_f() instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)source.func_197022_f();
                    tile.getEmotionHandler().addLoyalty(player, 100);
                }
            });
            sWorld.func_184133_a(null, sourcePos, (SoundEvent)TSounds.DOOR_UNLOCK.get(), SoundCategory.BLOCKS, 0.75f, 1.0f);
            TextComponent tardisDimName = TextHelper.getTardisDimObject(tardisInteriorWorld);
            TextComponent exteriorName = TextHelper.createTextComponentWithTip(ext.getDisplayName().getString(), ext.getRegistryName().toString());
            TextComponent roomName = TextHelper.createTextComponentWithTip(room.getDisplayName().getString(), room.getRegistryName().toString());
            TextComponent consoleUnitName = TextHelper.createTextComponentWithTip(console.getDisplayName().getString(), console.getRegistryName().toString());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.create.success", new Object[]{tardisDimName, exteriorName, roomName, consoleUnitName}), true);
        }
        return 1;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"create").requires(context -> context.func_197034_c(2))).then(Commands.func_197056_a((String)"exterior", (ArgumentType)ExteriorArgument.getExteriorArgument()).then(Commands.func_197056_a((String)"interior", (ArgumentType)ConsoleRoomArgument.getConsoleRoomArgument()).then(Commands.func_197056_a((String)"console_unit", (ArgumentType)ConsoleUnitArgument.getConsoleUnitArgument()).executes(context -> CreateCommand.createTardis((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197023_e(), ExteriorArgument.getExterior((CommandContext<CommandSource>)context, "exterior"), ConsoleRoomArgument.getConsoleRoom((CommandContext<CommandSource>)context, "interior"), ConsoleUnitArgument.getConsoleUnit((CommandContext<CommandSource>)context, "console_unit"))))));
    }
}

