/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.commands.subcommands.TCommand;
import net.tardis.mod.helper.CommandHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.items.misc.AttunableItem;
import net.tardis.mod.items.misc.IAttunable;
import net.tardis.mod.recipe.AttunableRecipe;
import net.tardis.mod.tileentities.ConsoleTile;

public class AttuneItemCommand
extends TCommand {
    private static AttunableRecipe selectedRecipe;

    private static int attuneHeldItemForCurrentTardis(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        return AttuneItemCommand.attuneHeldItemForTardis(context, player, player.func_71121_q());
    }

    private static int attuneHeldItemForTardis(CommandContext<CommandSource> context, ServerPlayerEntity player, ServerWorld world) {
        ItemStack heldStack = player.func_184614_ca() == null || player.func_184614_ca().func_190926_b() ? player.func_184592_cb() : player.func_184614_ca();
        boolean isValid = false;
        for (AttunableRecipe recipe : AttunableRecipe.getAllRecipes((World)world)) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.getInputIngredient().func_193365_a()[0], (ItemStack)heldStack)) continue;
            isValid = true;
            selectedRecipe = recipe;
        }
        if (heldStack != null && !heldStack.func_190926_b() && (heldStack.func_77973_b() instanceof IAttunable || isValid)) {
            if (!TardisHelper.getConsoleInWorld((World)world).isPresent()) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.tardis.no_tardis_found", new Object[]{world.func_234923_W_().func_240901_a_().toString()}));
                return 0;
            }
            TardisHelper.getConsoleInWorld((World)world).ifPresent(tile -> tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                if (heldStack.func_77973_b() instanceof IAttunable) {
                    IAttunable attunable = (IAttunable)heldStack.func_77973_b();
                    attunable.onAttuned(heldStack, (ConsoleTile)((Object)tile));
                } else if (selectedRecipe != null) {
                    ItemStack result = selectedRecipe.func_77571_b();
                    if (heldStack.func_190916_E() > result.func_190916_E()) {
                        result.func_190920_e(heldStack.func_190916_E());
                    }
                    result = selectedRecipe.shouldAddNBTTags() ? AttunableItem.completeAttunement(result, tile) : result;
                    int slot = player.field_71071_by.func_184429_b(heldStack);
                    player.field_71071_by.func_70304_b(slot);
                    player.field_71071_by.func_191971_c(slot, result);
                }
                TextComponent tardisIdentifier = TextHelper.getTardisDimObject(world, data);
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.tardis.attune.success", new Object[]{heldStack.func_200301_q().getString(), tardisIdentifier}), true);
            }));
            return 1;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.tardis.attune.invalid", new Object[]{heldStack.func_200301_q().getString()}));
        return 0;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"attune_item").requires(context -> context.func_197034_c(2))).executes(context -> AttuneItemCommand.attuneHeldItemForCurrentTardis((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"tardis", (ArgumentType)DimensionArgument.func_212595_a()).suggests((context, suggestionBuilder) -> ISuggestionProvider.func_197005_b(Collections.emptyList(), (SuggestionsBuilder)CommandHelper.addTardisKeysWithNameTooltip(suggestionBuilder, ((CommandSource)context.getSource()).func_197028_i()))).executes(context -> AttuneItemCommand.attuneHeldItemForTardis((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), DimensionArgument.func_212592_a((CommandContext)context, (String)"tardis"))));
    }
}

