/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.world.dimensions.TDimensions;

public class TardisWorldArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> EXAMPLES = Stream.of(World.field_234918_g_, World.field_234919_h_).map(worldKey -> worldKey.func_240901_a_().toString()).collect(Collectors.toList());
    private static final DynamicCommandExceptionType INVALID_DIMENSION_EXCEPTION = new DynamicCommandExceptionType(worldKey -> new TranslationTextComponent("argument.tardis.dimension.invalid", new Object[]{worldKey}));

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        return ResourceLocation.func_195826_a((StringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList<RegistryKey> tardisWorldKeys = new ArrayList<RegistryKey>();
        if (context.getSource() instanceof CommandSource) {
            CommandSource commandSource = (CommandSource)context.getSource();
            for (RegistryKey worldKey : commandSource.func_230390_p_()) {
                World world = (World)commandSource.func_197028_i().func_244267_aX().func_243612_b(Registry.field_239699_ae_).func_230516_a_(worldKey);
                RegistryKey worldTypeKey = commandSource.func_197028_i().func_244267_aX().func_230520_a_().func_230519_c_((Object)world.func_230315_m_()).orElse(DimensionType.field_235999_c_);
                if (worldTypeKey != TDimensions.DimensionTypes.TARDIS_TYPE) continue;
                tardisWorldKeys.add(worldKey);
            }
        }
        return context.getSource() instanceof CommandSource ? ISuggestionProvider.func_212476_a(tardisWorldKeys.stream().map(RegistryKey::func_240901_a_), (SuggestionsBuilder)builder) : Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static TardisWorldArgument getDimensionArgument() {
        return new TardisWorldArgument();
    }

    public static ServerWorld getTardisWorld(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        ResourceLocation resourcelocation = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        RegistryKey registrykey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)resourcelocation);
        ServerWorld serverworld = ((CommandSource)context.getSource()).func_197028_i().func_71218_a(registrykey);
        if (serverworld == null) {
            throw INVALID_DIMENSION_EXCEPTION.create((Object)resourcelocation);
        }
        return serverworld;
    }
}

